<?php
## Include this, if you do not use auto_prepend
## include("prepend.php3");

  include($_PHPLIB["libdir"] . "table.inc");
  
  page_open(array("sess" => "Example_Session", "auth" => "Example_Auth", "perm" => "Example_Perm"));
  $perm->check("admin");

  ## Create a subclass of table specifically to override table_cell in order to handle
  ## the base64-encoded session data
  class Base64_Table extends Table {

    var $enc_methods = array(
      "base64"  => array("enc" => "base64_encode", "dec" => "base64_decode"),
      "slashes" => array("enc" => "addslashes",    "dec" => "stripslashes")
    );
    var $encoding_mode = "base64";


	 function table_cell($row, $col, $key, $val, $class="")
    {
      $this->table_cell_open($class);
      if( $key=="val") {
        # get encoding method from (method:value) pair
        $colon_pos = strpos($val,':');
        $str_method = substr ( $val , 0 , $colon_pos );
        $str_value  = substr ( $val , $colon_pos + 1 );
        if( empty($str_method) ) {  
            $cmd = $this->enc_methods[$this->encoding_mode]["dec"];
        } else {
            $cmd  = $this->enc_methods[$str_method]["dec"];
        };
        $dec_val  = $cmd($str_value);
        printf("<FONT COLOR=\"green\"><EM>Decoded using %s:</EM></FONT><BR>%s", $cmd, htmlentities($dec_val));
      } else {
        printf("%s", htmlentities($val));
		};
      $this->table_cell_close($class);
    }
  };


  ## We need a database connection and a table object for later...
  $db = new DB_Example;
  $t  = new Base64_Table;
  $t->heading = "on";
  $t->check   = "sid";
?>
<html>
<head>
 <title>View Session Table</title>
 <style type="text/css">
  table.data { background-color: #eeeeee; border-width: 0; padding: 4 }
  th.data    { background-color: #cccccc; font-family: arial, helvetica, sans-serif }
  td.data    { horizontal-align: left; vertical-align: top; font-family: arial, helvetica, sans-serif }
  h2.gc      { color: #44bb44; font-family: arial, helvetica, sans-serif }
  h1         { font-family: arial, helvetica, sans-serif }
 </style>
</head>

<body bgcolor="#ffffff">
<h1>active_sessions</h1>

<?php
##
## Act on submission
##

## Handle gc: manual garbage collection
if( !isset( $gc ) ) { $gc = ""; };
if ($gc != "") {
  printf("<h2 class=gc>Manual garbage collection performed...</h2>\n");
  $sess->gc();  
}

if( !isset( $del ) ) { $del = false; };
if ($del) {
  $sum = 0;

  if (is_array($sid)) {
    reset($sid);
    while(list($k, $v) = each($sid)) {
      $query = sprintf("delete from %s where name = '%s' and sid = '%s'",
                 $sess->that->database_table,
                 $sess->name,
                 $k);
      $db->query($query);
      $sum += $db->affected_rows();
    }
  }
  
  printf("<h2 class=gc>$sum sessions deleted...</h2>\n");
  
}

##
## Generate form
##

?>
<form method=post action="<?php $sess->pself_url() ?>">
<table class=data width=100%>
 <tr class=data>
  <td class=data width="75%">&nbsp;</td>
  <td class=data align=right><input type="submit" name="refresh" value="Refresh"></td>
  <td class=data align=right><input type="submit" name="gc"      value="Garbage Collect"></td>
  <td class=data align=right><input type="submit" name="del"     value="Delete Selected"></td>
 </tr>
</table>
<?php
    
  $query = sprintf("select * from active_sessions where name = '%s' order by name asc, changed desc",
              $sess->name);
  $db->query($query);

  $t->show_result($db, "data");
?>
<table class=data width=100%>
 <tr class=data>
  <td class=data width="75%">&nbsp;</td>
  <td class=data align=right><input type="submit" name="refresh" value="Refresh"></td>
  <td class=data align=right><input type="submit" name="gc"      value="Garbage Collect"></td>
  <td class=data align=right><input type="submit" name="del"     value="Delete Selected"></td>
 </tr>
</table>
</form>
<?php page_close() ?>
<!-- $Id: view_sessions.php3,v 1.8 1999/10/29 10:14:58 athompso Exp $ -->
</body>
</html>
