// TabulatedConstituent:  definition of a constituent that uses tabulated
// equilibrium arguments and node factors.
// Last modified by DWF 1999-10-17

/*
    Copyright (C) 1998  David Flater.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

class TabulatedConstituent: public Constituent {
public:

  // By default, a constituent gets all zeros for eq. args, unity for
  // the node factors, and 0 for speed.
  TabulatedConstituent ();
  TabulatedConstituent (Dstr &in_name);
  TabulatedConstituent (Constituent &in_con);
  virtual ~TabulatedConstituent();

  TabulatedConstituent &operator= (Constituent &in_con);

  // Set speed for TabulatedConstituents only
  void speed (Speed in_speed);
  Speed speed ();
  // This should be redundant -- workaround for bug in
  // Sun WorkShop Compiler C++ SPARC Version 5.000
  // Error: Could not find a match for TabulatedConstituent::speed(DegreesPerHour).
  void speed (DegreesPerHour in_speed);

  Angle arg (Year in_year);   // Equilibrium arguments
  double nod (Year in_year);  // Node factors

  Year firstvalidyear();
  Year lastvalidyear();

  // Read from file
  void readnameandspeed (FILE *fp);
  void readarg (FILE *fp, Year first_year, Year last_year);
  void readnod (FILE *fp, Year first_year, Year last_year);
  // Read from Dstr
  void readnameandspeed (Dstr &in_name_speed);

  // Add a constituent to this one.
  TabulatedConstituent &operator += (Constituent &in_con);
  // Multiply this constituent by a factor.
  TabulatedConstituent &operator *= (double factor);
  TabulatedConstituent &operator *= (int factor);

  // This is useless outside of this class, but the Sparc compiler
  // demands that it be declared public.
  class Argfac {
  public:
    Argfac();  // Sets arg = 0, nod = 1
    Argfac (Angle in_arg, double in_nod);
    Angle arg;
    double nod;
  };

protected:

  class ArgfacVector {
  protected:
    Argfac a[globallastyear-globalfirstyear+1];
  public:
    Argfac &operator[] (Year in_year);
  };

  ArgfacVector myargfacs;
  Year myfirstvalidyear, mylastvalidyear;
  int readargs, readnods;

  void check_valid (Year in_year);

};
