/*
The DsTool program is the property of:
 
                             Cornell University 
                        Center of Applied Mathematics 
                              Ithaca, NY 14853
                      dstool_bugs@macomb.tn.cornell.edu
 
and may be used, modified and distributed freely, subject to the following
restrictions:
 
       Any product which incorporates source code from the DsTool
       program or utilities, in whole or in part, is distributed
       with a copy of that source code, including this notice. You
       must give the recipients all the rights that you have with
       respect to the use of this software. Modifications of the
       software must carry prominent notices stating who changed
       the files and the date of any change.
 
DsTool is distributed in the hope that it will be useful, but WITHOUT ANY 
WARRANTY; without even the implied warranty of FITNESS FOR A PARTICULAR PURPOSE.
The software is provided as is without any obligation on the part of Cornell 
faculty, staff or students to assist in its use, correction, modification or
enhancement.
*/

/*
 * interrupt.c
 *
 * Routines for the interrupt signal control.
 *
 */

#include <sys/time.h>
#include <sys/times.h>

#include <constants.h>
#include <utilities.h>

static int stop_flag;

/*
struct timeval lasttime = {0,0};
struct timezone tz = {0, DST_NONE};
*/
struct timeval lasttime = {0,0};
struct timezone tz = {0, 0};

int
interrupt()
{
  struct timeval thistime;
  long dt = 1000000;  /* 10^6 microseconds = 1 sec */

  /* find out how much time has passed since lasttime the screen was updated */
  if (gettimeofday(&thistime,&tz) == 0)
    {
      dt = dt * (thistime.tv_sec - lasttime.tv_sec) +
	(thistime.tv_usec - lasttime.tv_usec);
    }
  
  if (dt > 100000)
    {
      /* more than 0.1 secs have passed so update the screen
	 allowing Ctrl-C to be accepted */
      tcl_update();
      lasttime.tv_sec = thistime.tv_sec;
      lasttime.tv_usec = thistime.tv_usec;
    }

  return stop_flag;
}


void
  set_interrupt()
{
  stop_flag = TRUE;
}


void
  reset_interrupt()
{
  stop_flag = FALSE;
}
