/*
The DsTool program is the property of:
 
                             Cornell University 
                        Center of Applied Mathematics 
                              Ithaca, NY 14853
                      dstool_bugs@macomb.tn.cornell.edu
 
and may be used, modified and distributed freely, subject to the following
restrictions:
 
       Any product which incorporates source code from the DsTool
       program or utilities, in whole or in part, is distributed
       with a copy of that source code, including this notice. You
       must give the recipients all the rights that you have with
       respect to the use of this software. Modifications of the
       software must carry prominent notices stating who changed
       the files and the date of any change.
 
DsTool is distributed in the hope that it will be useful, but WITHOUT ANY 
WARRANTY; without even the implied warranty of FITNESS FOR A PARTICULAR PURPOSE.
The software is provided as is without any obligation on the part of Cornell 
faculty, staff or students to assist in its use, correction, modification or
enhancement.
*/

/*
 * map.c
 *
 * map_init()
 */

#include <stdio.h>

#include "pm.h"
#include "prop.h"
#include "constants.h"
#include "defaults.h"
#include "flow.h"

static int		ifield_values[]={10,15};
static double           dfield_values[]={1.e-5,1.0e-8,1.0e-8};
static int		cfield_values[] = {0,0,0};
static char		*ifield_names[]={"#MC: ","Newton iter:"};
static char		*dfield_names[]={FINITE_DIFFERENCE_STEP_STRING,
					 "Min step: ","Conv crit: "};
static char		*cfield_names[] = {"Jacobian:", "Initial guess: ",
					   "Inverse algorithm:"};
static int		cfield_num_choices[] = {2,2,1};
static char             *choice0[] =  {"Forward difference",
					  "Central difference",
				       "Explicit"};
static char             *choice1[] = {"Monte Carlo",
				      "Approximate inverse"};
static char             *choice2[] = {"Newton's method",
				      "Explicit formula"};
static char		**all_choices[] = {choice0, choice1, choice2};


void
load_iter()
{
  Int_Algol.Ifield_Names = ifield_names;
  Int_Algol.Dfield_Names = dfield_names;
  Int_Algol.Sel_Labels = cfield_names;
  Int_Algol.Num_Ifields = sizeof(ifield_names)/sizeof(char *);
  Int_Algol.Num_Dfields = sizeof(dfield_names)/sizeof(char *);
  Int_Algol.Num_Sel_Items = sizeof(cfield_names)/sizeof(char *);
  Int_Algol.Num_Sel_Choices = cfield_num_choices;
  Int_Algol.Ifields = ifield_values;
  Int_Algol.Dfields = dfield_values;
  Int_Algol.Sel_Values = cfield_values;
  Int_Algol.Sel_Choices = all_choices;

  if( *((int *) pm( GET, "Model.Explicit_Inverse", NULL ))) {

    /* analytic inverse exists */
    cfield_num_choices[2] = 2; /* allow analytic inverse */
    cfield_values[2] = 1; /* select it */
    
    /* no approx inverse exists */
    cfield_num_choices[1] = 1;
    cfield_values[1] = 0;
    
  } else {
    
    /* APPROX_INV or no inverse */
    cfield_num_choices[2] = 1; /* don't allow analytic inverse */
    cfield_values[2] = 0; /* select Newton method */
    
    if ( *((int *) pm(GET, "Model.Inverse_Flag", NULL))) {
      
      /* approx inverse exists */
      cfield_num_choices[1] = 2;
      cfield_values[1] = 1;
      
    } else {
      
      /* no approx inverse exists */
      cfield_num_choices[1] = 1;
      cfield_values[1] = 0;

    }

  }

  if ( *((int *) pm (GET, "Model.Jacobian_Flag", NULL))) {
    
    /* jacobian exists */
    cfield_num_choices[0] = 3; /* allow explicit jacobian option */
    cfield_values[0] = 2; /* select this option */

  } else {

    /* jacobian does not exist */
    cfield_num_choices[0] = 2; /* don't allow explicit jacobian option */
    cfield_values[0] = 0; /* select forward differencing */

  }

  /* reset fields */
  Int_Algol.Ifields[0] = 10; /* some Monte Carlo guesses */
  Int_Algol.Ifields[1] = 15;
  Int_Algol.Dfields[0] = 1.0e-5;
  Int_Algol.Dfields[1] = 1.0e-8;
  Int_Algol.Dfields[2] = 1.0e-8;

  prop_to_pm();

}


