/*
The DsTool program is the property of:
 
                             Cornell University 
                        Center of Applied Mathematics 
                              Ithaca, NY 14853
                      dstool_bugs@macomb.tn.cornell.edu
 
and may be used, modified and distributed freely, subject to the following
restrictions:
 
       Any product which incorporates source code from the DsTool
       program or utilities, in whole or in part, is distributed
       with a copy of that source code, including this notice. You
       must give the recipients all the rights that you have with
       respect to the use of this software. Modifications of the
       software must carry prominent notices stating who changed
       the files and the date of any change.
 
DsTool is distributed in the hope that it will be useful, but WITHOUT ANY 
WARRANTY; without even the implied warranty of FITNESS FOR A PARTICULAR PURPOSE.
The software is provided as is without any obligation on the part of Cornell 
faculty, staff or students to assist in its use, correction, modification or
enhancement.
*/

/*
 * view.h
 */

#ifndef VIEW_h
#define VIEW_h

#include "tkPlot.h"
#include "memory.h"
#include "complib.h"

#define ON_ONED 1
#define ON_TWOD 2
#define ON_THREED 4
#define ON_ALL (ON_ONED | ON_TWOD | ON_THREED)

typedef int (*PLOT_FN_PTR)(struct Prop_DataS *, int, int, double *);


typedef enum {
  TWOD = 100, ONED, GEOMVIEW,
  VARB, PARAM, FUNCT,
  RANGE, DISMISS, ACTIVATE, CONFIG, COLORMODE
} WIN_t;

struct Key
{
  char      *word;
  int       index;
};

/* global variable declarations */
extern struct Key win_key[];
extern char *win_keyindex();
extern int win_keyword();

typedef struct oned_View
{
  double hormin;
  double hormax;
  double vermin;
  double vermax;
  int width;
  int height;
  int colormode;
  int iterate;
  ClientData clientData;
} ONED_VIEW_ITEM;

typedef struct twod_View
{
  int hortype;       /* Varb, Param, Funct */
  int horindex;
  int vertype;       /* Varb, Param, Funct */
  int verindex;
  double hormin;
  double hormax;
  double vermin;
  double vermax;
  int width;
  int height;
  int colormode;
  ClientData clientData;
} TWOD_VIEW_ITEM;

typedef struct View
{
  int            type;         /* TWOD, ONED, GEOMVIEW */
  int            number;
  union {
    ONED_VIEW_ITEM oned;
    TWOD_VIEW_ITEM twod;
  } data;
  struct View    *next_View;
} VIEW_ITEM;



/* global variable declarations */
extern VIEW_ITEM *Views;
extern double *view_f;     /* plotting routines use some preallocated stuff */
extern int (*view_auxf)(double [], double [], double []); /* for speed of execution */



/* declarations from view.c */
VIEW_ITEM *add_view(int type, int number);
void dismiss_view(int type, int number);
VIEW_ITEM *get_view(int type, int number);
void dump_views(void);
void view_plot_mem(memory m);

/* declarations from twod.c */
void twod_dump(VIEW_ITEM* view);
void twod_mem(VIEW_ITEM* view, memory m);
void twod_all_mem(VIEW_ITEM *view);
void twod_activate(int n);
void twod_config(int n, int width, int height);
void twod_range(int n, int hortype, int horindex, double hormin, double hormax,
	   int vertype, int verindex, double vermin, double vermax);
void twod_dismiss(int n);
void twod_point(int n, int x, int y, int color, int symbol);
void twod_size(int n);
void twod_colormode(int n, int cmode);

/* declarations from oned.c */
void oned_mem(VIEW_ITEM* view, memory m);
void oned_all_mem(VIEW_ITEM *view);
void oned_activate(int n);
void oned_config(int n, int width, int height);
void oned_range(int n, double hormin, double hormax,
		double vermin, double vermax, int iterate);
void oned_dismiss(int n);
void oned_size(int n);
void oned_function(void);
void oned_colormode(int n, int mode);
void oned_line(VIEW_ITEM *v, double x1, double y1, double x2, double y2,
	       int color);

/* declarations from gv.c */
void gv_config(int n, int hortype, int horindex, double hormin, double hormax,
	       int vertype, int verindex, double vermin, double vermax);
void gv_activate(int n);
void gv_dismiss(int n);
void gv_size(int n);
void gv_allmem(int xtypes[], int xindices[], double mins[], double maxs[]);

/* declarations from tkPlot.c */
int Plot_Init(Tcl_Interp *interp);
void Tk_PlotSymbol(TkPlot *plotPtr, int x, int y, int color, int symbol, unsigned int size);
XColor *Tk_PlotGetColor(int i);
XColor *Tk_PlotGetRGB(int i);
int Tk_PlotGetNColors(void);

/* win_register.c */
int win_keyword(char *word);
char *win_keyindex(int i);

/* point_plot.c */
int point_plot(double *x, double *p, int color, int symbol);

/* traj_plot.c */
int traj_plot(struct Prop_DataS *prop_cntl, int start_ptr, int stop_ptr,
	      double *func_values);


#endif /* VIEW_h */
