# Copyright (c) 1996, 1997, 1998 The Regents of the University of California.
# All rights reserved.  See legal notices for full text and disclaimer.

"""Utility routines for dealing with contexts"""
import sys
import types

def resolve_context (context):
    "Resolve a context to a dictionary item."
    tc = type (context)
    if tc == types.DictType:
        return context
    elif tc == types.StringType:
        try:
            return sys.modules[context].__dict__
        except KeyError:
            raise KeyError, "Bad context: no module named " + \
                context
    elif tc == types.ModuleType:
        return context.__dict__
    else:
        raise TypeError, "Bad context, cannot handle type " + `tc`

if __name__ == "__main__":
    t = resolve_context ("sys")
    u = resolve_context (sys)
    v = resolve_context (sys.__dict__)
    if (t != u) or (u != v):
        raise "Yikes!"
    raise SystemExit

