#! /usr/local/bin/bash

###########################################################################
##                                                                       ##
##                Centre for Speech Technology Research                  ##
##                     University of Edinburgh, UK                       ##
##                         Copyright (c) 1997                            ##
##                        All Rights Reserved.                           ##
##                                                                       ##
##  Permission to use, copy, modify, distribute this software and its    ##
##  documentation for research, educational and individual use only, is  ##
##  hereby granted without fee, subject to the following conditions:     ##
##   1. The code must retain the above copyright notice, this list of    ##
##      conditions and the following disclaimer.                         ##
##   2. Any modifications must be clearly marked as such.                ##
##   3. Original authors' names are not deleted.                         ##
##  This software may not be used for commercial purposes without        ##
##  specific prior written permission from the authors.                  ##
##                                                                       ##
##  THE UNIVERSITY OF EDINBURGH AND THE CONTRIBUTORS TO THIS WORK        ##
##  DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING      ##
##  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT   ##
##  SHALL THE UNIVERSITY OF EDINBURGH NOR THE CONTRIBUTORS BE LIABLE     ##
##  FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES    ##
##  WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN   ##
##  AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,          ##
##  ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF       ##
##  THIS SOFTWARE.                                                       ##
##                                                                       ##
###########################################################################

PATH="../main:$PATH"
export PATH

lpc_type=esps

if [ -n "$OUTPUT" ]
    then
    exec 3>$OUTPUT
fi

if lpc_analysis data/kdt_001.wav \
    -pm data/kdt_001.pm \
    -otype $lpc_type -o tmp/lpc.$lpc_type -rtype nist -r tmp/res.nist \
	-window rectangle -order 20 -pm_adjust_to_peak -power -voiced
    then
    echo analysis OK >&3
else
    echo analysis FAILED >&3
    exit 1;
fi

if lpc_synthesis tmp/lpc.$lpc_type -r tmp/res.nist \
    -otype nist -o tmp/resynth.nist \
    -pitch 100 -duration 100 \
    -pp_mod_func stretch_1_3 -pp_mod_func_u chop_1_3

    then
    echo synthesys OK >&3
else
    echo synthesis FAILED >&3
    exit 1;
fi

if cor=`comp_wave data/kdt_001.wav tmp/resynth.nist -cor`
    then
    set $cor
    cor="$3"
    if [ `expr $cor \< 0.99` = "1" ]
	then
	echo "correlation too low ($cor)" >&3
    else
	echo "correlation OK" >&3
    fi
else
    echo comp_wave FAILED >&3
    exit 1;
fi

if rms=`comp_wave data/kdt_001.wav tmp/resynth.nist -rms`
    then
    set $rms
    rms="$4"
    if [ `expr $rms \> 100` = "0" ]
    then
	echo "rms too high ($rms)" >&3
    else
	echo "rms OK" >&3
    fi
else
    echo comp_wave FAILED >&3
    exit 1;
fi

exit 0
