/*************************************************************************/
/*                                                                       */
/*                Centre for Speech Technology Research                  */
/*                     University of Edinburgh, UK                       */
/*                         Copyright (c) 1996                            */
/*                        All Rights Reserved.                           */
/*                                                                       */
/*  Permission to use, copy, modify, distribute this software and its    */
/*  documentation for research, educational and individual use only, is  */
/*  hereby granted without fee, subject to the following conditions:     */
/*   1. The code must retain the above copyright notice, this list of    */
/*      conditions and the following disclaimer.                         */
/*   2. Any modifications must be clearly marked as such.                */
/*   3. Original authors' names are not deleted.                         */
/*  This software may not be used for commercial purposes without        */
/*  specific prior written permission from the authors.                  */
/*                                                                       */
/*  THE UNIVERSITY OF EDINBURGH AND THE CONTRIBUTORS TO THIS WORK        */
/*  DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING      */
/*  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT   */
/*  SHALL THE UNIVERSITY OF EDINBURGH NOR THE CONTRIBUTORS BE LIABLE     */
/*  FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES    */
/*  WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN   */
/*  AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,          */
/*  ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF       */
/*  THIS SOFTWARE.                                                       */
/*                                                                       */
/*************************************************************************/
/*                       Author :  Paul Taylor                           */
/*                       Date   :  April 1996                            */
/*-----------------------------------------------------------------------*/
/*                           Vector class                                */
/*                                                                       */
/*=======================================================================*/
#ifndef __EST_TVector_H__
#define __EST_TVector_H__

#include "EST_TList.h"
#include "EST_rw_status.h"

template <class T> class EST_TVector {
private:
    T *x; //data
    int N; // n points
    void copy(const EST_TVector<T> &a); // private copy function
    void default_vals();
public:
    EST_TVector(); //default constructor
    EST_TVector(const EST_TVector<T> &v); // copy constructor
    EST_TVector(int n); // "size" constructor
    ~EST_TVector() {delete [] x;}

    T def_val;

    void resize(int n); // resize vector
    int num_points() const {return N;}
    int size() const {return N;}  // REORG surely a better name ? 
    int n() const {return N;}

    void fill(T &v); // fill whole vector with value v

    EST_write_status save(const EST_String &file);

    T  &operator () (int n) const; // access operator

    EST_TVector &operator=(const EST_TVector &s); // assignment operator
    EST_TVector &operator=(const EST_TList<T> &s); // assignment operator

    int operator == (const EST_TVector &v) const;
    int operator != (const EST_TVector &v) const;

    friend ostream& operator << (ostream &st, const EST_TVector<T> &m);

};

template<class T>
extern ostream& operator << (ostream &st, const EST_TVector<T> &m);

#endif
