/*************************************************************************/
/*                                                                       */
/*                Centre for Speech Technology Research                  */
/*                     University of Edinburgh, UK                       */
/*                         Copyright (c) 1996                            */
/*                        All Rights Reserved.                           */
/*                                                                       */
/*  Permission to use, copy, modify, distribute this software and its    */
/*  documentation for research, educational and individual use only, is  */
/*  hereby granted without fee, subject to the following conditions:     */
/*   1. The code must retain the above copyright notice, this list of    */
/*      conditions and the following disclaimer.                         */
/*   2. Any modifications must be clearly marked as such.                */
/*   3. Original authors' names are not deleted.                         */
/*  This software may not be used for commercial purposes without        */
/*  specific prior written permission from the authors.                  */
/*                                                                       */
/*  THE UNIVERSITY OF EDINBURGH AND THE CONTRIBUTORS TO THIS WORK        */
/*  DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING      */
/*  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT   */
/*  SHALL THE UNIVERSITY OF EDINBURGH NOR THE CONTRIBUTORS BE LIABLE     */
/*  FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES    */
/*  WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN   */
/*  AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,          */
/*  ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF       */
/*  THIS SOFTWARE.                                                       */
/*                                                                       */
/*************************************************************************/
/*                     Author :  Paul Taylor                             */
/*                     Date   :  April 1996                              */
/*-----------------------------------------------------------------------*/
/*                         Matrix class                                  */
/*                                                                       */
/*=======================================================================*/
#ifndef __PMatrix_H__
#define __PMatrix_H__

#include "EST_rw_status.h"
#include "iostream.h"

template <class T> class EST_TMatrix {
protected:
    T **x; //data
    int M; // m rows
    int N; // n columns
    void copy(const EST_TMatrix<T> &a); // private copy function
public:
    EST_TMatrix(); //default constructor
    EST_TMatrix(const EST_TMatrix<T> &m); // copy constructor
    EST_TMatrix(int m, int n); // "size" constructor
    ~EST_TMatrix();

    T def_val;

    void resize(int m, int n); // resize matrix
    int num_rows() const {return M;}
    int num_columns() const {return N;}

  // will implement these once template instantiation is sorted out
  //    EST_TVector<T>::row(int n); // extract nth row 
  //    EST_TVector<T>::column(int n); // extract nth column

    EST_read_status  load(const class EST_String file);
    EST_write_status save(const class EST_String file);

    T &operator () (int n, int m);   // non-const elemement access operator
    const T &el(int n, int m) const;       // const element access function 

    EST_TMatrix &operator=(const EST_TMatrix &s); // assignment operator
    friend ostream& operator << (ostream &st,const EST_TMatrix<T> &a);
};

template<class T> 
ostream& operator << (ostream &st, const EST_TMatrix<T> &a)
{   
    int i, j;
    for (i = 0; i < a.num_rows(); ++i)
    {
	for (j = 0; j < a.num_columns(); ++j)
	    st << a.el(i, j) << " ";
	st << endl;
    }
    return st;
}

// Note: For an not understood reason, the << function only works if
// defined in the header file.

/* potential utility functions

bool square(m)
EST_TMatrix inverse(m)
T determinant(m)
bool singular(m)
EST_TMatrix Transpose(m)

addition, multiplication
*/

#endif

