/*************************************************************************/
/*                                                                       */
/*                Centre for Speech Technology Research                  */
/*                     University of Edinburgh, UK                       */
/*                         Copyright (c) 1996                            */
/*                        All Rights Reserved.                           */
/*                                                                       */
/*  Permission to use, copy, modify, distribute this software and its    */
/*  documentation for research, educational and individual use only, is  */
/*  hereby granted without fee, subject to the following conditions:     */
/*   1. The code must retain the above copyright notice, this list of    */
/*      conditions and the following disclaimer.                         */
/*   2. Any modifications must be clearly marked as such.                */
/*   3. Original authors' names are not deleted.                         */
/*  This software may not be used for commercial purposes without        */
/*  specific prior written permission from the authors.                  */
/*                                                                       */
/*  THE UNIVERSITY OF EDINBURGH AND THE CONTRIBUTORS TO THIS WORK        */
/*  DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING      */
/*  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT   */
/*  SHALL THE UNIVERSITY OF EDINBURGH NOR THE CONTRIBUTORS BE LIABLE     */
/*  FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES    */
/*  WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN   */
/*  AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,          */
/*  ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF       */
/*  THIS SOFTWARE.                                                       */
/*                                                                       */
/*************************************************************************/
/*                     Author :  Alan W Black                            */
/*                     Date   :  June 1996                               */
/*-----------------------------------------------------------------------*/
/*                                                                       */
/* A class for building EST_String (char-based) tries for indexing arbitrary */
/* objects by Strings                                                    */
/*                                                                       */
/*=======================================================================*/
#ifndef __EST_STRINGTRIE_H__
#define __EST_STRINGTRIE_H__

#include "EST_String.h"

class EST_TrieContents {
  private:
    void *d;
    EST_TrieContents *next;
  public:
    EST_TrieContents() {d=next=0;}
    EST_TrieContents(void *v) {d=v;next=0;}
    ~EST_TrieContents() {if (next != 0) delete next;}
    // should also have a delete function that allows delete of contents
};

class EST_TrieNode {
  private:
    int w;
    EST_TrieNode **d;
    void *contents;
    // will use EST_TrieContents when I have a list of contents 
  public:
    EST_TrieNode() {w=0; d=0; contents=0;}
    EST_TrieNode(const int width);
    ~EST_TrieNode();
    void *lookup(const unsigned char *key) const;
    void add(const unsigned char *key,void *item);
};

class EST_StringTrie {
  private:
    EST_TrieNode *tree;
  public:
    EST_StringTrie();
    ~EST_StringTrie();
    void *lookup(const EST_String &key) const;
    void add(const EST_String &key,void *item);
    void clear(void);
    void clear(void (*deletenode)(void *n));
};

#endif // __EST_STRINGTRIE_H__
