 /************************************************************************/
 /*                                                                      */
 /*                Centre for Speech Technology Research                 */
 /*                     University of Edinburgh, UK                      */
 /*                       Copyright (c) 1996,1997                        */
 /*                        All Rights Reserved.                          */
 /*                                                                      */
 /*  Permission to use, copy, modify, distribute this software and its   */
 /*  documentation for research, educational and individual use only, is */
 /*  hereby granted without fee, subject to the following conditions:    */
 /*   1. The code must retain the above copyright notice, this list of   */
 /*      conditions and the following disclaimer.                        */
 /*   2. Any modifications must be clearly marked as such.               */
 /*   3. Original authors' names are not deleted.                        */
 /*  This software may not be used for commercial purposes without       */
 /*  specific prior written permission from the authors.                 */
 /*                                                                      */
 /*  THE UNIVERSITY OF EDINBURGH AND THE CONTRIBUTORS TO THIS WORK       */
 /*  DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING     */
 /*  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT  */
 /*  SHALL THE UNIVERSITY OF EDINBURGH NOR THE CONTRIBUTORS BE LIABLE    */
 /*  FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES   */
 /*  WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN  */
 /*  AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,         */
 /*  ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF      */
 /*  THIS SOFTWARE.                                                      */
 /*                                                                      */
 /************************************************************************/
 /*                 Author: Richard Caley (rjc@cstr.ed.ac.uk)            */
 /*                   Date: Mon May 26 1997                              */
 /************************************************************************/
 /*                                                                      */
 /* Contour type describe the broad class of information in a            */
 /* track. Used to determine how to save them for instance.              */
 /*                                                                      */
 /************************************************************************/

#ifndef __EST_CONTOURTYPE_H__
#define __EST_CONTOURTYPE_H__

#include "EST_TNamedEnum.h"
#include "EST_String.h"

// Temproarilly diabled since Sun CC hates it.
#define INCLUDE_CONTOUR_TYPE_MAP 0


class EST_Track;

// OK an attempt to combine the uses of enums and Strings. 

// The class of contour types is extensible without changing the library,
// by casting an EST_String to an EST_ContourType, but you have to go
// out of your way to do that, so accidental misuses will be picked up by
// the type system.

class EST_ContourType {

private:
  EST_String p_name;

protected:
  EST_ContourType(const char *s) : p_name(s) { };
  EST_ContourType(char *s) : p_name(s) { };

public:
  static const EST_ContourType F0;
  static const EST_ContourType SIMPLE_F0;
  static const EST_ContourType DIFF_F0;
  static const EST_ContourType LPC;
  static const EST_ContourType REFLECTION;
  static const EST_ContourType CEPSTRUM;
  static const EST_ContourType AREA;
  static const EST_ContourType LOGAREA;
  static const EST_ContourType POWER;
  static const EST_ContourType ENERGY;
  static const EST_ContourType DIFFERENCE;
  static const EST_ContourType PITCHMARKS;
  static const EST_ContourType OTHER;

  
  EST_ContourType(void) : p_name((EST_String)OTHER) { };
  EST_ContourType(const EST_ContourType &t) : p_name(t.p_name) { };

  operator EST_String () const 
	{ return p_name; };

  static EST_ContourType make(const char *s) 
	{ return EST_ContourType(s);};
};

struct EST_contour_type_info {
  int index;
};

#if INCLUDE_CONTOUR_TYPE_MAP
extern  EST_TNamedEnumI<EST_ContourType,  EST_contour_type_info> EST_ContourTypeMap;
#endif

void convert(EST_Track &tr, EST_ContourType from, EST_ContourType to);

#include "EST_Track.h"

#endif
