/*************************************************************************/
/*                                                                       */
/*                Centre for Speech Technology Research                  */
/*                     University of Edinburgh, UK                       */
/*                      Copyright (c) 1995,1996                          */
/*                        All Rights Reserved.                           */
/*                                                                       */
/*  Permission to use, copy, modify, distribute this software and its    */
/*  documentation for research, educational and individual use only, is  */
/*  hereby granted without fee, subject to the following conditions:     */
/*   1. The code must retain the above copyright notice, this list of    */
/*      conditions and the following disclaimer.                         */
/*   2. Any modifications must be clearly marked as such.                */
/*   3. Original authors' names are not deleted.                         */
/*  This software may not be used for commercial purposes without        */
/*  specific prior written permission from the authors.                  */
/*                                                                       */
/*  THE UNIVERSITY OF EDINBURGH AND THE CONTRIBUTORS TO THIS WORK        */
/*  DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING      */
/*  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT   */
/*  SHALL THE UNIVERSITY OF EDINBURGH NOR THE CONTRIBUTORS BE LIABLE     */
/*  FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES    */
/*  WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN   */
/*  AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,          */
/*  ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF       */
/*  THIS SOFTWARE.                                                       */
/*                                                                       */
/*************************************************************************/
/*                    Author :  Simon King                               */
/*                    Date   :  January 1997                             */
/*-----------------------------------------------------------------------*/
/*              Hypothesis class for stack decoder                       */
/*                                                                       */
/*=======================================================================*/


#ifndef __HYPOTHESIS_H__
#define __HYPOTHESIS_H__

#include "EST.h"
#include "Heap.h"


// old stuff ....
//#define MAX_WORDS_PER_SENTENCE 30
//#define CHECK_SCORE_INTERVAL 20
//#define BEST_TOKEN_REGION_SIZE 2

class Hypothesis : public Heap_Item {

private:
	
protected:

    // a hypothesis is a heap item
    // plus some acoustic model state
    // plus a language model state
    // plus a path history (e.g. word sequence)
    // these states will be changed each time a hypothesis is extended
public:
    
    float h_estimated_remaining_log_prob; // and of the log prob to the end
    
    void *acoustic_model_state;
    void *language_model_state;


    Hypothesis();
    Hypothesis(float initial_eval_fn);
    Hypothesis(Hypothesis *h);

    virtual ~Hypothesis();
    
    bool is_finished();

    virtual void traceback(ostream& ost){
	ost << "Can't traceback a Hypothesis !" << endl; 
    };
    
    virtual void print(ostream& ost){ 
	ost << "Hypothesis::print does nothing !" << endl; 
    };
    
    friend int operator > (Hypothesis& h1,  Hypothesis& h2);
    friend ostream& operator << (ostream& ost, Hypothesis& h);
    
};

int operator > (Hypothesis& h1,  Hypothesis& h2);
ostream& operator << (ostream& ost, Hypothesis& h);

#endif
