/*************************************************************************/
/*                                                                       */
/*                Centre for Speech Technology Research                  */
/*                     University of Edinburgh, UK                       */
/*                      Copyright (c) 1995,1996                          */
/*                        All Rights Reserved.                           */
/*                                                                       */
/*  Permission to use, copy, modify, distribute this software and its    */
/*  documentation for research, educational and individual use only, is  */
/*  hereby granted without fee, subject to the following conditions:     */
/*   1. The code must retain the above copyright notice, this list of    */
/*      conditions and the following disclaimer.                         */
/*   2. Any modifications must be clearly marked as such.                */
/*   3. Original authors' names are not deleted.                         */
/*  This software may not be used for commercial purposes without        */
/*  specific prior written permission from the authors.                  */
/*                                                                       */
/*  THE UNIVERSITY OF EDINBURGH AND THE CONTRIBUTORS TO THIS WORK        */
/*  DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING      */
/*  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT   */
/*  SHALL THE UNIVERSITY OF EDINBURGH NOR THE CONTRIBUTORS BE LIABLE     */
/*  FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES    */
/*  WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN   */
/*  AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,          */
/*  ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF       */
/*  THIS SOFTWARE.                                                       */
/*                                                                       */
/*************************************************************************/
/*                    Author :  Simon King                               */
/*                    Date   :  January 1997                             */
/*-----------------------------------------------------------------------*/
/*                Heap class for stack decoder                           */
/*                                                                       */
/*=======================================================================*/

#ifndef __HEAP_H__
#define __HEAP_H__

#include "EST.h"

class Decoder;

class Heap_Item {

private:
	
protected:
    
public:
    
    float h_eval_fn; // used to order the heap

    // to do - take this to a derviced class
    float h_partial_log_prob; // log prob of the partial path so far, used for pruning

    int h_length;    // in frames; used as index to least-upper-bound-so-far array in LUBHeap

    Heap_Item();
    Heap_Item(float initial_eval_fn);
    virtual ~Heap_Item();
    
    virtual void print(ostream& ost){ ost << "Heap_Item::print does nothing !" << endl; };

    friend bool operator > (Heap_Item& h1,  Heap_Item& h2);
    friend ostream& operator << (ostream& ost, Heap_Item& h);


};

ostream& operator << (ostream& ost, Heap_Item& h);


class Heap {

private:

protected:

    int heap_size;
    int max_heap_size;
    
    // type Heap_Item must have operator >
    Heap_Item **heap_item;
    
    // heap is a binary tree, hence following bit-shift ops
    inline int parent(int i){ return(i>>1); };
    inline int left_child(int i){ return(i<<1); };
    inline int right_child(int i){ return((i<<1)|1); };
    
    void heapify(int node);
    
    
public:
    
    enum insert_error_t {inserted_ok,heap_full,prune_item};

    Heap(int);
    virtual ~Heap();
    
    // all you can do with a heap is put things in ...
    //(virtual because can have different implementations, e.g. if heap is pruned)
    // returns true if successful, and makes pointer NULL
    virtual insert_error_t insert(Heap_Item* new_heap_item_ptr); 
    
    // take the "biggest" item out...
    Heap_Item* extract_max();
    
    // and see how many things you have in the heap ...
    inline int size() { return heap_size; };
    inline bool full() { return (bool)(heap_size == max_heap_size); };

    virtual void print_stats() = 0;

    friend class Decoder;
    
};

#endif
