
/*
 * DILOOKUP.C	Lookup a history DB entry based on message 
 *		id or hash values
 *
 * (c)Copyright 1997, Matthew Dillon, All Rights Reserved.  Refer to
 *    the COPYRIGHT file in the base directory of this distribution 
 *    for specific rights granted.
 */

#include "defs.h"

int
main(int ac, char **av)
{
    hash_t hv;
    History h;
    int r = 0;

    if (ac == 1) {
	printf("dilookup <message-id>\n");
	printf("dilookup hv1.hv2\n");
	exit(0);
    }

    HistoryOpen(NULL, 0);

    if (av[1][0] == '<') {
	hv = hhash(av[1]);
    } else if (av[1][0] == 'D' && av[1][1] == '.') {
	int32 dummy;

	if (sscanf(av[1] + 2, "%x/%x.%x", &dummy, &hv.h1, &hv.h2) != 3) {
	    fprintf(stderr, "argument error\n");
	    exit(1);
	}
    } else if (sscanf(av[1], "%x.%x", &hv.h1, &hv.h2) != 2) {
	fprintf(stderr, "argument error\n");
	exit(1);
    }

    if (HistoryLookupByHash(hv, &h) == 0) {
	char tbuf1[64];
	char tbuf2[64];

	{
	    struct tm *tp;
	    time_t t;

	    t = h.gmt * 60;
	    tp = localtime(&t);
	    strftime(tbuf1, sizeof(tbuf1), "%d-%b-%y %H:%M:%S", tp);

	    if (h.exp != (unsigned short)-1) {
		t = h.gmt * 60 + h.exp * 60 * 60;
		tp = localtime(&t);
		strftime(tbuf2, sizeof(tbuf1), "%d-%b-%y %H:%M:%S", tp);
	    } else {
		sprintf(tbuf2, "expired");
	    }
	}

	if (h.boffset || h.bsize) {
	    printf(" [D.%08x/B.%04x hv=%08x.%08x gm=%d ex=%d off=%d len=%d]"
		   " GM=(%s) EX=(%s)\n",
		h.gmt - h.gmt % 10,
		(int)h.iter,
		h.hv.h1,
		h.hv.h2,
		(int)h.gmt,
		(int)h.exp,
		(int)h.boffset,
		(int)h.bsize,
		tbuf1,
		tbuf2
	    );
	} else {
	    printf(" [D.%08x/%08x.%08x.%04x gm=%d ex=%d] GM=(%s) EX=(%s)\n",
		h.gmt - h.gmt % 10,
		h.hv.h1,
		h.hv.h2,
		(int)h.iter,
		(int)h.gmt,
		(int)h.exp,
		tbuf1,
		tbuf2
	    );
	}
    } else {
	fprintf(stderr, "%08x.%08x Not found\n", hv.h1, hv.h2);
	r = 1;
    }
    return(r);
}

