
/*
 * LIB/ACTIVE.C
 *
 * (c)Copyright 1997, Matthew Dillon, All Rights Reserved.  Refer to
 *    the COPYRIGHT file in the base directory of this distribution 
 *    for specific rights granted.
 *
 * Active file management.  In Diablo, the 'active file' is handled by
 * two databases.  The first database maintains the group hierarchy,
 * description, flags, moderator email, and low and high water marks.
 * It is arranged hierarchically and formatted with variable-length records.
 * Each record also contains a reference into the second per-group database.
 *
 * The second database is arranged one file per group and stored by group id
 * as referenced from the first database.  Each file contains a fixed number
 * (usually 1000) of variable-length records stored on an allocation basis
 * through a fixed offset-array at the beginning.  This database is able
 * to serve NOV information and is able to translate article numbers into
 * messageid+timestamp pairs which, in turn, may be used to reference the
 * physical article.  Xref information is also stored here as (grpid, artno)
 * pairs.
 *
 * The per-group databases must generally be cleaned once a week, but until
 * then runs in the manner of a circular buffer, allocating and freeing
 * 'space' in the latter part of the file to accomodate records.  With
 * 20,000 groups, the baseline disk utlization is 1000x8 (index array) x 20,000
 * == 162MB.  The NOV disk utilization is highly dependant on a number of 
 * factors, but is expected to average 300 bytes per entry.  A typical
 * spool containing 2 million articles would require 600 MBytes worth of NOV
 * info.
 */

#include "defs.h"

typedef struct Active {
    uint32      next;   /* next link            */
    uint32      sub;    /* subhierarchy         */
    uint32      loWat;  /* low water mark       */
    uint32      hiWat;  /* high water mark      */
    uint32      id;     /* Overview file id     */
    uint16	bytes;	/* bytes in this record */
    char		data[2];/* groupname + additional info		*/
} Active;

typedef struct OverRef {
    uint32	offset; /* offset in file -> OverView           */
    uint16      artMod; /* article number MSB mod value         */
    uint16      msgid;	/* low 16 bits of msgid hash		*/
} OverRef;

typedef struct OverHead {
    int                 arts;   /* (fixed) max articles for this group  */
    int                 rollov; /* roll-over point                      */
    OverRef             ref[1]; /* index array                          */
} OverHead;

typedef struct OverView {
    int                 artno;          /* article number double-check  */
    int16               nelm;           /* number of elements           */
    int16               reserved;       /* future                       */
    int16               elen[1];        /* element byte lens [nelm]     */
    /* elen[N]          */
    /* elements         */
} OverView;




XXXXXXXXXXXXXXXX



typedef struct DActive {
    struct Active	*da_Head;
} DActive;

typedef struct DGroup {
    struct OverHead	*dg_Head;
} DGroup;

/*
 * ActiveOpen()	- open the active file
 */

void
ActiveOpen(const char *fileName, int flags)
{
}

/*
 * ActiveClose() - close the active file
 *
 */

void
ActiveClose(void)
{
}

/*
 * ActiveLookup() - lookup a group in the active file
 */

int
ActiveLookup(const char *grpName, Active *ac)
{
}

/*
 * ActiveSet() - create, adjust, or delete a group
 *
 *	maxArts < 0	delete
 *	maxArts >= 0	create or adjust
 *	headAry[]	array of \n terminated data headers
 *
 *			Moderated: (email), Authentication:, etc...
 *
 * When modifying an existing entry, headAry modifies the existing
 * header set rather then replacing it.  A header can be deleted
 * by passing, for example, 'Moderated:' with no additional data.
 */

int
ActiveSet(const char *grpName, int maxArts, char **headAry)
{
}

/*
 * GroupAlloc() - allocate article number from Active file for group.  The
 *		  article number will be used in a later GroupStore()
 */

int
GroupAlloc(const char *grpName)
{


}

/*
 * GroupLookupArtNo() - lookup article number in group.  Returns OverView *
 * GroupLookupMsgId() - lookup message id in group.  Returns OverView *
 *
 * 	both routines may also return an Article pointer if requested
 */

void
GroupLookupArtNo(const char *grpName, int artNo, Article **part)
{
    DActive *dac = alookup(grpName, LOCK_SH);
    DGroup  *grp = glookup(dac);

    grelse(grp);
    arelse(dac);
}

void
GroupLookupMsgId(const char *grpName, int artNo, Article **part)
{
    DActive *dac = activeLookup(grpName, LOCK_SH);
    DGroup  *grp = groupLookup(dac);

    grelse(grp);
    arelse(dac);
}

/*
 * GroupStore() - commit an article to a particular article number
 *		  in a particular group
 */

int
GroupStore(const char *grpName, int artNo, char *artData)
{
    DActive *dac = activeLookup(grpName, LOCK_EX);
    DGroup  *grp = groupLookup(dac);

    grelse(grp);
    arelse(dac);
}

