.TH sfxload 1 "September 1, 1997"
.LO 1
.SH NAME
sfxload \- load a SoundFont file on the AWE32 sound driver

.SH SYNOPSIS
sfxload [\-options] fontfile

.SH DESCRIPTION
.B sfxload
is a utility program to transfer the sound wave and
instruments data in a SoundFont file to the AWE32 sound driver.
This program is necessary for playing MIDI samples
via sequencer programs supporting AWE driver.

Basically, sfxload behaves as two ways.
.in +1i
% sfxload fontfile
.br
% sfxload -b1 fontfile
.in -1i

The first usage is to read SF2 (or SBK) file and transfer to the awe
driver.  In this case, the samples which were loaded on the driver are
replaced with the new one.
In the second case, sfxload reads the file and appends it to the
pre-loaded samples on the driver with specified bank number.  The old
samples remain in the driver.  The additional samples can be cleared
via
.B \-x
option (see below).

The sound files are searched through the path list.  The path list is
defined as built-in.  If the environment variable
.B SFBANKDIR
or the
command line option
.B \-P
is given, it replaces the default search list.
The file extension .sf2, and .sbk can be abbreviated.

.SH OPTIONS
.TP
.B \-x, --remove[=bool]
Remove the optional samples previouly loaded via -b option.
Otherwise, all new samples are simply appended.
If this option is specified alone without soundfont file
arguments, sfxload does onlay remove samples.
Either of "on", "off", "yes", "no", "true", or "false" can be
specified as an optional argument.
.TP
.B \-b, --bank=number
Append the sound samples on the specified bank.
Without this option, all samples in the driver are reset, and
new samples are loaded.
This option is necessary to load user bank, usually in bank one.
For example,
.in +1i
% sfxload synthgm.sbk
.br
% sfxload -b1 surprise.sf2
.br
.in -1i
.TP
.B \-l, --lock[=bool]
Lock the font.  The locked font is no longer removed via
remove option (-x) even if it's loaded together with -b option.
.TP
.B \-A, --sense=sensitivity
Set sample attenuation sensitivity.
This option controls the sensitivity of initial attenuation parameter
of each instrument defined in SoundFont file.
In the program, each parameter is calculated from the value divided
by this number for the original value.
The number 1.0 means that the original initial attenuation parameters
would be used.
Generally, smaller number makes drum sounds louder.
(I think -A 2 would be similar to Windows sounds.)
The default value is 10. 
Note that this option changes also the default attenuation automatically (see below).
.TP
.B \-a, --atten=attenuation
Set the default attenuation level.
This option controls the minimum attenuation of the sample.
The parameter is given in raw digit number for AWE driver,
that is, in 8/3 dB unit.
Since --sense option changes the default attenuation automatically,
specify this option later from --sense option.
The default value is 32.
.TP
.B \-d, --decay=scale
Set the scale of envelope decay time.  Default value is 50.0.
Sounds decay fast when larger number is set.
The ver.0.3 sfxload uses 54.8.  If you want to keep the same
sound, use this number instead.
.TP
.B \-M, --memory[=bool]
Display the left memory size in DRAM on the AWE32 card.
.TP
.B \-c, --chorus=percent
Specify the effects of chorus.
The value is in percent, from 0 to 100.  The default is unspecified.
This value may be overwritten by MIDI control messages.
.TP
.B \-r, --reverb=percent
Specify the effects of reverb.
The value is in percent, from 0 to 100.  The default is unspecified.
This value may be overwritten by MIDI control messages.
.TP
.B \-B, --addblank[=bool]
Add 48 size of blank loop on each sample data.  Usually, this
option is not necessary.  Most of soundfont files are designed 
well for enough blank loops for each sample.
.TP
.B \-L, --extract=source[:map]
Extract and load only the specified preset(s).
This option is usually employed by drvmidi.
The preset is given as same as in virtual bank file.
.TP
.B \-v, --verbose[=level]
Increase or set the verbosity level.
.TP
.B \-V, --volume=percent
Specify the total volume of sounds, provided in percent.
The default volume is 70%.
.TP
.B \-P, --path=path1:path2:pathN
Specify the search path list.
The sound files are searched from
.I path1, path2,
and so on.
This overrides both the system path and environment variable
.B SFBANKDIR.

.SH "VIRTUAL BANK FILE"
The virtual bank file is a list of presets treated as one soundfont
file.  The syntax of virtual bank is as follows:
.in +1i
	# comments
.br
	source:map[:soundfont [preset-name]
.br
	source:map[:soundfont [preset-name]
.br
	...
.in -1i

The first and second items are the source and mapped presets,
respectively.  The former is the existing preset in the soundfont,
and the latter is the actual preset loaded on the sound driver.
The preset is described by the following three values,
.in +1i
	preset/bank/keynote
.in -1i
If bank and keynote are omitted, bank 0 and keynote -1 (meaning to
search all keys) are applied.

The third item is the name of soundfont file.  The file is searched
from the prescribed search-path.  The remaining arguments are
ignored in sfxload.

If the soundfont name is omitted, sfxload loads it as preset
mapping.  It just behaves like a symbolic link of file opposing to
copying of the file.  Any sample data is not referred at this time,
but searched first when the note is played.

A couple of special commands can be used together with the virtual
presets above.
.B default
command is used to specify the default
soundfont file.  Any other presets which are not defined in the
virtual preset lists are loaded from this default font.  For
example, in the following virtual bank, 2mbgmgs.sf2 is used except
for standard drumsets which employs drum.sf2:
.in +1i 
	0/128:0/128:drum.sf2
.br
	default 2mbgmgs.sf2
.in -1i

Another special command is
.B include
command.  This simply includes
another virtual bank file under the current position. For example,
.in +1i
	default standard.sf2
.br
	0/128:0/128:drum.sf2
.br
	include xgsfx.bnk
.in -1i

.SH "SYSTEM RESROUCE FILE"

The default option arguments can be stored in the system resource file.
There are two files loaded as default.
.in +1i
$HOME/.sfxloadrc
.br
/etc/sfxloadrc
.in -1i

The syntax is as follows:
.in +1i
fontname -options..
.in -1i
The first argument is soundfont file name for each option.
The remaining arguments are identical with command line options.
The font name
.I default
is used for default options for all sound
fonts.  The default options are overridden by specific options or
command line options.

For example, to set attenuation scale 10.0 except synthgm font, you
need to make a resource file ~/.sfxloadrc like that:
.in +1i
default	--scale=10.0
.br
synthgm --scale=2.0 --atten=10
.in -1i


.SH ENVIRONMENT
.TP
.B SFBANKDIR
Search path for sound files.  The current directory is always searched
at first.

.SH "SEE ALSO"
drvmidi(1)

.SH COPYRIGHT
Copyright (C) 1996,1997 Takashi Iwai.
.P
The AWE32 driver and utilties are free software; you can redistribute them
and/or modify them under the terms of the \fIGNU General Public
License\fP as published by the Free Software Foundation; either
version 2 of the License, or (at your option) any later version.
