/*
 */

#ifndef SEQ_H_DEF
#define SEQ_H_DEF

extern void seqbuf_dump();

/* open / close sequencer device */
int seq_init(int do_echoback);
void seq_end(void);
int seq_opened(void);

void seq_blocking_mode(int mode);
int seq_pending(void);
void seq_check_pending(void);

/* timer controls */
void seq_clear(int csec);
int seq_timer_started(void);
int seq_lasttime(void);
int seq_curtime(void);
void seq_wait(int time);
void seq_echo(int csec);
int seq_sleep(int csec);
int seq_wait_time(int csec);

/* immediately reset voices */
void seq_terminate_all(void);

/* send seq events */
void seq_set_bank(int v, int bank);
void seq_set_program(int v, int pgm);
void seq_start_note(int v, int note, int vel);
void seq_stop_note(int v, int note, int vel);
void seq_control(int v, int type, int val);
void seq_aftertouch(int v, int note, int vel);
void seq_chan_pressure(int v, int val);
void seq_pitchsense(int v, int val);
void seq_pitchbend(int v, int val);
void seq_send_effect(int v, int type, int val);
void seq_add_effect(int v, int type, int val);
void seq_soft_pedal(int v, int val);
void seq_note_off_all(void);
void seq_sound_off_all(void);

/* send status as buffered */
void seq_reset_channel(int v);
void seq_reset_control(int v);
void seq_set_drumchannels(int channels);
void seq_channel_priority(int mode);
void seq_detune(int v, int coarse, int fine);
void seq_set_realtime_pan(int mode);
void seq_set_def_drum(int val);

/* immediately change status */
void seq_set_chorus(int mode);
void seq_set_reverb(int mode);
void seq_change_volume(int vol);
void seq_equalizer(int bass, int treble);
void seq_remove_samples(void);

#endif
