#----------------------------------------------------------------
# Miscellaneous procedures
# Copyright (c) 1996,1997  Takashi Iwai
#----------------------------------------------------------------

#----------------------------------------------------------------
# tk easy programming
#----------------------------------------------------------------

#
# grab a window
#
set tk_priv(grablist) {}

proc push-grab {w} {
    global tk_priv
    set prevw [grab current $w]
    lappend tk_priv(grablist) $prevw
    grab $w
}

proc pop-grab {} {
    global tk_priv
    set w [lrange $tk_priv(grablist) end end]
    set tk_priv(grablist) [lreplace $tk_priv(grablist) end end]
    if {[winfo exists $w]} {
	grab $w
    }
}

#
# sec to time string
#
proc sec2time {sec} {
    if {$sec >= 0} {
	return [format "%02d:%02d" [expr $sec / 60] [expr $sec % 60]]
    } else {
	set sec [expr -$sec]
	return [format "-%02d:%02d" [expr $sec / 60] [expr $sec % 60]]
    }
}

#
# numeric binding:
# only numerical key and some controls are available for input.
#
proc numeric-bind {w} {
    bind $w <Any-Key> {
	if {"%A" != "" && [regexp "\[0-9\]+" %A]} {
	    %W insert insert %A
	    tk_entrySeeCaret %W
	} elseif {"%K" == "Return"} {
	    global tk_priv
	    focus none
	}
    }
    bind $w <Key-Delete> {tk_entryBackspace %W; tk_entrySeeCaret %W}
    bind $w <Key-BackSpace> {tk_entryBackspace %W; tk_entrySeeCaret %W}
    bind $w <Control-Key-h> {tk_entryBackspace %W; tk_entrySeeCaret %W}
    bind $w <Control-Key-d> {%W delete sel.first sel.last; tk_entrySeeCaret %W}
    bind $w <Control-Key-u> {%W delete 0 end}
}

#
# make a listbox
#
proc my-listbox {w title size {dohoriz 1} {multiple 0}} {
    frame $w
    label $w.label -text $title -relief flat
    pack $w.label -side top -fill x -anchor w
    regexp "(\[0-9\]+)x(\[0-9\])" $size foo width height
    if {$multiple} {
	set mode multiple
    } else {
	set mode browse
    }
    return [make-listbox $w $width $height $dohoriz $mode]
}

proc make-listbox {w width height {dohoriz 0} {mode browse}} {
    scrollbar $w.yscr -command "$w.list yview"
    pack $w.yscr -side right -fill y
    set lopt [list -width $width -height $height]
    lappend lopt -exportselection 0 -selectmode $mode
    if {$dohoriz} {
	scrollbar $w.xscr -command "$w.list xview" -orient horizontal
	pack $w.xscr -side bottom -fill x
	eval listbox $w.list -relief sunken -setgrid yes $lopt\
		[list -yscroll "$w.yscr set"]\
		[list -xscroll "$w.xscr set"]
    } else {
	eval listbox $w.list -relief sunken -setgrid yes $lopt\
	    [list -yscroll "$w.yscr set"]
    }
    pack $w.list -side top -fill both -expand yes
    return $w.list
}

#----------------------------------------------------------------
# dialog pop-up
#----------------------------------------------------------------

proc my-dialog {w title defbtn canbtn buttons} {
    toplevel $w -class Dialog
    wm title $w $title
    wm iconname $w $title

    label $w.title -text $title -relief raised -bd 1
    pack $w.title -side top -fill x
    
    frame $w.f -relief raised -bd 1
    pack $w.f -side top -fill both

    frame $w.buttons -relief raised -bd 1
    pack $w.buttons -side bottom -fill both
    set i 0
    foreach but $buttons {
	button $w.buttons.c$i -text [lindex $but 0] -command [lindex $but 1]
	if {$defbtn != "" && $i == $defbtn} {
	    frame $w.buttons.default -relief sunken -bd 1
	    raise $w.buttons.c$i $w.buttons.default
	    pack $w.buttons.default -side left -expand 1\
		    -padx 3m -pady 2m
	    pack $w.buttons.c$i -in $w.buttons.default -padx 2m -pady 2m \
		    -ipadx 2m -ipady 1m
	    bind $w <Return> "$w.buttons.c$i flash; $w.buttons.c$i invoke"
	} else {
	    pack $w.buttons.c$i -side left -expand 1 \
		    -padx 3m -pady 3m -ipadx 2m -ipady 1m
	    if {$canbtn != "" && $i == $canbtn} {
		bind $w <Key-Escape> "$w.buttons.c$i flash; $w.buttons.c$i invoke"
	    }
	}
	incr i
    }

    return $w.f
}

#----------------------------------------------------------------
#  warning/question dialog
#----------------------------------------------------------------

proc my-message-dialog {w title text bitmap defbtn canbtn args} {
    #puts stderr $text
    return [eval tk_dialog [list $w $title $text $bitmap $defbtn] $args]
}

proc warning {message} {
    my-message-dialog .warning "Warning" $message warning 0 0 {  OK  }
}

proc error {message} {
    my-message-dialog .error "Error" $message error 0 0 {  OK  }
}
    
proc information {message} {
    my-message-dialog .info "Information" $message info 0 0 {  OK  }
}
    
proc question {message {defrc 1}} {
    global tk_priv
    if {$defrc} {
	set defbtn 0
	set canbtn 1
    } else {
	set defbtn 1
	set canbtn 0
    }
    return [expr ![my-message-dialog .yesno "Question" $message question\
	    $defbtn $canbtn "Yes" "No"]]
}

#----------------------------------------------------------------
# pseudo random routine without TclX
#----------------------------------------------------------------

set pseudo_random [catch {random 1}]

if {$pseudo_random} {
    set pseudo_random_next -1
    proc random {max} {
	global pseudo_random pseudo_random_next
	set pseudo_random_next [expr $pseudo_random_next * 1103515245 + 12345]
	return [expr ($pseudo_random_next/65536) % $max]
	# Or, use bash's random routine instead...
	# return [expr [exec bash -c {echo $RANDOM}] % $max]
    } 
}

proc init-random {num} {
    global pseudo_random pseudo_random_next
    if {$pseudo_random} {
	set pseudo_random_next $num
    } else {
	random seed $num
    }
}

#----------------------------------------------------------------
# convert string to list
#----------------------------------------------------------------

proc isspace {c} {
    if {[lsearch {" " "\t" "\n" "\r"} $c] != -1} {
	return 1
    } else {
	return 0
    }
}

#
# split a string to token list
#
proc splittoken {str} {
    set in_escape 0
    set in_space 1
    set quote ""
    set vlist {}
    set token ""
    foreach c [split $str {}] {
	if {$in_escape} {
	    append token $c
	    set in_escape 0
	} elseif {$c == $quote} {
	    set quote ""
	} else {
	    if {$quote == "" && [isspace $c]} {
		if {! $in_space} {
		    lappend vlist $token
		    set token ""
		}
		set in_space 1
	    } else {
		if {$c == "\"" || $c == "'"} {
		    set quote $c
		} elseif {$c == "\\"} {
		    set in_escape 1
		} else {
		    append token $c
		}
		set in_space 0
	    }
	}
    }
    if {! $in_space} {
	lappend vlist $token
    }
    return $vlist
}

#
# add escape letter before special letters
#
proc escstring {str} {
    set v ""
    foreach i [split $str {}] {
	if {$i == "\"" || $i == "'" || $i == "\\"} {
	    append v "\\"
	}
	append v $i
    }
    return $v
}
