/*
 * vi:ts=4:sw=4:
 *
 * Project : "Linux Explorer
 * Copyright 1996. All Rights Reserved.
 * 
 * $RCSfile: cpdlg.cpp,v $
 *
 * $Revision: 1.3 $
 * 
 * $Author: ruben $ 
 * 
 * $Locker:  $
 * 
 * $State: Exp $
 * 
 * 
 * COPYRIGHT
 * =========
 * 
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 * OVERVIEW
 * ========
 * 
 * $Log: cpdlg.cpp,v $
 * Revision 1.3  1997/06/09 12:59:23  ruben
 * switched rcs commands again I think...
 * compiled with -Wall -Werror, fixed bugs and potential bugs
 * fixed Mister Data bugs
 *
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif	 // HAVE_CONFIG_H

#include <qpushbt.h>
#include <qstring.h>
#include <qtimer.h>
#include <qlayout.h>
#include <qfontmet.h>
#include <qfileinf.h>
#include <qstrlist.h>
#include <qlist.h>
#include <qdir.h>

#include <sys/errno.h>
#include <errno.h>
#include <limits.h>
#include <unistd.h>

#include "qprogres.h"
#include "cpdlg.h"


#include <iostream.h>

CopyProgressDlg::CopyProgressDlg(const QStrList& szSources_arg, const QString& szDestination_arg, int opmode_arg, bool bRecursive_arg, QWidget* parent=0, const char* name=0): QDialog(parent,name,TRUE),iOpmode(opmode_arg),bRecursive(bRecursive_arg)
{

	widget = new CopyProgressWidget(this, name);
	spTimer = new QTimer;
	szSources = (QStrList *)&szSources_arg;
	szDestinations = new QStrList;
	szDestinations->append(szDestination_arg);
	Sources = new QStrListIterator(*szSources);
	Destinations = new QStrListIterator(*szDestinations);

	// make all absolute paths

	QObject::connect(spTimer, SIGNAL(timeout()), SLOT(tryStart()));
	QObject::connect(widget, SIGNAL(quit_me()), SLOT(shutdowndlg()));

	// How to prevent execution until exec() ???

	spTimer->start(50*10);
	widget->show();
}

void CopyProgressDlg::shutdowndlg()
{
	done(1);
}

CopyProgressDlg::~CopyProgressDlg()
{
	delete spTimer;
	// delete szSources
	delete szDestinations;
	delete Sources;
	delete Destinations;
}

void CopyProgressDlg::tryStart()
{
	if (isVisible())
	{
		spTimer->stop();
		doStuff();
		QObject::connect(widget, SIGNAL(completed()), SLOT(doStuff()));
	}
}

void CopyProgressDlg::doStuff()
{
	char   *szSource,
	       *szDestination;

	if((szSource = (*Sources)()))
	{
		QFileInfo  Source(szSource);

		while ((szDestination = (*Destinations)()))
		{
			QString Destination(szDestination); 
			if (iOpmode == Copy || iOpmode == Move)
				Destination = QDir::cleanDirPath(Destination + "/" + Source.fileName());

			cout << "Copying " << szSource << " To " << Destination << endl;
			
			widget->setSource(szSource);
			widget->setDestination(Destination);
			widget->start();
		}
		Destinations->toFirst();
	}
	else
		done(0);
}

#define CPD_DEFAULT_CP_BLOCKS (100)

// number of progresssteps/blocks is in.size()/iBuffersize
void CopyProgressWidget::setup_gui()
{
	
	QBoxLayout *m, *l = new QBoxLayout(this,QBoxLayout::TopToBottom);
	spAbortButton = new QPushButton("Abort",this);
	QFontMetrics spMetrics = QWidget::fontMetrics();
	
	spProgress = new QProgressCtrl(this,(style() == WindowsStyle) ? blockedBar : solidBar );
	spBusyText = new QLabel(this);
	
	if (l && spAbortButton && spProgress)
	{
		setFrameStyle( QFrame::Panel | QFrame::Raised );
		
		spAbortButton->setFixedSize(spAbortButton->sizeHint());
		spAbortButton->setAutoDefault(TRUE);

		spProgress->setFixedSize(6 * spAbortButton->width(), spAbortButton->height());
		
		spBusyText->setAlignment(AlignCenter);
		spBusyText->setFixedSize(spProgress->width() - (2*frameWidth()) ,2 * spMetrics.lineSpacing());
		
		QObject::connect(spAbortButton,SIGNAL(clicked()), this, SLOT(abort()));

		m = new QBoxLayout(QBoxLayout::LeftToRight);

		l->addSpacing(5);
		l->addWidget(spBusyText);
		l->addSpacing(5);
		l->addLayout(m);
		l->addSpacing(10);
		
		m->addSpacing(10);
		m->addWidget(spProgress);
		m->addSpacing(10);

		m = new QBoxLayout(QBoxLayout::LeftToRight);

		l->addLayout(m);
		l->addSpacing(5);
		
		m->addStretch(1);
		m->addWidget(spAbortButton);
		m->addStretch(1);
	
		l->activate();
		
		setFixedSize(minimumSize());
	}
	else
		emit failed(errno);
	QObject::connect(this,SIGNAL(failed(int)),SLOT(ch_abort_to_close_me(int)));
}

void CopyProgressWidget::ch_abort_to_close_me(int)
{
		QObject::disconnect(spAbortButton,SIGNAL(clicked()));
		QObject::connect(spAbortButton,SIGNAL(clicked()), SLOT(do_close_me_please()));
		
		spAbortButton->setText("Close");
}

void CopyProgressWidget::do_close_me_please()
{
	emit quit_me();
}

CopyProgressWidget::CopyProgressWidget(QWidget *parent, const char *name): QLabel(parent,name),uiMyBuffersize(16*1024),cBuffer(NULL),bBusy(FALSE)
{
	setup_gui();
}

void CopyProgressWidget::start()
{
	if (!bBusy && in.name() && out.name() && uiMyBuffersize)
	{
		spTimer = new QTimer(this);
		cBuffer = new char[uiMyBuffersize];
		
		if (spTimer && cBuffer)
		{
			if(in.exists())
			{
				if (in.open(IO_ReadOnly|IO_Raw)) 
				{
					if(out.open(IO_WriteOnly|IO_Truncate|IO_Raw))
					{
						QFileInfo ininfo(in),
								  outinfo(out);
						QString str(sizeof("Copying ''\nto ''")+2*(NAME_MAX+PATH_MAX)+1);
						int iSteps;
						bBusy = TRUE;
						// How many times must we process an block
						
						iSteps = (in.size() < uiMyBuffersize) ? 1 : (in.size() / uiMyBuffersize);
						spProgress->setRange(0,iSteps);
						iSteps = 1;
						
						str = QString("Copying '") + QString(ininfo.fileName()) + QString("'");
						if (ininfo.fileName() != outinfo.fileName())
							str += QString("\nas '") + QString(outinfo.fileName()) + QString("'");
						else
							str += QString("...");
						
						spBusyText->setText(str);
						spBusyText->update();
						spProgress->setStep(iSteps);
						spProgress->setPos(0);
						QObject::connect(spTimer,SIGNAL(timeout()),this,SLOT(copyfile()));
						spTimer->start(0);
					}
					else
					{
						QString str(1024);
						int iCache_errno = errno;
						in.close();
						str.sprintf("Error while opening file '%s':\n%s",out.name(),strerror(iCache_errno));
						spBusyText->setText(str);
						spBusyText->update();
						emit failed(iCache_errno);
					}
				}
				else
				{
					QString str(1024);
					int iCache_errno = errno;
					str.sprintf("Error while opening file '%s':\n%s",in.name(),strerror(iCache_errno));
					spBusyText->setText(str);
					spBusyText->update();
					emit failed(iCache_errno);
				}
			}
		}
		else
		{
			QString str(1024);
			int iCache_errno = errno;
			str.sprintf("Error while preparing copy:\n%s",strerror(iCache_errno));
			spBusyText->setText(str);
			spBusyText->update();
			emit failed(iCache_errno);
		}
	}
}

void CopyProgressWidget::copyfile()
{
	int throughput;
	if ((throughput = in.readBlock(cBuffer,uiMyBuffersize)) != -1)
	{
		if (out.writeBlock(cBuffer,throughput) != throughput)
		{
			// error
			QString str(1024);
			int iCache_errno = errno;
			str.sprintf("Error while writing '%s':\n%s",out.name(),strerror(iCache_errno));
			spBusyText->setText(str);
			spBusyText->update();
			in.close();
			out.close();
			spProgress->setPos(0);
			spTimer->stop();
			QObject::disconnect(spTimer,SIGNAL(timeout()),this,SLOT(copyfile()));
			bBusy = FALSE;
			emit failed(iCache_errno);
		}
		spProgress->stepIt();
		// update progressbar
		
		if (((unsigned int)throughput) < uiMyBuffersize)
		{
			// end of file, stop timer
			// and close files
			spBusyText->setText("Done");
			spBusyText->update();
			in.close();
			out.close();
			spProgress->setPos(0);
			spTimer->stop();
			QObject::disconnect(spTimer,SIGNAL(timeout()),this,SLOT(copyfile()));
			bBusy = FALSE;
			emit completed();
		}
	}
	else
	{
			QString str(1024);
			int iCache_errno = errno;
			
			str.sprintf("Error while reading'%s':\n%s",in.name(),strerror(iCache_errno));
			spBusyText->setText(str);
			spBusyText->update();
			spTimer->stop();
			
			in.close();
			out.close();
			QObject::disconnect(spTimer,SIGNAL(timeout()),this,SLOT(copyfile()));
			bBusy = FALSE;
			emit failed(iCache_errno);
	}
}

QString CopyProgressWidget::getSource()
{
	return in.name();
}

QString CopyProgressWidget::getDestination()
{
	return out.name();
}

int CopyProgressWidget::setBuffersize(unsigned int uiBuffersize)
{
	int uiMyBuffersize_old=uiMyBuffersize;
	uiMyBuffersize = (uiBuffersize > 4096) ? uiBuffersize : 4096;
	return uiMyBuffersize_old;
}
	
void CopyProgressWidget::abort()
{
	if (spTimer->isActive())
	{
		QString str;
		
		spTimer->stop();
		spProgress->setPos(0);
		in.close();
		out.close();
		if (out.exists())
		{
			unlink(out.name());
			str = QString("Destinationfile \"") + QString(out.name()) + QString("\" Removed.");
			spBusyText->setText(str);
		}
		spBusyText->setText("Copy aborted, nothing written");
		spBusyText->update();
		QObject::disconnect(spTimer,SIGNAL(timeout()),this,SLOT(copyfile()));
		bBusy=FALSE;
		emit failed(EINTR);
	}
}

void CopyProgressWidget::setSource(const char* szSource)
{

	if (szSource)
	{
		in.setName(szSource);
		emit sourceChanged(szSource);
	}
}

void CopyProgressWidget::setDestination(const char*szDestination)
{
	if (szDestination)
	{
		out.setName(szDestination);
		emit destinationChanged(szDestination);
	}
}
