// -*- C++ -*-
/*  Light-weight streams.
    These are meant to be used with the same syntax as the C++ streams
    classes, but are much more economical.  (Use of iostreams makes the
    executable files much bigger, e.g., over 300K on UNIX.)

    Author: John Collins, collins@phys.psu.edu.
    22 Jan 96

    (C) John Collins & Penn State University.
*/

// 13. March 1997
// Included into the LyX source three, began working on making this
// use more low-level functions than the ones from stdio.h. Deleted
// all of the code written by John Collins, only the names are left.
// A first shoot at this is an unbuffered version. The buffered one
// will have to wait a bit.
//
// I want these classes sos, isos, osos, ifsos, ofsos in this class three
//                             sos
//                            /   \
//                         isos    osos      (this figure is 
//                          |       |         not correct
//                        ifsos    ofsos      anymore)
//
// I look closely on ch. 10 of Bjarne Stroustups: The C++ Programming Language
// when doing this.
//
// Lgb

// Flag that I've been included:
#ifndef _SOS_H
#define _SOS_H

// ============== Standard streams:
class osos;
extern osos lite_cout, lite_cerr;

typedef unsigned char sos__iostate;

//
struct _sos_fields
{ // The datamembers of an sos.
	// Fill in more if needed
	sos__iostate _state;
};

class sos : public _sos_fields {
public:
	typedef int iostate;
	enum open_mode {
		in = 1,          // open for reading
		out = 2,         // open for output
		ate = 4,         // open and seek to end of file
		app = 010,       // append
		trunc = 020,     // truncate file to 0-length
		nocreate = 040,  // fail if file does not exist
		noreplace = 0100, // file if file exist
		bin = 0200       
	};

	enum io_state {
		goodbit = 0,
		eofbit = 1,
		failbit = 2,
		badbit = 4
	};
	iostate _state;
	
	/// end of file seen
	bool eof() const { return _state & sos::eofbit; }
	
	/// next operation will fail
	bool fail() const { return _state & (sos::badbit|sos::failbit);}
	
	/// stream corrupted
	bool bad() const { return _state & sos::badbit;}
	
	/// next operation might succeed
	bool good() const { return _state == 0; }
	
	/// returns the state
	iostate rdstate() const { return _state; }
};

// should be manipulators
void endl (sos & f);
void flush (sos & f);


class isos : public sos {
public:
	// operators
	isos& operator>>(char*);
	isos& operator>>(unsigned char* p) { return operator>>((char*)p); }
	isos& operator>>(signed char*p) { return operator>>((char*)p); }
	isos& operator>>(char& c);
	isos& operator>>(unsigned char& c) {return operator>>((char&)c);}
	isos& operator>>(signed char& c) {return operator>>((char&)c);}
	isos& operator>>(int&);
	isos& operator>>(long&);
	isos& operator>>(short&);
	isos& operator>>(unsigned int&);
	isos& operator>>(unsigned long&);
	isos& operator>>(unsigned short&);
#ifndef bool /* ignore if bool is just int */
	isos& operator>>(bool&);
#endif /*bool */
	isos& operator>>(float&);
	isos& operator>>(double&);
	isos& operator>>(long double&);
};


class osos : public sos {
	int fd;
public:
	osos() { }
	osos(int f) { fd = f;}
	osos& flush();

	osos& operator<<(const char *s);
	osos& operator<<(const unsigned char *s)
        {
		return (*this) << (const char*)s;
	}
	osos& operator<<(const signed char *s)
        {
		return (*this) << (const char*)s;
	}
	int filedesc() { return fd; }
};


class iosos : public isos, public osos {
public:
	iosos() { }
};



class fsosbase : public sos {
	//streambuf _str_buf;
	int fd; // the filedesriptor
public:
	fsosbase();
	fsosbase(int fd);
	fsosbase(int fd, char *p, int l); /* Deprecated */
	fsosbase(const char *name, int mode, int prot=0664);
	void close();
	void open(const char *name, int mode, int prot=0664);
	//int is_open() const { return rdbuf()->is_open(); }
	int filedesc() { return fd; }
};


class ofsos : public fsosbase, public osos {
public:
	ofsos() : fsosbase() { }
	ofsos(int fd) : fsosbase(fd) { }
	ofsos(const char *name, int mode=sos::out, int prot=0664)
		: fsosbase(name, mode, prot) { }
	void open(const char *name, int mode=sos::out, int prot=0664)
        { fsosbase::open(name, mode, prot); }
};


class ifsos : public fsosbase, public isos {
public:
	ifsos() : fsosbase() { }
	ifsos(int fd) : fsosbase(fd) { }
	ifsos(const char *name, int mode=sos::in, int prot=0664)
		: fsosbase(name, mode, prot) { }
	void open(const char *name, int mode=sos::in, int prot=0664)
        { fsosbase::open(name, mode, prot); }
};


#endif
