/*
 * mkfs		A simple generic frontend for the for the mkfs program
 *		under Linux.  See the manual page for details.
 *
 * Usage:	mkfs [-V] [-t fstype] [fs-options] device [size]
 *
 * Authors:	David Engel, <david@ods.com>
 *		Fred N. van Kempen, <waltje@uWalt.NL.Mugnet.ORG>
 *		Ron Sommeling, <sommel@sci.kun.nl>
 *
 * Patched by Guy Maor <maor@ece.utexas.edu> to fix search paths
 */


#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <getopt.h>
#include <limits.h>
#include <string.h>


#define VERSION         "1.9.1"

#ifndef DEFAULT_FSTYPE
# define DEFAULT_FSTYPE		"minix"
#endif

#define SEARCH_PATH     "PATH=/sbin/fs:/sbin"
#define PROGNAME	"mkfs.%s"


int main(int argc, char *argv[])
{
  char progname[NAME_MAX];
  char *fstype = NULL;
  int i, more = 0, verbose = 0;

  /* Check commandline options. */
  opterr = 0;
  while ((more == 0) && ((i = getopt(argc, argv, "Vt:")) != EOF))
    switch (i) {
    case 'V':
      verbose++;
      break;
    case 't':
      fstype = optarg;
      break;
    default:
      more = 1;
      break;		/* start of specific arguments */
    }
  if (optind == argc) {
    fprintf(stderr,
      "Usage: mkfs [-V] [-t fstype] [fs-options] device [size]\n");
    return -1;
  }
  
  /* If -t wasn't specified, use the default */
  if (fstype == NULL)
    fstype = DEFAULT_FSTYPE;

  /* Set PATH and program name */
  {
    char *newpath, *oldpath = getenv("PATH");
    int pathlen = strlen(SEARCH_PATH);

    if (!(newpath = (char *)malloc(strlen(oldpath) + pathlen + 2))) {
      fputs("mkfs: malloc failure.\n", stderr);
      exit(1);
    }
    strcpy(newpath, SEARCH_PATH);
    if (oldpath) {
      newpath[pathlen] = ':';
      strcpy(newpath + pathlen + 1, oldpath);
    }
    putenv(newpath);
  }
  sprintf(progname, PROGNAME, fstype);
  argv[--optind] = progname;

  if (verbose) {
    puts("mkfs version " VERSION " (" __DATE__ ")");
    i = optind;
    while (argv[i])
      printf("%s ", argv[i++]);
    printf("\n");
    if (verbose > 1)
      return 0;
  }

  /* Execute the program */
  execvp(progname, argv+optind);
  perror(progname);
  return 1;
}
