#include <stdio.h>

/* 
 * twconvert
 *
 *	convert v1.0 Tripwire databases to v1.1
 *
 * Gene Kim
 * $Id: twconvert.c,v 1.1 1993/12/13 04:02:27 genek Exp $
 */


void b64_convert();

void
main()
{
/* filename: (entrynumber, ignorevec, st_mode, st_ino, st_nlink,
 *		st_uid, st_gid, st_size,
 *		ltob64(statbuf->st_atime, vec64_a),
 *		ltob64(statbuf->st_mtime, vec64_m),
 *		ltob64(statbuf->st_ctime, vec64_c), sig0, sig1, ..., sig9
 */

    char s[2048], t[2048];
    char filename[1024], entrynum[128], ignorevec[128], st_mode[128], 
		st_ino[128], 
		st_nlink[128],
 		st_uid[128], st_gid[128], st_size[128],
		vec64[13][128];
    int err, i;
    int linenumber = 0;

    while (fgets(s, sizeof(s), stdin) != NULL) {
	linenumber++;
	if (s[0] == '#' || s[0] == '@') {
	    fputs(s, stdout);
	    continue;
	}
	if ((err = sscanf(s, "%s %s %s %s %s %s %s %s %s %s %s %s %s %s %s %s %s %s %s %s %s %s", 
		    filename, entrynum, ignorevec, st_mode, st_ino, 
		    st_nlink,
		    st_uid, st_gid, st_size,
		    vec64[0],
		    vec64[1],
		    vec64[2],
		    vec64[3],
		    vec64[4],
		    vec64[5],
		    vec64[6],
		    vec64[7],
		    vec64[8],
		    vec64[9],
		    vec64[10],
		    vec64[11],
		    vec64[12])) != 22) {
	    fputs(s, stdout);
	    continue;
	}

	/* convert */
	b64_convert(ignorevec);
	for (i = 0; i < 13; i++) {
	    b64_convert(vec64[i]);
	}
	sprintf(t, "%s %s %s %s %s %s %s %s %s %s %s %s %s %s %s %s %s %s %s %s %s %s \n", 
		    filename, entrynum, ignorevec, st_mode, st_ino, 
		    st_nlink,
		    st_uid, st_gid, st_size,
		    vec64[0],
		    vec64[1],
		    vec64[2],
		    vec64[3],
		    vec64[4],
		    vec64[5],
		    vec64[6],
		    vec64[7],
		    vec64[8],
		    vec64[9],
		    vec64[10],
		    vec64[11],
		    vec64[12]);
	fputs(t, stdout);
	if (strlen(s) != strlen(t)) {
	    fprintf(stderr, "strlens differ: old=%d, new=%d\n", strlen(s), strlen(t));
	    exit(1);
	}
    }
    exit(0);
}

static char new64vec[] =
  "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz:.";
static char old64vec[] =
  "./0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";

void
b64_convert(s)
    char *s;
{
    int i;
    char *pc;
    char tmp[64];

    if (strcmp(s, "0") == 0) {
	return;
    }

    strcpy(tmp, s);

    for (pc = s; *pc; pc++) {
	/* search old vector */
	for (i = 0; i < 64; i++) {
	    if (old64vec[i] == *pc) {
		*pc = new64vec[i];
		break;
	    }
	}
    }

    /*
    fprintf(stderr, "(%s) --> (%s)\n", tmp, s);
    */
}
