/*
 *
 *  (c) COPYRIGHT INRIA, 1996.
 *  Please first read the full copyright statement in file COPYRIGHT.
 *
 */

/* Module indpres.c */
/* exceptions pour la presentation des index */

#include "thot_sys.h"

#include "constmedia.h"
#include "typemedia.h"

/* ------------------* PROCEDURES EXTERNES *------------------------------- */
/* procedures importees de l'editeur */
#include "tree_f.h"
#include "memory_f.h"
#include "exceptions_f.h"

/* procedures definies dans le module */
#include "indpres_f.h"

/*----------------------------------------------------------------------
   Ind_AjouterTerme                                               
   pEl = pointeur sur le terme ou la cle referencee                
   pAb = pointeur sur le pave a remplir                           
   rempli le pave par les cles de toutes les entrees Xniveau        
  ----------------------------------------------------------------------*/
#ifdef __STDC__
static void         Ind_AjouterTerme (PtrAbstractBox * pAb, PtrElement pEl, PtrTextBuffer * pBuff)
#else  /* __STDC__ */
static void         Ind_AjouterTerme (pAb, pEl, pBuff)
PtrAbstractBox     *pAb;
PtrElement          pEl;
PtrTextBuffer      *pBuff;

#endif /* __STDC__ */
{
   PtrElement          pEC;
   PtrTextBuffer       pBuffE, pBuffP;
   PtrAbstractBox      pPa1;

   pEC = FirstLeaf (pEl);
   /* c'est une feuille */
   if (pEC->ElLeafType == LtText)
      /* c'est une feuille de texte, on la copie */
     {
	pBuffE = pEC->ElText;
	/* pointeur sur le buffer de */
	/* l'element a copier */
	while (pBuffE != NULL)
	   /* copie les buffers de l'element */
	  {
	     pPa1 = *pAb;
	     GetTextBuffer (&pBuffP);
	     /* acquiert un buffer pour la copie */
	     /* chaine le buffer de la copie */
	     if (*pBuff == NULL)
	       {
		  pPa1->AbText = pBuffP;
		  /* c'est le 1er buffer */
		  pPa1->AbLanguage = pEC->ElLanguage;
	       }
	     else
	       {
		  pBuffP->BuPrevious = *pBuff;
		  (*pBuff)->BuNext = pBuffP;
	       }
	     strncpy (pBuffP->BuContent, pBuffE->BuContent, MAX_CHAR);
	     /* copie le contenu */
	     pBuffP->BuLength = pBuffE->BuLength;
	     /* copie la longueur */
	     pPa1->AbVolume += pBuffP->BuLength;
	     *pBuff = pBuffP;
	     pBuffE = pBuffE->BuNext;
	  }
     }
}				/* end of Ind_AjouterTerme */

/*----------------------------------------------------------------------
   Ind_Separateur                                                 
   ajouter un separateur entre deux sous-cles                    
  ----------------------------------------------------------------------*/

#ifdef __STDC__
static void         Ind_Separateur (PtrAbstractBox * pAb, PtrTextBuffer * pBuff, char *separ)

#else  /* __STDC__ */
static void         Ind_Separateur (pAb, pBuff, separ)
PtrAbstractBox     *pAb;
PtrTextBuffer      *pBuff;
char               *separ;

#endif /* __STDC__ */

{
   PtrTextBuffer       pBuffP;
   PtrAbstractBox      pPa1;

   pBuffP = *pBuff;
   pPa1 = *pAb;
   /* ajouter un separateur : on suppose qu'il y a la place pour 1 espace ??? */
   strncpy ((pBuffP->BuContent) + pBuffP->BuLength, separ, 1);
   /* copie le contenu */
   pBuffP->BuLength = pBuffP->BuLength + 1;
   /* copie la longueur */
   pPa1->AbVolume++;
}				/* end of Ind_Separateur */

/*----------------------------------------------------------------------
   Ind_CopyRenvoi                                                 
   pEl = pointeur sur la cle du descripteur reference              
   pPAv = pointeur sur le pave a remplir                           
   rempli le pave par la liste des cles en separant par un espace   
  ----------------------------------------------------------------------*/

#ifdef __STDC__
static void         Ind_CopyRenvoi (PtrElement pEl, PtrAbstractBox * pAb, PtrTextBuffer * pBuff)

#else  /* __STDC__ */
static void         Ind_CopyRenvoi (pEl, pAb, pBuff)
PtrElement          pEl;
PtrAbstractBox     *pAb;
PtrTextBuffer      *pBuff;

#endif /* __STDC__ */

{
   PtrElement          pElem;
   PtrAbstractBox      pPa1;

   pPa1 = *pAb;
   pElem = pEl->ElFirstChild;	/* la premiere cle */
   while (pElem != NULL)
     {
	Ind_AjouterTerme (&pPa1, pElem, pBuff);
	pElem = pElem->ElNext;
	if (pElem != NULL)	/* pas de separateur apres la derniere cle */
	   Ind_Separateur (&pPa1, pBuff, "/");
     }				/* end of while */
}				/* end of proc Ind_CopyRenvoi */

/*----------------------------------------------------------------------
   Ind_CopyRefCR                                                  
   pEl = pointeur sur le Terme de l'Entree referencee              
   pPAv = pointeur sur le pave a remplir                           
   rempli le pave par les cles de toutes les entrees Xniveau        
  ----------------------------------------------------------------------*/

#ifdef __STDC__
void                Ind_CopyRefCR (PtrElement pEl, PtrAbstractBox * pAb, PtrTextBuffer * pBuff)

#else  /* __STDC__ */
void                Ind_CopyRefCR (pEl, pAb, pBuff)
PtrElement          pEl;
PtrAbstractBox     *pAb;
PtrTextBuffer      *pBuff;

#endif /* __STDC__ */

{
   int                 C_PIV_TYPE;
   PtrElement          pEntree1, pElem;
   PtrSSchema          pSS;
   PtrAbstractBox      pPa1;
   PtrElement          pEntree2 = NULL;
   PtrElement          pEntree3 = NULL;

   pPa1 = *pAb;
   if (TypeHasException (1230, pPa1->AbElement->ElTypeNumber,
			 pPa1->AbElement->ElStructSchema))
      /* c'est un renvoi (exception (1230) */
      Ind_CopyRenvoi (pEl, pAb, pBuff);
   else
      /* C'est un RefCr  (exception 1254) */
     {
	pSS = pEl->ElStructSchema;	/* le schema des tables d'index */
	pEntree1 = pEl->ElParent;
	/* rechercher l'elem index contenant tous ces termes */
	C_PIV_TYPE = GetElemWithException (1240, pSS);	/* 1240 = Elem_Index */
	pElem = BackSearchTypedElem (pEntree1, C_PIV_TYPE, pSS);

	/* remonter les entrees jusqu'a cet Elem_Index */
	/* pEntree1 = le terme de dernier niveau */
	if (pEntree1->ElParent != pElem)
	  {
	     pEntree2 = pEntree1->ElParent->ElParent->ElParent->ElFirstChild;
	     if (pEntree2->ElParent != pElem)
		pEntree3 = pEntree2->ElParent->ElParent->ElParent->ElFirstChild;
	  }

	/* recopier cette liste de termes */
	if (pEntree3 != NULL)
	  {
	     Ind_AjouterTerme (&pPa1, pEntree3->ElFirstChild, pBuff);
	     Ind_Separateur (&pPa1, pBuff, " ");
	  }
	if (pEntree2 != NULL)
	  {
	     Ind_AjouterTerme (&pPa1, pEntree2->ElFirstChild, pBuff);
	     Ind_Separateur (&pPa1, pBuff, " ");
	  }
	Ind_AjouterTerme (&pPa1, pEntree1->ElFirstChild, pBuff);

     }				/* end of else */
}				/* end of proc Ind_CopyRefCR */
