/***********************************************************************/
/*                                                                     */
/*                           Objective Caml                            */
/*                                                                     */
/*             Pascal Cuoq, projet Cristal, INRIA Rocquencourt         */
/*                                                                     */
/*  Copyright 1996 Institut National de Recherche en Informatique et   */
/*  Automatique.  Distributed only by permission.                      */
/*                                                                     */
/***********************************************************************/

/* $Id: windir.c,v 1.2 1996/09/05 13:32:25 xleroy Exp $ */

#include <mlvalues.h>
#include <memory.h>
#include <errno.h>
#include <alloc.h>
#include "unixsupport.h"

value win_findfirst(name)             /* ML */
     value name;
{
  int h;
  value v;
  struct _finddata_t fileinfo;
  Push_roots(r,1);

#define valname r[0] 

  h = _findfirst(String_val(name),&fileinfo);
  if (h == -1) {
    if (errno == ENOENT)
      raise_end_of_file();
    else
      uerror("opendir", Nothing);
  }
  valname = copy_string(fileinfo.name);
  v = alloc_tuple(2);
  Field(v,0) = valname;
  Field(v,1) = Val_int(h);
  return v;
}

value win_findnext(valh)
     value valh;
{
  int retcode;
  struct _finddata_t fileinfo;

  retcode = _findnext(Int_val(valh), &fileinfo);
  if (retcode != 0) raise_end_of_file();
  return copy_string(fileinfo.name);
}	

value win_findclose(valh)
	value valh;
{
  if (_findclose(Int_val(valh)) != 0) uerror("closedir", Nothing);
  return Val_unit;
}

