/*
 * array of error messages for the malloc internal errors.
 *
 * Copyright 1995 by Gray Watson
 *
 * This file is part of the dmalloc package.
 *
 * Permission to use, copy, modify, and distribute this software for any
 * NON-COMMERCIAL purpose and without fee is hereby granted, provided
 * that the above copyright notice and this permission notice appear
 * in all copies, and that the name of Gray Watson not be used in
 * advertising or publicity pertaining to distribution of the document
 * or software without specific, written prior permission.
 *
 * Please see the PERMISSIONS file or contact the author for information
 * about commercial licenses.
 *
 * Gray Watson makes no representations about the suitability of the
 * software described herein for any purpose.  It is provided "as is"
 * without express or implied warranty.
 *
 * The author may be contacted at gray.watson@letters.com
 *
 * $Id: error_str.h,v 1.19 1995/09/06 17:47:35 gray Exp $
 */

#ifndef __ERROR_STR_H__
#define __ERROR_STR_H__

/* string error codes which apply to error codes in error_val.h */
LOCAL	char	*errlist[] = {
  "no error",
  
  "errno value passed in by user is not valid",
  "errno value passed in by user is not valid",
  "errno value passed in by user is not valid",
  "errno value passed in by user is not valid",
  "errno value passed in by user is not valid",
  "errno value passed in by user is not valid",
  "errno value passed in by user is not valid",
  "errno value passed in by user is not valid",
  "errno value passed in by user is not valid",
  
  /* administrative errors */
  "initialization and setup failed",
  "malloc library has gone recursive",
  "errno value passed in by user is out-of-bounds",
  
  "errno value passed in by user is not valid",
  "errno value passed in by user is not valid",
  "errno value passed in by user is not valid",
  "errno value passed in by user is not valid",
  "errno value passed in by user is not valid",
  "errno value passed in by user is not valid",
  "errno value passed in by user is not valid",
  
  /* pointer verification errors */
  "pointer is null",
  "pointer is not pointing into heap data space",
  "cannot locate pointer in heap",
  "found pointer the user was looking for",
  "possibly bad .c filename pointer",
  "possibly bad .c file line-number",
  "failed UNDER picket-fence magic-number checking",
  "failed OVER picket-fence magic-number checking",
  "use of pointer would exceed allocation",
  "pointer is on free list",
  
  "errno value passed in by user is not valid",
  "errno value passed in by user is not valid",
  "errno value passed in by user is not valid",
  "errno value passed in by user is not valid",
  "errno value passed in by user is not valid",
  "errno value passed in by user is not valid",
  "errno value passed in by user is not valid",
  "errno value passed in by user is not valid",
  "errno value passed in by user is not valid",
  "errno value passed in by user is not valid",
  
  /* allocation errors */
  "invalid allocation size",
  "largest maximum allocation size exceeded",
  "user allocated space contiguous block error",
  "could not allocate more memory, heap extension failed",
  "heap extension failed to produce linear address space",
  "bad size in information structure",
  "external sbrk is too large and cannot be handled",
  
  "errno value passed in by user is not valid",
  "errno value passed in by user is not valid",
  "errno value passed in by user is not valid",
  "errno value passed in by user is not valid",
  "errno value passed in by user is not valid",
  "errno value passed in by user is not valid",
  "errno value passed in by user is not valid",
  "errno value passed in by user is not valid",
  "errno value passed in by user is not valid",
  "errno value passed in by user is not valid",
  "errno value passed in by user is not valid",
  "errno value passed in by user is not valid",
  "errno value passed in by user is not valid",
  
  /* free errors */
  "pointer is not on block boundary",
  "tried to free pointer which is already freed",
  "pointer does not point to start of user-allocated space",
  "pointer does not point to user-allocated space",
  "inconsistency with free linked-list",
  "free space contiguous block error",
  "bad basic-block memory pointer in free-list",
  "space that should be free has been overwritten",
  
  "errno value passed in by user is not valid",
  "errno value passed in by user is not valid",
  "errno value passed in by user is not valid",
  "errno value passed in by user is not valid",
  "errno value passed in by user is not valid",
  "errno value passed in by user is not valid",
  "errno value passed in by user is not valid",
  "errno value passed in by user is not valid",
  "errno value passed in by user is not valid",
  "errno value passed in by user is not valid",
  "errno value passed in by user is not valid",
  "errno value passed in by user is not valid",
  
  /* dblock errors */
  "bad divided-block chunk size",
  "bad divided-block pointer",
  "bad basic-block memory pointer in dblock struct",
  "bad divided-block admin pointer",
  "bad divided-block admin magic numbers",
  "bad divided-block chunk admin information structure",
  
  "errno value passed in by user is not valid",
  "errno value passed in by user is not valid",
  "errno value passed in by user is not valid",
  "errno value passed in by user is not valid",
  
  /* administrative errors */
  "admin structure pointer out of bounds",
  "bad admin structure list",
  "bad magic number in admin structure",
  "bad basic-block count value in admin structure",
  "bad basic-block administration pointer",
  "bad basic-block administration counter",
  
  "errno value passed in by user is not valid",
  "errno value passed in by user is not valid",
  "errno value passed in by user is not valid",
  "errno value passed in by user is not valid",
  
  /* heap check verification */
  "bad basic-block allocation order",
  "basic-block has bad flag value"
  };

#endif /* ! __ERROR_STR_H__ */
