/*
    cthugha.c

    General functions
*/

#include "cthugha.h"
#include "information.h"			/* title, credits, ... */
#include "display.h"
#include "sound.h"
#include "net_sound.h"
#include "action.h"				/* display_sound() */
#include "translate.h"
#include "options.h"
#include "keys.h"
#include "cd_player.h"
#include "display.h"

#include <vga.h>
#include <unistd.h>
#include <stdlib.h>
#include <time.h>
#include <stdio.h>

int cthugha_pause = 0;
int cthugha_verbose = 0;
int cthugha_finish = 0;
int BUFF_WIDTH = 320;
int BUFF_HEIGHT = 200;
int buffer_sizes[][2] = {			/* predefined buffer-sizes */
    { 160, 100 },    { 320, 200 },    { 320, 300 },    { 360, 480 },
    { 640, 480 }
};
int nr_buffer_sizes = sizeof(buffer_sizes)/sizeof(int)/2;


void pause_for_key() {
    if( cthugha_pause <= 0) 
	return;
    printf("Press <enter> to continue.\n");
    fflush(stdout);
    getchar();
}

void cthugha_termination();

/*
 * startup-code for cthugha
 */
int init_cthugha(int argc, char ** argv) {
    srand(time(0));	

    if( get_params(argc, argv) )	/* parse cmd-line and read ini-files*/
	return 1;

    pause_for_key();
	
#ifndef CTH_saverX11
    init_ncurses();			/* initialize ncurses */

    atexit(cthugha_termination);	/* make sure exit_ncurses is called */
    
    title();				/* Display titlemessage */
#endif
    options_information();
		
    /* Initialization */
#ifndef CTH_saverX11
    if( server) 
	if(init_server() )	return exit_cthugha(-6);
#endif
    if( init_action() )		return exit_cthugha(-5);
    if( init_display() )	return exit_cthugha(-4);
    if( init_translate() )	return exit_cthugha(-3);
    if( init_sound() )		return exit_cthugha(-2);

    /* read usage from ini-file */
    read_ini_usage();

    /* set first flame, wave... functions */
    init_startup();

    pause_for_key();
	
    return 0;
}

void cthugha_termination() {
#ifndef CTH_saverX11
    exit_ncurses();				/* close ncurses */
#endif
}

/*
 * shutdown code for cthugha
 */
int exit_cthugha(int level) {

    if ( level == 0) 				/* save opt. on normal exit */
	exit_startup();

    if ( level < 0) {				/* error wait for a key */
	cthugha_pause = 1;
	pause_for_key();
	level = - level - 1;
    }
		
    switch(level) {
    case 0:					/* finish everything */
	exit_sound();							
    case 1:			
	exit_translate();
    case 2:			
	exit_display();
    case 3:			
	exit_action();
#ifndef CTH_saverX11
    case 4:
	if(server)    exit_server();
#endif
    }
	
    if ( level == 0) {				/* normal exit */
	if ( cthugha_pause) 
	    pause_for_key();
	
#ifndef CTH_saverX11
	show_credits();
#endif
    }

#ifndef CTH_saverX11
    exit_ncurses();				/* close ncurses */
#endif
	
    return level;
}

#ifndef CTH_saverX11
int main_key_switch(int key) {
    char str[256];

    switch( key ) {
    case Z_NOKEY:
	return 0;
    case Z_ESC:					/* Exit */
	if ( display_text_on_screen)
	    display_print(NULL,0,1);
	else
	    cthugha_finish = 1;
	break;
    case Z_FLAME:				/* next flame */
	change_flame(CHANGE_NEXT);
	break;
    case Z_FLAME_R:				/* prev flame */
	change_flame(CHANGE_PREV);
	break;
    case Z_FLAME_GENERAL:
	change_flame_general();
	break;
    case Z_WAVE:				/* next wave-display */
	change_display_wave(CHANGE_NEXT);
	break;
    case Z_WAVE_R:				/* prev wave-display */
	change_display_wave(CHANGE_PREV);
	break;
    case Z_DISPLAY:				/* next display */
	change_update_screen(CHANGE_NEXT);
	break;
    case Z_DISPLAY_R:				/* prev display */
	change_update_screen(CHANGE_PREV);
	break;
    case Z_TRANSLATE:				/* next translation */
	change_translate(CHANGE_NEXT);
	break;
    case Z_TRANSLATE_R:				/* prev translation */
	change_translate(CHANGE_PREV);
	break;
    case Z_MASSAGE:				/* next massage */
	change_massage_style(CHANGE_NEXT);
	break;
    case Z_MASSAGE_R:				/* prev massage */
	change_massage_style(CHANGE_PREV);
	break;
    case Z_FFT:					/* toggle FFT-usage */
	change_FFT(CHANGE_NEXT);
	break;
    case Z_PALETTE:				/* next palette */
	change_palette(CHANGE_NEXT,0);
	break;
    case Z_PALETTE_R:				/* prev palette */
	change_palette(CHANGE_PREV,0);
	break;
    case Z_TABLE:				/* next table */
	change_table(CHANGE_NEXT);
	break;
    case Z_TABLE_R:				/* prev table */
	change_table(CHANGE_PREV);
	break;
    case Z_LOCK:				/* lock */
	change_lock(CHANGE_NEXT);
	break;
    case Z_INFORMATION:				/* information */
	status(1);
	break;
    case Z_HELP:
/*    case Z_KEY1: */
	help();
	break;
    case Z_SAMPLE_DN:				/* Sample-Rate-1000 */
	if ( (sound_sample_rate -= 1000) <= 0)
	    sound_sample_rate = 0;
	update_dsp();
	break;
    case Z_SAMPLE_UP:				/* Sample Rate+1000 */
	sound_sample_rate += 1000;
	update_dsp();
	break;
    case Z_STEREO:				/* toggle channels */
	sound_stereo = (sound_stereo == 1) ? 2 : 1;
	update_dsp();
	break;
    case Z_NOISE_UP:					
	sound_minnoise += 2;
    case Z_NOISE_DN:
	sound_minnoise --;
	if ( sound_minnoise < 0)	sound_minnoise = 0;
	if ( sound_minnoise > 256)	sound_minnoise = 256;
	sprintf(str, "Minnoise: %d", sound_minnoise);
	display_print(str,0,1);
	break;

    case Z_PCX:					/* show pcx-picture */
    case Z_PCX_R:
	if ( display_use_pcx) { 
	    int tmp = display_text_on_screen;
	    display_text_on_screen = 0;
	    show_pcx( 1 /*upper-left*/, 1 /*correct-colors*/);	

	    switch( key) {
	    case Z_PCX:
		change_pcx(CHANGE_NEXT);	break;
	    case Z_PCX_R:
		change_pcx(CHANGE_PREV);
	    }

	    display();
	    sleep(1);
	    display_text_on_screen = tmp;
	    update_palette();
	} else {
	    display_print("PCX is disabled", -1,1);
	}
	break;
	
    case Z_DISPOPTION:
    case Z_KEY2:
	select_screen();
	break;
    case Z_WAVEOPTION:
/*    case Z_KEY3: */
	select_wave();
	break;
    case Z_FLAMEOPTION:
    case Z_KEY4:
	select_flame();
	break;
    case Z_TRANSOPTION:
    case Z_KEY5:
	select_translate();
	break;
    case Z_PALOPTION:
    case Z_KEY6:
	select_palette();
	break;
    case Z_PCXOPTION:
    case Z_KEY7:
	select_pcx(); 
	break;
	
    case Z_ADDINI:
	write_ini();
	break;
	
	/* CD-Player is activated with number keys (on keypad) */
    case Z_CD:
	cd_player();
	break;

    case Z_OPTIONS:
	options_dialog();
	break;

    case Z_REQUEST_NET:			/* send request to server */
	net_request(0);
	break;

    case Z_SCREEN_DUMP:			/* real print screen */
	save_display();
	break;

    default:				/* change everything */
	general_change();
	break;
    }
    update_status();
    return 1;
}

#endif












