#include "cthugha.h"
#include "action.h"
#include "translate.h"

#include "display.h"

#include <string.h>

/* possible flames */
void flame_clear();	void flame_upslow();	void flame_upsubtle();	
void flame_upfast();	void flame_leftslow();	void flame_leftsubtle();
void flame_leftfast();	void flame_rightslow();	void flame_rightsubtle();
void flame_rightfast();	void flame_water();	void flame_watersubtle();
void flame_skyline();	void flame_weird();	void flame_zzz();
void flame_fade();	void flame_general_subtle();
void flame_general_slow();

void flame_general_subtle_no_trans();
void flame_general_subtle_trans();

void flame_general_slow_no_trans();
void flame_general_slow_trans();

opt_data flames[] = {
    { flame_clear,		0,	"Clear",	"Blank the buffer" },
    { flame_upslow,		1,	"u-Sl",		"Up Slow"},
    { flame_upsubtle,		1,	"u-Su",		"Up Subtle"},
    { flame_upfast,		1,	"u-Fa",		"Up Fast"},
    { flame_leftslow,		1,	"l-Sl",		"Left Slow"},
    { flame_leftsubtle,		1,	"l-Su",		"Left Subtle"},
    { flame_leftfast,		1,	"l-Fa",		"Left Fast"},
    { flame_rightslow,		1,	"r-Sl",		"Right Slow"},
    { flame_rightsubtle,	1,	"r-Su",		"Right Subtle"},
    { flame_rightfast,		1,	"r-Fa",		"Right Fast"},
    { flame_water,		1,	"Water", 	"Water"},
    { flame_watersubtle,	1,	"Wa-s",		"Water Subtle"},
    { flame_skyline,		1,	"Skyline",	"Skyline"},
    { flame_weird,		1,	"Weird", 	"Weird"},
    { flame_zzz,		1,	"Zzz",		"Zzz"},
    { flame_fade,		1,	"Fade",		"Fade"},
    { flame_general_subtle,	1,	"GenSubt",	"General Subtle"},
    { flame_general_slow,	1,	"GenSlow",	"General Slow"}
};
int nr_flames = sizeof(flames) / sizeof(opt_data);

/*****************************************************************************/

unsigned char divsub[4*256];
unsigned char divsub2[4*256];
unsigned int divsub4_1[256*256];
unsigned int divsub4_2[256*256];

/*
 * Initialize the tables used in the flame-functions
 */
int init_action_tables() {
    int i,j;

    for(i=0; i < 4*256; i++) {
	divsub[i]  = i >> 2 ? (i >> 2) - 1 : 0;
	divsub2[i] = i >> 1 ? (i >> 1) - 1 : 0;
    }
    for(i=0; i < 256; i++) 
	for(j=0; j < 256; j++) {
	    divsub4_1[i+256*j] = (i <= 2 ? 0 : i - 2) +
		(j <= 2 ? 0 : j - 2) * 256;
	    divsub4_2[i+256*j] = divsub4_1[i+256*j] << 16;
	}

    return 0;
}

int flame_offset[4] = {0,0,0,0};		/* table for general flames */
int flame_general[5] = {0,0,0,0,0};
    
void general_offset() {
    int i;
    /* offset to the neighbors */
    int position[9] = {
	-BUFF_WIDTH-1,	-BUFF_WIDTH, -BUFF_WIDTH+1,
	-1,		0,	     1,
	+BUFF_WIDTH-1,  +BUFF_WIDTH, +BUFF_WIDTH+1
    };

    /* generate offset-table */
    for(i=0; i < 4; i++)
	flame_offset[i] = position[ flame_general[i] ] + 
	    position[ flame_general[4] ];
} 


/*
 * The trivial flame function. Used for debugging wave-fuctions
 */
void flame_clear() {
    memset( active_buffer, 0, BUFF_SIZE);
}

/*****************************************************************************
 *  FLAME-UP
 *****************************************************************************/

#define PTR     unsigned char * ptr;		\
		ptr = active_buffer;		\
		active_buffer = passive_buffer; \
		passive_buffer = ptr;
	

void flame_upslow() {		
    int i;
    unsigned int tmp;
    unsigned int tmp2;
    PTR;
    ptr = active_buffer + BUFF_WIDTH;

    ptr ++;    
    tmp = (unsigned int)(* (ptr-2-1)) + 
	(unsigned int)(* (ptr-1-1)) + 
	(unsigned int)(* (ptr-1));
    for(i=BUFF_SIZE; i != 0; i--) {
	tmp = tmp - 
	    (unsigned int)(* (ptr-2-1)) + 
	    (unsigned int)(* (ptr+1-1));
	tmp2 = tmp + 
	    (unsigned int)(* (ptr+BUFF_WIDTH-1));
	* (ptr - BUFF_WIDTH-1) = divsub[tmp2]; 
	ptr ++;
    }
}

void flame_upsubtle() {
    flame_offset[0] = -1+BUFF_WIDTH;
    flame_offset[1] = 0+BUFF_WIDTH;
    flame_offset[2] = 1+BUFF_WIDTH;
    flame_offset[3] = BUFF_WIDTH+BUFF_WIDTH;

    if ( active_translation == 0) 
	flame_general_subtle_no_trans();
    else
	flame_general_subtle_trans();
}

/* about 24 fps */
void flame_upfast() {				
    int i;
    int tmp;
    PTR;
    ptr = active_buffer + BUFF_SIZE;
	
    for(i=BUFF_SIZE; i != 0; i--) {
	tmp =  			
	    (int)(* ptr) +
	    (int)(* (ptr+BUFF_WIDTH-1)) + 
	    (int)(* (ptr+BUFF_WIDTH+1)) + 
	    (int)(* (ptr+BUFF_WIDTH));
	* ptr = divsub[tmp];
	ptr --;
    }
}

/*****************************************************************************
 *  FLAME-LEFT
 *****************************************************************************/

/* about 24 fps */
void flame_leftslow() {	
    int i;
    int tmp;
    PTR;
    ptr = active_buffer + BUFF_WIDTH;
	
    for(i=BUFF_SIZE; i != 0; i--) {
	tmp =  				
	    (int)(* (ptr-BUFF_WIDTH+1)) +
	    (int)(* ptr) + 					
	    (int)(* (ptr+1)) + 				
	    (int)(* (ptr+BUFF_WIDTH));
	* (ptr-BUFF_WIDTH) = divsub[tmp];  
	ptr ++;
    }
}

void flame_leftsubtle() {				
    flame_offset[0] = +1;
    flame_offset[1] = +BUFF_WIDTH;
    flame_offset[2] = 1+BUFF_WIDTH;
    flame_offset[3] = BUFF_WIDTH+BUFF_WIDTH;

    if ( active_translation == 0) 
	flame_general_subtle_no_trans();
    else
	flame_general_subtle_trans();
}

/* about 26 fps */
void flame_leftfast() {	
    int i;
    int tmp;
    PTR;
    ptr = active_buffer + BUFF_SIZE;
	
    for(i=BUFF_SIZE; i != 0; i--) {
	tmp =  
	    (int)(* ptr) +
	    (int)(* (ptr+BUFF_WIDTH+1)) + 
	    (int)(* (ptr+BUFF_WIDTH+1)) + 
	    (int)(* (ptr+BUFF_WIDTH));
	* ptr = divsub[tmp];
	ptr --;
    }
}

/*****************************************************************************
 *  FLAME-RIGHT
 *****************************************************************************/

/* about 23 fps */
void flame_rightslow() {				
    int i;
    int tmp;
    unsigned char * src = passive_buffer + BUFF_WIDTH+1;
    unsigned char * dst = active_buffer+1;
	
    for(i=BUFF_SIZE; i != 0; i--) {
	tmp = 
	    (int)(* (src-BUFF_WIDTH-1)) + 
	    (int)(* src) + 			
	    (int)(* (src-1)) + 			
	    (int)(* (src+BUFF_WIDTH));
	* dst = divsub[tmp];
	dst ++;
	src ++;
    }
}

void flame_rightsubtle() {	
    flame_offset[0] = -1;
    flame_offset[1] = BUFF_WIDTH-1;
    flame_offset[2] = BUFF_WIDTH;
    flame_offset[3] = BUFF_WIDTH+BUFF_WIDTH;

    if ( active_translation == 0) 
	flame_general_subtle_no_trans();
    else
	flame_general_subtle_trans();
}

/* about 29 fps */
void flame_rightfast() {				
    int i;
    int tmp;
    PTR;
    ptr = active_buffer + BUFF_SIZE;

    for(i=BUFF_SIZE; i != 0; i--) {
	tmp =  			
	    (int)(* ptr) +
	    (int)(* (ptr+BUFF_WIDTH-1)) + 		
	    (int)(* (ptr+BUFF_WIDTH-1)) + 	
	    (int)(* (ptr+BUFF_WIDTH));
	* ptr = divsub[tmp];
	ptr --;
    }
}

/****************************************************************************
 *  FLAME-WATER
 *****************************************************************************/

/* about 23 fps */
void flame_water() {
    int i;
    int tmp;
    unsigned char * src = passive_buffer + BUFF_WIDTH;
    unsigned char * dst = active_buffer;

    for(i=BUFF_SIZE/2+BUFF_WIDTH; i != 0; i--) {
	tmp = 
	    (int)(* (src-1)) + 		
	    (int)(* src) + 	
	    (int)(* (src+1)) + 	
	    (int)(* (src+BUFF_WIDTH));
	* dst = divsub[tmp];
	dst ++;
	src ++;
    }

    src = passive_buffer + BUFF_WIDTH * (BUFF_HEIGHT-2);
    dst = active_buffer + BUFF_WIDTH * (BUFF_HEIGHT-1);
    for(i=BUFF_SIZE/2; i != 0; i--) {
	tmp = 
	    (int)(* (src-BUFF_WIDTH+1)) + 
	    (int)(* src) + 					
	    (int)(* (src+1)) + 				
	    (int)(* (src-BUFF_WIDTH));
	* dst = divsub[tmp];
	dst --;
	src --;
    }
}

/* about 29 fps */
void flame_watersubtle() {
    int i;
    unsigned char tmp;
    char * src = passive_buffer + BUFF_WIDTH;
    char * dst = active_buffer;

    for(i=BUFF_SIZE/2+BUFF_WIDTH; i != 0; i--) {
	tmp = 
	    (int)(* (src-1)) + 	
	    (int)(* src) + 	
	    (int)(* (src+1)) + 				
	    (int)(* (src+BUFF_WIDTH));
	* dst = divsub[tmp];
	dst ++;
	src ++;
    }

    src = passive_buffer + BUFF_WIDTH * (BUFF_HEIGHT-2);
    dst = active_buffer + BUFF_WIDTH * (BUFF_HEIGHT-1);
    for(i=BUFF_SIZE/2; i != 0; i--) {
	tmp = 
	    (int)(* (src-BUFF_WIDTH+1)) + 
	    (int)(* src) + 	
	    (int)(* (src+1)) + 
	    (int)(* (src-BUFF_WIDTH));
	* dst = divsub[tmp];
	dst --;
	src --;
    }
}

/****************************************************************************
 *  FLAME-others
 *****************************************************************************/

/* about 23 fps */
void flame_skyline() {
    int i;
    int tmp;
    unsigned char * src = passive_buffer + BUFF_WIDTH+1;
    unsigned char * dst = active_buffer;
	
    for(i=BUFF_SIZE; i != 0; i--) {
	tmp = 
	    (int)(* (src-1)) + 
	    (int)(* src) + 			
	    (int)(* (src+1)) + 		
	    (int)(* (src));
	* dst = divsub[tmp];
	dst ++;
	src ++;
    }
}

/* about 28 fps */
void flame_weird() {				
    int i;
    unsigned char tmp;
    char * src = passive_buffer + BUFF_WIDTH+1;
    char * dst = active_buffer+1;
	
    for(i=BUFF_SIZE; i != 0; i--) {
	tmp = 		
	    (* (src-1)) |
	    (* src) |		
	    (* (src+1)) |
	    (* (src+BUFF_WIDTH));
	* dst = divsub[tmp];
	dst ++;
	src ++;
    }
}

/*****************************************************************************
 *  new from cthugha 5.3
 *****************************************************************************/

void flame_zzz() {
    int i;
    unsigned char tmp;
    PTR;
    ptr = active_buffer + BUFF_WIDTH;

    for(i=BUFF_SIZE; i != 0; i--) {
	tmp = 
	    (* (ptr-1)) + 
	    (* (ptr+BUFF_WIDTH));
	*(ptr-BUFF_WIDTH) = divsub2[tmp];
	ptr ++;
    }
}

void flame_fade() {
    int i;
    unsigned int tmp;
    PTR;
    ptr = active_buffer;

    for(i=BUFF_SIZE/4; i != 0; i--) {
	tmp = (* (unsigned int*) ptr);
	*(unsigned int*)ptr = 
	    divsub4_1[(tmp) & 0xffff]+
	    divsub4_2[(tmp >> 16) & 0xffff];
	ptr += 4;
    }
}

/*****************************************************************************
 * general flame functions
 *
 * this functions can replace most of the functions above.
 *****************************************************************************/

/*****************************************************************************
 * general subtle flame
 *****************************************************************************/
void flame_general_subtle() {				
    general_offset();

    if ( active_translation == 0) 
	flame_general_subtle_no_trans();
    else
	flame_general_subtle_trans();
}

void flame_general_subtle_no_trans() {
    int i;
    unsigned char tmp;
    unsigned char * ptr = active_buffer;
    int offset1, offset2, offset3, offset4;
    
    /* initialize offsets
     *
     *  ptr          -> destination (active_buffer)
     *  ptr + offset -> source (passive_buffer)
     */
    offset1 = flame_offset[0] + (passive_buffer - active_buffer);
    offset2 = flame_offset[1] + (passive_buffer - active_buffer);
    offset3 = flame_offset[2] + (passive_buffer - active_buffer);
    offset4 = flame_offset[3] + (passive_buffer - active_buffer);
    
    for(i=BUFF_SIZE; i != 0; i--) {
	tmp = 
	    (* (ptr + offset1)) + 			
	    (* (ptr + offset2)) + 				
	    (* (ptr + offset3)) + 				
	    (* (ptr + offset4));
	* ptr = divsub[tmp];
	ptr ++;
    }
}
void flame_general_subtle_trans() {
    int i;
    unsigned char tmp;
    unsigned char * ptr = active_buffer;
    unsigned char * offset1, *offset2, *offset3, *offset4;
    int * trans = (int*)(active_translation);	/* transl.-map */
    done_translation = 1;
		
    offset1 = passive_buffer + flame_offset[0];
    offset2 = passive_buffer + flame_offset[1];
    offset3 = passive_buffer + flame_offset[2];
    offset4 = passive_buffer + flame_offset[3];
    
    for(i=BUFF_SIZE; i != 0; i--) {
	tmp = 
	    (* (*trans + offset1)) + 
	    (* (*trans + offset2)) + 
	    (* (*trans + offset3)) + 
	    (* (*trans + offset4));
	* ptr = divsub[tmp];
	ptr ++; trans ++;
    }
}

/*****************************************************************************
 * general slow flame
 *
 * is a bit slower than traditional flame functions
 *****************************************************************************/

void flame_general_slow() {	
    general_offset();

    if ( active_translation == 0) 	
	flame_general_slow_no_trans();
    else
	flame_general_slow_trans();
}

void flame_general_slow_no_trans() {
    int i;
    int tmp;
    unsigned char * ptr = active_buffer;
    int offset1, offset2, offset3, offset4;

    /* initialize offsets
     *
     *  ptr          -> destination (active_buffer)
     *  ptr + offset -> source (passive_buffer)
     */
    offset1 = flame_offset[0] + (passive_buffer - active_buffer);
    offset2 = flame_offset[1] + (passive_buffer - active_buffer);
    offset3 = flame_offset[2] + (passive_buffer - active_buffer);
    offset4 = flame_offset[3] + (passive_buffer - active_buffer);
	
    for(i=BUFF_SIZE; i != 0; i--) {
	tmp =
	    (int)(* (ptr + offset1)) +
	    (int)(* (ptr + offset2)) + 
	    (int)(* (ptr + offset3)) +
	    (int)(* (ptr + offset4));
	* ptr = divsub[tmp];  
	ptr ++;
    }
}

void flame_general_slow_trans() {
    int i;
    int tmp;
    unsigned char * ptr = active_buffer;
    unsigned char * offset1, *offset2, *offset3, *offset4;
    int * trans = (int*)(active_translation);	/* transl.-map */
    done_translation = 1;
		
    offset1 = passive_buffer + flame_offset[0];
    offset2 = passive_buffer + flame_offset[1];
    offset3 = passive_buffer + flame_offset[2];
    offset4 = passive_buffer + flame_offset[3];

    for(i=BUFF_SIZE; i != 0; i--) {
	tmp = 
	    (int)(* (*trans + offset1)) +
	    (int)(* (*trans + offset2)) +
	    (int)(* (*trans + offset3)) +
	    (int)(* (*trans + offset4));
	* ptr = divsub[tmp]; 
	ptr ++; trans ++;
    }
}
