;*---------------------------------------------------------------------*/
;*    Copyright (c) 1996 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    serrano/prgm/project/bigloo/runtime1.8/Eval/evprimop.scm         */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Wed Apr 26 15:32:04 1995                          */
;*    Last change :  Mon Mar 11 12:16:06 1996 (serrano)                */
;*    -------------------------------------------------------------    */
;*    This module is only used to define all the interpeter primops.   */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module __evprimop
    
   (import  (__type                    "Llib/type.scm")
	    (__bigloo                  "Llib/bigloo.scm")
	    (__error                   "Llib/error.scm")
	    (__unix                    "Llib/unix.scm")
	    (__bexit                   "Llib/bexit.scm")
	    (__structure               "Llib/struct.scm")
	    (__hash                    "Llib/hash.scm")
	    (__tvector                 "Llib/tvector.scm")
	    (__bit                     "Llib/bit.scm")
	    (__binary                  "Llib/binary.scm")
	    (__foreign                 "Llib/foreign.scm")
	    (__intext                  "Llib/intext.scm") 
	    
	    (__reader                  "Read/reader.scm")
	    
	    (__pp                      "Pp/pp.scm")
	    
	    (__rgc                     "Rgc/runtime.scm")

	    (__lalr_driver             "Lalr/driver.scm")
	    
            (__eval                    "Eval/eval.scm")
	    (__expand                  "Eval/expand.scm")

	    (evmeaning-notify-error __evmeaning "Eval/evmeaning.scm")
	    
	    (define-primop!     __evenv "Eval/evenv.scm")
	    (define-primop-ref! __evenv "Eval/evenv.scm")
	    
	    (__r4_booleans_6_1         "Ieee/boolean.scm")
	    (__r4_equivalence_6_2      "Ieee/equiv.scm")
	    (__r4_pairs_and_lists_6_3  "Ieee/pair-list.scm")
	    (__r4_symbols_6_4          "Ieee/symbol.scm")
	    (__r4_numbers_6_5          "Ieee/number.scm")
	    (__r4_numbers_6_5_fixnum   "Ieee/fixnum.scm")
	    (__r4_numbers_6_5_flonum   "Ieee/flonum.scm")
	    (__r4_characters_6_6       "Ieee/char.scm")
	    (__r4_strings_6_7          "Ieee/string.scm")
	    (__r4_vectors_6_8          "Ieee/vector.scm")
	    (__r4_control_features_6_9 "Ieee/control.scm")
	    (__r4_ports_6_10_1         "Ieee/port.scm")
	    (__r4_input_6_10_2         "Ieee/input.scm")
	    (__r4_output_6_10_3        "Ieee/output.scm"))

   (eval    (export-all)))

 
