/*---------------------------------------------------------------------*/
/*    Copyright (c) 1996 by Manuel Serrano. All rights reserved.       */
/*                                                                     */
/*                                     ,--^,                           */
/*                               _ ___/ /|/                            */
/*                           ,;'( )__, ) '                             */
/*                          ;;  //   L__.                              */
/*                          '   \    /  '                              */
/*                               ^   ^                                 */
/*                                                                     */
/*                                                                     */
/*    This program is distributed in the hope that it will be useful.  */
/*    Use and copying of this software and preparation of derivative   */
/*    works based upon this software are permitted, so long as the     */
/*    following conditions are met:                                    */
/*           o credit to the authors is acknowledged following         */
/*             current academic behaviour                              */
/*           o no fees or compensation are charged for use, copies,    */
/*             or access to this software                              */
/*           o this copyright notice is included intact.               */
/*      This software is made available AS IS, and no warranty is made */
/*      about the software or its performance.                         */
/*                                                                     */
/*      Bug descriptions, use reports, comments or suggestions are     */
/*      welcome Send them to                                           */
/*        <Manuel.Serrano@inria.fr>                                    */
/*        Manuel Serrano                                               */
/*        INRIA -- Rocquencourt                                        */
/*        Domaine de Voluceau, BP 105                                  */
/*        78153 Le Chesnay Cedex                                       */
/*        France                                                       */
/*---------------------------------------------------------------------*/


/*=====================================================================*/
/*   Ieee/string.scm                                                   */
/*   Bigloo (v1.8)                                                     */
/*   Manuel Serrano (c)       Thu Apr 11 10:48:22 PDT 1996             */
/*=====================================================================*/
#define THE_GC BOEHM_GC
#include <bigloo.h>
#include <signal.h>

/* The C generated type (for typed structures) */
extern obj_t _string_____r4_strings_6_7_45( obj_t, obj_t, obj_t );
extern obj_t _string_____r4_strings_6_7_236( obj_t, obj_t, obj_t );
extern bool_t string_cigt( obj_t, obj_t );
extern obj_t _string_append___r4_strings_6_7_245( obj_t, obj_t );
extern obj_t _string_ci_____r4_strings_6_7_221( obj_t, obj_t, obj_t );
extern obj_t _string_upcase___r4_strings_6_7_209( obj_t, obj_t );
extern obj_t string_for_read( obj_t );
extern obj_t blit_string_ur____r4_strings_6_7_25( obj_t, obj_t, obj_t, obj_t, obj_t );
DEFINE_STRING( string1153___r4_strings_6_7, aux1493, "string-ref", 10 );
extern obj_t list__string___r4_strings_6_7_155( obj_t );
extern bool_t string_____r4_strings_6_7_167( obj_t, obj_t );
extern bool_t string_____r4_strings_6_7_232( obj_t, obj_t );
DEFINE_STRING( string1152___r4_strings_6_7, aux1495, "index out of range", 18 );
extern obj_t make_string___r4_strings_6_7_49( int, obj_t );
extern obj_t _substring_ur___r4_strings_6_7_194( obj_t, obj_t, obj_t, obj_t );
static obj_t *__cnst;
extern obj_t reverse____r4_pairs_and_lists_6_3_107( obj_t );
extern bool_t bigloo_strcmp( obj_t, obj_t );
extern bool_t strcicmp( obj_t, obj_t );
extern unsigned char string_ref_ur___r4_strings_6_7_193( obj_t, long );
extern obj_t _string_for_read___r4_strings_6_7_166( obj_t, obj_t );
extern obj_t string_to_bstring( char * );
extern obj_t _string_ci_____r4_strings_6_7_11( obj_t, obj_t, obj_t );
extern obj_t _string__list___r4_strings_6_7_217( obj_t, obj_t );
extern bool_t string_lt( obj_t, obj_t );
static obj_t tvectors_declarations____r4_strings_6_7_61();
extern obj_t _string_set_ur____r4_strings_6_7_76( obj_t, obj_t, obj_t, obj_t );
extern obj_t _string_ci______r4_strings_6_7_43( obj_t, obj_t, obj_t );
extern bool_t string_cige( obj_t, obj_t );
extern obj_t _list__string___r4_strings_6_7_204( obj_t, obj_t );
extern obj_t initialization___r4_strings_6_7();
extern obj_t initialization___error();
DEFINE_STRING( string1148___r4_strings_6_7, aux1496, "", 0 );
extern obj_t _string_set____r4_strings_6_7_22( obj_t, obj_t, obj_t, obj_t );
extern obj_t _string______r4_strings_6_7_172( obj_t, obj_t, obj_t );
extern long string_length___r4_strings_6_7_227( obj_t );
extern obj_t _string_fill____r4_strings_6_7_203( obj_t, obj_t, obj_t );
extern obj_t _string___r4_strings_6_7( obj_t, obj_t );
static obj_t loop_local1145( obj_t );
extern obj_t blit_string____r4_strings_6_7_126( obj_t, obj_t, obj_t, obj_t, obj_t );
extern obj_t _string______r4_strings_6_7_18( obj_t, obj_t, obj_t );
extern obj_t make_string( long, unsigned char );
extern obj_t _string_ref_ur___r4_strings_6_7_226( obj_t, obj_t, obj_t );
extern obj_t string_downcase____r4_strings_6_7_100( obj_t );
extern bool_t string_ge( obj_t, obj_t );
extern obj_t string__list___r4_strings_6_7_22( obj_t );
extern obj_t _make_string___r4_strings_6_7_239( obj_t, obj_t, obj_t );
extern obj_t _string_downcase___r4_strings_6_7_212( obj_t, obj_t );
DEFINE_STRING( string1146___r4_strings_6_7, aux1497, "blit-string", 11 );
extern obj_t blit_string( obj_t, obj_t, obj_t, obj_t, obj_t );
extern obj_t substring_ur___r4_strings_6_7_255( obj_t, long, long );
extern bool_t string____r4_strings_6_7_141( obj_t );
extern bool_t string______r4_strings_6_7_155( obj_t, obj_t );
DEFINE_STRING( string1151___r4_strings_6_7, aux1499, "string-set!", 11 );
extern bool_t string_____r4_strings_6_7_230( obj_t, obj_t );
extern obj_t _string_downcase____r4_strings_6_7_39( obj_t, obj_t );
extern obj_t string_upcase___r4_strings_6_7_224( obj_t );
extern bool_t string_ci______r4_strings_6_7_112( obj_t, obj_t );
extern bool_t string_ci______r4_strings_6_7_131( obj_t, obj_t );
extern unsigned char string_ref___r4_strings_6_7_35( obj_t, long );
DEFINE_STRING( string1150___r4_strings_6_7, aux1500, "Illegal index", 13 );
extern obj_t _substring___r4_strings_6_7( obj_t, obj_t, obj_t, obj_t );
extern obj_t _blit_string____r4_strings_6_7_7( obj_t, obj_t, obj_t, obj_t, obj_t, obj_t );
extern obj_t string_set____r4_strings_6_7_56( obj_t, long, unsigned char );
extern bool_t string_le( obj_t, obj_t );
extern obj_t _string_ref___r4_strings_6_7_61( obj_t, obj_t, obj_t );
extern obj_t _string_____r4_strings_6_7_63( obj_t, obj_t, obj_t );
extern long list_length( obj_t );
extern obj_t string_upcase____r4_strings_6_7_99( obj_t );
DEFINE_STRING( string1147___r4_strings_6_7, aux1501, "Index and length out of range", 29 );
extern bool_t string_cile( obj_t, obj_t );
extern bool_t string_gt( obj_t, obj_t );
extern bool_t string______r4_strings_6_7_208( obj_t, obj_t );
extern obj_t _string_ci_____r4_strings_6_7_240( obj_t, obj_t, obj_t );
extern obj_t string_downcase___r4_strings_6_7_41( obj_t );
extern obj_t string_fill____r4_strings_6_7_145( obj_t, unsigned char );
extern obj_t _string____r4_strings_6_7_133( obj_t, obj_t );
extern obj_t string_append___r4_strings_6_7_48( obj_t );
extern bool_t string_cilt( obj_t, obj_t );
extern obj_t _string_ci______r4_strings_6_7_12( obj_t, obj_t, obj_t );
extern obj_t string_append( obj_t, obj_t );
extern obj_t string_for_read___r4_strings_6_7_226( obj_t );
static obj_t initialize_constants____r4_strings_6_7_47();
extern obj_t string_set_ur____r4_strings_6_7_47( obj_t, long, unsigned char );
extern bool_t string_ci_____r4_strings_6_7_52( obj_t, obj_t );
extern obj_t string___r4_strings_6_7( obj_t );
extern obj_t c_substring( obj_t, long, long );
static obj_t initialize_imported_modules____r4_strings_6_7_237();
extern obj_t substring___r4_strings_6_7( obj_t, long, long );
DEFINE_STRING( string1149___r4_strings_6_7, aux1502, "substring", 9 );
extern obj_t _blit_string_ur____r4_strings_6_7_243( obj_t, obj_t, obj_t, obj_t, obj_t, obj_t );
extern bool_t string_ci_____r4_strings_6_7_201( obj_t, obj_t );
extern obj_t _string_copy___r4_strings_6_7_217( obj_t, obj_t );
extern obj_t _string_length___r4_strings_6_7_156( obj_t, obj_t );
extern bool_t string_ci_____r4_strings_6_7_106( obj_t, obj_t );
static obj_t require_initialization____r4_strings_6_7_5 = BUNSPEC;
extern obj_t _string_upcase____r4_strings_6_7_92( obj_t, obj_t );
extern obj_t string_copy___r4_strings_6_7_30( obj_t );

DEFINE_EXPORT_PROCEDURE( list__string_env___r4_strings_6_7_156, aux1504, _list__string___r4_strings_6_7_204, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( make_string_env___r4_strings_6_7_250, aux1505, va_generic_entry, _make_string___r4_strings_6_7_239, -2 );
DEFINE_EXPORT_PROCEDURE( blit_string_ur__env___r4_strings_6_7_163, aux1506, _blit_string_ur____r4_strings_6_7_243, 0L, 5 );
DEFINE_EXPORT_PROCEDURE( string_downcase__env___r4_strings_6_7_138, aux1507, _string_downcase____r4_strings_6_7_39, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( string__env___r4_strings_6_7_186, aux1508, _string____r4_strings_6_7_133, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( string_ci___env___r4_strings_6_7_182, aux1509, _string_ci_____r4_strings_6_7_11, 0L, 2 );
DEFINE_EXPORT_PROCEDURE( substring_ur_env___r4_strings_6_7_191, aux1515, _substring_ur___r4_strings_6_7_194, 0L, 3 );
DEFINE_EXPORT_PROCEDURE( blit_string__env___r4_strings_6_7_71, aux1516, _blit_string____r4_strings_6_7_7, 0L, 5 );
DEFINE_EXPORT_PROCEDURE( string___env___r4_strings_6_7_192, aux1517, _string_____r4_strings_6_7_45, 0L, 2 );
DEFINE_EXPORT_PROCEDURE( string___env___r4_strings_6_7_175, aux1518, _string_____r4_strings_6_7_63, 0L, 2 );
DEFINE_EXPORT_PROCEDURE( string__list_env___r4_strings_6_7_23, aux1519, _string__list___r4_strings_6_7_217, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( string_ref_ur_env___r4_strings_6_7_129, aux1522, _string_ref_ur___r4_strings_6_7_226, 0L, 2 );
DEFINE_EXPORT_PROCEDURE( string_ci____env___r4_strings_6_7_116, aux1523, _string_ci______r4_strings_6_7_12, 0L, 2 );
DEFINE_EXPORT_PROCEDURE( string_set_ur__env___r4_strings_6_7_142, aux1525, _string_set_ur____r4_strings_6_7_76, 0L, 3 );
DEFINE_EXPORT_PROCEDURE( string_copy_env___r4_strings_6_7_159, aux1527, _string_copy___r4_strings_6_7_217, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( string____env___r4_strings_6_7_255, aux1529, _string______r4_strings_6_7_172, 0L, 2 );
DEFINE_EXPORT_PROCEDURE( string_ci___env___r4_strings_6_7_61, aux1532, _string_ci_____r4_strings_6_7_221, 0L, 2 );
DEFINE_EXPORT_PROCEDURE( string_env___r4_strings_6_7_215, aux1533, va_generic_entry, _string___r4_strings_6_7, -1 );
DEFINE_EXPORT_PROCEDURE( substring_env___r4_strings_6_7_240, aux1534, _substring___r4_strings_6_7, 0L, 3 );
DEFINE_EXPORT_PROCEDURE( string_upcase__env___r4_strings_6_7_72, aux1535, _string_upcase____r4_strings_6_7_92, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( string_ref_env___r4_strings_6_7_110, aux1536, _string_ref___r4_strings_6_7_61, 0L, 2 );
DEFINE_EXPORT_PROCEDURE( string_set__env___r4_strings_6_7_24, aux1537, _string_set____r4_strings_6_7_22, 0L, 3 );
DEFINE_EXPORT_PROCEDURE( string_fill__env___r4_strings_6_7_172, aux1538, _string_fill____r4_strings_6_7_203, 0L, 2 );
DEFINE_EXPORT_PROCEDURE( string_upcase_env___r4_strings_6_7_94, aux1539, _string_upcase___r4_strings_6_7_209, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( string_ci___env___r4_strings_6_7_57, aux1541, _string_ci_____r4_strings_6_7_240, 0L, 2 );
DEFINE_EXPORT_PROCEDURE( string_downcase_env___r4_strings_6_7_227, aux1547, _string_downcase___r4_strings_6_7_212, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( string_length_env___r4_strings_6_7_54, aux1548, _string_length___r4_strings_6_7_156, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( string_for_read_env___r4_strings_6_7_34, aux1549, _string_for_read___r4_strings_6_7_166, 0L, 1 );
DEFINE_EXPORT_PROCEDURE( string_append_env___r4_strings_6_7_44, aux1550, va_generic_entry, _string_append___r4_strings_6_7_245, -1 );
DEFINE_EXPORT_PROCEDURE( string____env___r4_strings_6_7_156, aux1551, _string______r4_strings_6_7_18, 0L, 2 );
DEFINE_EXPORT_PROCEDURE( string_ci____env___r4_strings_6_7_2, aux1552, _string_ci______r4_strings_6_7_43, 0L, 2 );
DEFINE_EXPORT_PROCEDURE( string___env___r4_strings_6_7_27, aux1554, _string_____r4_strings_6_7_236, 0L, 2 );

obj_t initialization___r4_strings_6_7()
{if(CBOOL(require_initialization____r4_strings_6_7_5)){require_initialization____r4_strings_6_7_5 = BFALSE;
initialize_imported_modules____r4_strings_6_7_237();
tvectors_declarations____r4_strings_6_7_61();
initialize_constants____r4_strings_6_7_47();
require_initialization____r4_strings_6_7_5 = BFALSE;
return BUNSPEC;
} else {return BUNSPEC;
}}

obj_t initialize_imported_modules____r4_strings_6_7_237()
{initialization___error();
return BUNSPEC;
}

obj_t initialize_constants____r4_strings_6_7_47()
{return BUNSPEC;
}

obj_t tvectors_declarations____r4_strings_6_7_61()
{return BUNSPEC;
}

bool_t string____r4_strings_6_7_141(obj_t obj_567)
{return STRINGP(obj_567);
}

obj_t _string____r4_strings_6_7_133(obj_t env_957, obj_t obj_958)
{return BBOOL(string____r4_strings_6_7_141(obj_958));
}

obj_t make_string___r4_strings_6_7_49(int k_568, obj_t char_569)
{if(NULLP(char_569)){return make_string((long)(k_568), ((unsigned char)' '));
} else {obj_t aux1084_570;
aux1084_570 = CAR(char_569);
return make_string((long)(k_568), (unsigned char)CCHAR(aux1084_570));
}}

obj_t _make_string___r4_strings_6_7_239(obj_t env_959, obj_t k_960, obj_t char_961)
{return make_string___r4_strings_6_7_49(CINT(k_960), char_961);
}

obj_t string___r4_strings_6_7(obj_t chars_571)
{return list__string___r4_strings_6_7_155(chars_571);
}

obj_t _string___r4_strings_6_7(obj_t env_962, obj_t chars_963)
{return string___r4_strings_6_7(chars_963);
}

long string_length___r4_strings_6_7_227(obj_t string_572)
{return STRING_LENGTH(string_572);
}

obj_t _string_length___r4_strings_6_7_156(obj_t env_964, obj_t string_965)
{return BINT(string_length___r4_strings_6_7_227(string_965));
}

unsigned char string_ref___r4_strings_6_7_35(obj_t string_573, long k_574)
{if(BOUND_CHECK(k_574, STRING_LENGTH(string_573))){return STRING_REF(string_573, k_574);
} else {FAILURE(string1153___r4_strings_6_7,string1152___r4_strings_6_7,BINT(k_574));}}

obj_t _string_ref___r4_strings_6_7_61(obj_t env_966, obj_t string_967, obj_t k_968)
{return BCHAR(string_ref___r4_strings_6_7_35(string_967, (long)CINT(k_968)));
}

obj_t string_set____r4_strings_6_7_56(obj_t string_576, long k_577, unsigned char char_578)
{if(BOUND_CHECK(k_577, STRING_LENGTH(string_576))){return STRING_SET(string_576, k_577, char_578);
} else {FAILURE(string1151___r4_strings_6_7,string1152___r4_strings_6_7,BINT(k_577));}}

obj_t _string_set____r4_strings_6_7_22(obj_t env_969, obj_t string_970, obj_t k_971, obj_t char_972)
{return string_set____r4_strings_6_7_56(string_970, (long)CINT(k_971), (unsigned char)CCHAR(char_972));
}

unsigned char string_ref_ur___r4_strings_6_7_193(obj_t string_580, long k_581)
{return STRING_REF(string_580, k_581);
}

obj_t _string_ref_ur___r4_strings_6_7_226(obj_t env_973, obj_t string_974, obj_t k_975)
{return BCHAR(string_ref_ur___r4_strings_6_7_193(string_974, (long)CINT(k_975)));
}

obj_t string_set_ur____r4_strings_6_7_47(obj_t string_582, long k_583, unsigned char char_584)
{return STRING_SET(string_582, k_583, char_584);
}

obj_t _string_set_ur____r4_strings_6_7_76(obj_t env_976, obj_t string_977, obj_t k_978, obj_t char_979)
{return string_set_ur____r4_strings_6_7_47(string_977, (long)CINT(k_978), (unsigned char)CCHAR(char_979));
}

bool_t string_____r4_strings_6_7_232(obj_t string1_585, obj_t string2_586)
{return bigloo_strcmp(string1_585, string2_586);
}

obj_t _string_____r4_strings_6_7_63(obj_t env_980, obj_t string1_981, obj_t string2_982)
{return BBOOL(string_____r4_strings_6_7_232(string1_981, string2_982));
}

bool_t string_ci_____r4_strings_6_7_52(obj_t string1_587, obj_t string2_588)
{return strcicmp(string1_587, string2_588);
}

obj_t _string_ci_____r4_strings_6_7_221(obj_t env_983, obj_t string1_984, obj_t string2_985)
{return BBOOL(string_ci_____r4_strings_6_7_52(string1_984, string2_985));
}

bool_t string_____r4_strings_6_7_230(obj_t string1_589, obj_t string2_590)
{return string_lt(string1_589, string2_590);
}

obj_t _string_____r4_strings_6_7_45(obj_t env_986, obj_t string1_987, obj_t string2_988)
{return BBOOL(string_____r4_strings_6_7_230(string1_987, string2_988));
}

bool_t string_____r4_strings_6_7_167(obj_t string1_591, obj_t string2_592)
{return string_gt(string1_591, string2_592);
}

obj_t _string_____r4_strings_6_7_236(obj_t env_989, obj_t string1_990, obj_t string2_991)
{return BBOOL(string_____r4_strings_6_7_167(string1_990, string2_991));
}

bool_t string______r4_strings_6_7_208(obj_t string1_593, obj_t string2_594)
{return string_le(string1_593, string2_594);
}

obj_t _string______r4_strings_6_7_172(obj_t env_992, obj_t string1_993, obj_t string2_994)
{return BBOOL(string______r4_strings_6_7_208(string1_993, string2_994));
}

bool_t string______r4_strings_6_7_155(obj_t string1_595, obj_t string2_596)
{return string_ge(string1_595, string2_596);
}

obj_t _string______r4_strings_6_7_18(obj_t env_995, obj_t string1_996, obj_t string2_997)
{return BBOOL(string______r4_strings_6_7_155(string1_996, string2_997));
}

bool_t string_ci_____r4_strings_6_7_201(obj_t string1_597, obj_t string2_598)
{return string_cilt(string1_597, string2_598);
}

obj_t _string_ci_____r4_strings_6_7_11(obj_t env_998, obj_t string1_999, obj_t string2_1000)
{return BBOOL(string_ci_____r4_strings_6_7_201(string1_999, string2_1000));
}

bool_t string_ci_____r4_strings_6_7_106(obj_t string1_599, obj_t string2_600)
{return string_cigt(string1_599, string2_600);
}

obj_t _string_ci_____r4_strings_6_7_240(obj_t env_1001, obj_t string1_1002, obj_t string2_1003)
{return BBOOL(string_ci_____r4_strings_6_7_106(string1_1002, string2_1003));
}

bool_t string_ci______r4_strings_6_7_112(obj_t string1_601, obj_t string2_602)
{return string_cile(string1_601, string2_602);
}

obj_t _string_ci______r4_strings_6_7_43(obj_t env_1004, obj_t string1_1005, obj_t string2_1006)
{return BBOOL(string_ci______r4_strings_6_7_112(string1_1005, string2_1006));
}

bool_t string_ci______r4_strings_6_7_131(obj_t string1_603, obj_t string2_604)
{return string_cige(string1_603, string2_604);
}

obj_t _string_ci______r4_strings_6_7_12(obj_t env_1007, obj_t string1_1008, obj_t string2_1009)
{return BBOOL(string_ci______r4_strings_6_7_131(string1_1008, string2_1009));
}

obj_t substring___r4_strings_6_7(obj_t string_605, long start_606, long end_607)
{{bool_t test1365_1196;
if((end_607>=start_606)){if(BOUND_CHECK(start_606, (STRING_LENGTH(string_605)+1)))test1365_1196 = BOUND_CHECK(end_607, (STRING_LENGTH(string_605)+1));
 else test1365_1196 = ((bool_t)0);
} else test1365_1196 = ((bool_t)0);
if(test1365_1196){return c_substring(string_605, start_606, end_607);
} else {obj_t aux1091_612;
aux1091_612 = MAKE_PAIR(BINT(start_606), BINT(end_607));
FAILURE(string1149___r4_strings_6_7,string1150___r4_strings_6_7,aux1091_612);}}}

obj_t _substring___r4_strings_6_7(obj_t env_1010, obj_t string_1011, obj_t start_1012, obj_t end_1013)
{return substring___r4_strings_6_7(string_1011, (long)CINT(start_1012), (long)CINT(end_1013));
}

obj_t substring_ur___r4_strings_6_7_255(obj_t string_613, long start_614, long end_615)
{return c_substring(string_613, start_614, end_615);
}

obj_t _substring_ur___r4_strings_6_7_194(obj_t env_1014, obj_t string_1015, obj_t start_1016, obj_t end_1017)
{return substring_ur___r4_strings_6_7_255(string_1015, (long)CINT(start_1016), (long)CINT(end_1017));
}

obj_t loop_local1145(obj_t list_618)
{{bool_t test1342_1181;
{obj_t aux1092_619;
aux1092_619 = CDR(list_618);
test1342_1181 = NULLP(aux1092_619);
}if(test1342_1181){return CAR(list_618);
} else {obj_t aux1093_620;
aux1093_620 = CAR(list_618);
{obj_t aux1094_621;
{obj_t aux1095_622;
aux1095_622 = CDR(list_618);
aux1094_621 = loop_local1145(aux1095_622);
}return string_append(aux1093_620, aux1094_621);
}}}}

obj_t string_append___r4_strings_6_7_48(obj_t list_616)
{if(NULLP(list_616)){return string1148___r4_strings_6_7;
} else {return loop_local1145(list_616);
}}

obj_t _string_append___r4_strings_6_7_245(obj_t env_1018, obj_t list_1019)
{return string_append___r4_strings_6_7_48(list_1019);
}

obj_t list__string___r4_strings_6_7_155(obj_t list_623)
{{long len_624;
len_624 = list_length(list_623);
{obj_t string_625;
{int k_864;
obj_t char_865;
k_864 = (int)(len_624);
char_865 = BNIL;
if(NULLP(char_865)){string_625 = make_string((long)(k_864), ((unsigned char)' '));
} else {obj_t aux1084_866;
aux1084_866 = CAR(char_865);
string_625 = make_string((long)(k_864), (unsigned char)CCHAR(aux1084_866));
}}{{long i_627;
obj_t l_628;
i_627 = 0;
l_628 = list_623;
loop_626:
if((i_627==len_624)){return string_625;
} else {{obj_t aux1096_629;
aux1096_629 = CAR(l_628);
{unsigned char char_873;
char_873 = (unsigned char)CCHAR(aux1096_629);
STRING_SET(string_625, i_627, char_873);
}}{long aux1097_630;
aux1097_630 = (i_627+1);
{obj_t aux1098_631;
aux1098_631 = CDR(l_628);
{obj_t l_1176;
long i_1175;
i_1175 = aux1097_630;
l_1176 = aux1098_631;
l_628 = l_1176;
i_627 = i_1175;
goto loop_626;
}}}}}}}}}

obj_t _list__string___r4_strings_6_7_204(obj_t env_1020, obj_t list_1021)
{return list__string___r4_strings_6_7_155(list_1021);
}

obj_t string__list___r4_strings_6_7_22(obj_t string_632)
{{long len_633;
len_633 = STRING_LENGTH(string_632);
{long i_635;
obj_t acc_636;
i_635 = 0;
acc_636 = BNIL;
loop_634:
if((i_635==len_633)){return reverse____r4_pairs_and_lists_6_3_107(acc_636);
} else {long aux1103_637;
aux1103_637 = (i_635+1);
{obj_t aux1104_638;
{unsigned char aux1105_639;
aux1105_639 = STRING_REF(string_632, i_635);
aux1104_638 = MAKE_PAIR(BCHAR(aux1105_639), acc_636);
}{obj_t acc_1156;
long i_1155;
i_1155 = aux1103_637;
acc_1156 = aux1104_638;
acc_636 = acc_1156;
i_635 = i_1155;
goto loop_634;
}}}}}}

obj_t _string__list___r4_strings_6_7_217(obj_t env_1022, obj_t string_1023)
{return string__list___r4_strings_6_7_22(string_1023);
}

obj_t string_copy___r4_strings_6_7_30(obj_t string_640)
{return string_to_bstring(BSTRING_TO_STRING(string_640));
}

obj_t _string_copy___r4_strings_6_7_217(obj_t env_1024, obj_t string_1025)
{return string_copy___r4_strings_6_7_30(string_1025);
}

obj_t string_fill____r4_strings_6_7_145(obj_t string_641, unsigned char char_642)
{{long len_643;
len_643 = STRING_LENGTH(string_641);
{long i_645;
i_645 = 0;
loop_644:
if((i_645==len_643)){return string_641;
} else {STRING_SET(string_641, i_645, char_642);
{long aux1106_646;
aux1106_646 = (i_645+1);
{long i_1142;
i_1142 = aux1106_646;
i_645 = i_1142;
goto loop_644;
}}}}}}

obj_t _string_fill____r4_strings_6_7_203(obj_t env_1026, obj_t string_1027, obj_t char_1028)
{return string_fill____r4_strings_6_7_145(string_1027, (unsigned char)CCHAR(char_1028));
}

obj_t string_upcase___r4_strings_6_7_224(obj_t string_647)
{{long len_648;
len_648 = STRING_LENGTH(string_647);
{obj_t res_649;
{int k_893;
obj_t char_894;
k_893 = (int)(len_648);
char_894 = BNIL;
if(NULLP(char_894)){res_649 = make_string((long)(k_893), ((unsigned char)' '));
} else {obj_t aux1084_895;
aux1084_895 = CAR(char_894);
res_649 = make_string((long)(k_893), (unsigned char)CCHAR(aux1084_895));
}}{{long i_651;
i_651 = 0;
loop_650:
if((i_651==len_648)){return res_649;
} else {{unsigned char aux1110_652;
{unsigned char aux1111_653;
aux1111_653 = STRING_REF(string_647, i_651);
aux1110_652 = toupper(aux1111_653);
}STRING_SET(res_649, i_651, aux1110_652);
}{long aux1112_654;
aux1112_654 = (i_651+1);
{long i_1134;
i_1134 = aux1112_654;
i_651 = i_1134;
goto loop_650;
}}}}}}}}

obj_t _string_upcase___r4_strings_6_7_209(obj_t env_1029, obj_t string_1030)
{return string_upcase___r4_strings_6_7_224(string_1030);
}

obj_t string_downcase___r4_strings_6_7_41(obj_t string_655)
{{long len_656;
len_656 = STRING_LENGTH(string_655);
{obj_t res_657;
{int k_908;
obj_t char_909;
k_908 = (int)(len_656);
char_909 = BNIL;
if(NULLP(char_909)){res_657 = make_string((long)(k_908), ((unsigned char)' '));
} else {obj_t aux1084_910;
aux1084_910 = CAR(char_909);
res_657 = make_string((long)(k_908), (unsigned char)CCHAR(aux1084_910));
}}{{long i_659;
i_659 = 0;
loop_658:
if((i_659==len_656)){return res_657;
} else {{unsigned char aux1113_660;
{unsigned char aux1115_661;
aux1115_661 = STRING_REF(string_655, i_659);
aux1113_660 = tolower(aux1115_661);
}STRING_SET(res_657, i_659, aux1113_660);
}{long aux1116_662;
aux1116_662 = (i_659+1);
{long i_1116;
i_1116 = aux1116_662;
i_659 = i_1116;
goto loop_658;
}}}}}}}}

obj_t _string_downcase___r4_strings_6_7_212(obj_t env_1031, obj_t string_1032)
{return string_downcase___r4_strings_6_7_41(string_1032);
}

obj_t string_upcase____r4_strings_6_7_99(obj_t string_663)
{{long len_664;
len_664 = STRING_LENGTH(string_663);
{{long i_667;
i_667 = 0;
loop_666:
if((i_667==len_664)){return string_663;
} else {{unsigned char aux1117_668;
{unsigned char aux1119_669;
aux1119_669 = STRING_REF(string_663, i_667);
aux1117_668 = toupper(aux1119_669);
}STRING_SET(string_663, i_667, aux1117_668);
}{long aux1120_670;
aux1120_670 = (i_667+1);
{long i_1098;
i_1098 = aux1120_670;
i_667 = i_1098;
goto loop_666;
}}}}}}}

obj_t _string_upcase____r4_strings_6_7_92(obj_t env_1033, obj_t string_1034)
{return string_upcase____r4_strings_6_7_99(string_1034);
}

obj_t string_downcase____r4_strings_6_7_100(obj_t string_671)
{{long len_672;
len_672 = STRING_LENGTH(string_671);
{{long i_675;
i_675 = 0;
loop_674:
if((i_675==len_672)){return string_671;
} else {{unsigned char aux1121_676;
{unsigned char aux1124_677;
aux1124_677 = STRING_REF(string_671, i_675);
aux1121_676 = tolower(aux1124_677);
}STRING_SET(string_671, i_675, aux1121_676);
}{long aux1125_678;
aux1125_678 = (i_675+1);
{long i_1089;
i_1089 = aux1125_678;
i_675 = i_1089;
goto loop_674;
}}}}}}}

obj_t _string_downcase____r4_strings_6_7_39(obj_t env_1035, obj_t string_1036)
{return string_downcase____r4_strings_6_7_100(string_1036);
}

obj_t string_for_read___r4_strings_6_7_226(obj_t string_679)
{return string_for_read(string_679);
}

obj_t _string_for_read___r4_strings_6_7_166(obj_t env_1037, obj_t string_1038)
{return string_for_read___r4_strings_6_7_226(string_1038);
}

obj_t blit_string_ur____r4_strings_6_7_25(obj_t s1_680, obj_t o1_681, obj_t s2_682, obj_t o2_683, obj_t l_684)
{return blit_string(s1_680, o1_681, s2_682, o2_683, l_684);
}

obj_t _blit_string_ur____r4_strings_6_7_243(obj_t env_1039, obj_t s1_1040, obj_t o1_1041, obj_t s2_1042, obj_t o2_1043, obj_t l_1044)
{return blit_string_ur____r4_strings_6_7_25(s1_1040, o1_1041, s2_1042, o2_1043, l_1044);
}

obj_t blit_string____r4_strings_6_7_126(obj_t s1_685, obj_t o1_686, obj_t s2_687, obj_t o2_688, obj_t l_689)
{{bool_t test1155_1052;
if(BOUND_CHECK(((long)CINT(l_689)+(long)CINT(o1_686)), (STRING_LENGTH(s1_685)+1)))test1155_1052 = BOUND_CHECK(((long)CINT(l_689)+(long)CINT(o2_688)), (STRING_LENGTH(s2_687)+1));
 else test1155_1052 = ((bool_t)0);
if(test1155_1052){return blit_string(s1_685, o1_686, s2_687, o2_688, l_689);
} else {obj_t aux1137_696;
{long aux1138_697;
aux1138_697 = STRING_LENGTH(s1_685);
{long aux1142_698;
aux1142_698 = STRING_LENGTH(s2_687);
{obj_t l_956;
l_956 = MAKE_PAIR(BINT(aux1138_697), MAKE_PAIR(o1_686, MAKE_PAIR(BINT(aux1142_698), MAKE_PAIR(o2_688, MAKE_PAIR(l_689, BNIL)))));
aux1137_696 = l_956;
}}}FAILURE(string1146___r4_strings_6_7,string1147___r4_strings_6_7,aux1137_696);}}}

obj_t _blit_string____r4_strings_6_7_7(obj_t env_1045, obj_t s1_1046, obj_t o1_1047, obj_t s2_1048, obj_t o2_1049, obj_t l_1050)
{return blit_string____r4_strings_6_7_126(s1_1046, o1_1047, s2_1048, o2_1049, l_1050);
}

