;*---------------------------------------------------------------------*/
;*    Copyright (c) 1996 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*---------------------------------------------------------------------*/
;*    serrano/prgm/project/bigloo/recette/tail.scm ...                 */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Tue Sep  1 17:44:12 1992                          */
;*    Last change :  Thu Jun  9 09:10:25 1994 (serrano)                */
;*                                                                     */
;*    On test la facon de gerer les appels recursifs terminaux.        */
;*---------------------------------------------------------------------*/

;*---------------------------------------------------------------------*/
;*    le module                                                        */
;*---------------------------------------------------------------------*/
(module tail
   (import  (main "main.scm"))
   (include "test.sch")
   (export  (test-tail)))


;*---------------------------------------------------------------------*/
;*    test1 ...                                                        */
;*---------------------------------------------------------------------*/
(define (test1)
   (letrec ((loop (lambda (x y)
		     (if (eq? x 0)
			 y
			 (loop (- x 1) x)))))
      (loop 2 2)))

;*---------------------------------------------------------------------*/
;*    test2 ...                                                        */
;*---------------------------------------------------------------------*/
(define (test2 x)
   (let* ((a   hux)
	  (fun (lambda (c) c)))
      (a (if x (fun 1) (fun 2)))))

(define (hux x)
   x)

;*---------------------------------------------------------------------*/
;*    test-tail ...                                                    */
;*---------------------------------------------------------------------*/
(define (test-tail)
   (test-module "tail" "tail.scm" #f)
   (test "tail" (test1) 1)
   (test "tail" (test2 #f) 2))

