;*---------------------------------------------------------------------*/
;*    Copyright (c) 1996 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    serrano/prgm/project/bigloo/recette/hash.scm ...                 */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Sat Nov 26 11:50:50 1994                          */
;*    Last change :  Sat Nov 26 12:17:30 1994 (serrano)                */
;*    -------------------------------------------------------------    */
;*    On test les tables de hash                                       */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module hash
   (import  (main "main.scm"))
   (include "test.sch")
   (export  (test-hash)))

;*---------------------------------------------------------------------*/
;*    test1 ...                                                        */
;*---------------------------------------------------------------------*/
(define (test1)
   (let ((table (make-hash-table 256 string->0..255 car string=?)))
      ;; on remplis la table
      (let loop ((i 1024))
	 (if (=fx i 0)
	     (and (eq? (cdr (get-hash "object834" table)) 834)
		  (eq? (cdr (get-hash "object835" table)) 835)
		  (eq? (cdr (get-hash "object836" table)) 836)
		  (eq? (cdr (get-hash "object837" table)) 837)
		  (not (eq? (cdr (get-hash "object134" table)) 834))
		  (not (eq? (cdr (get-hash "object135" table)) 835))
		  (not (eq? (cdr (get-hash "object136" table)) 836))
		  (not (eq? (cdr (get-hash "object137" table)) 837)))
	     (begin
		(put-hash! (cons (string-append "object"
						(number->string i))
				 i)
			   table)
		(loop (-fx i 1)))))))
      
;*---------------------------------------------------------------------*/
;*    test2 ...                                                        */
;*---------------------------------------------------------------------*/
(define (test2)
   (let ((table (make-hash-table 4096 (lambda (o)
					 (string->0..2^x-1 o 12))
				 car string=? 256)))
      ;; on remplis la table
      (let loop ((i 10024))
	 (if (=fx i 0)
	     (and (eq? (cdr (get-hash "object5834" table)) 5834)
		  (eq? (cdr (get-hash "object5835" table)) 5835)
		  (eq? (cdr (get-hash "object5836" table)) 5836)
		  (eq? (cdr (get-hash "object5837" table)) 5837)
		  (not (eq? (cdr (get-hash "object9134" table)) 5834))
		  (not (eq? (cdr (get-hash "object9135" table)) 5835))
		  (not (eq? (cdr (get-hash "object9136" table)) 5836))
		  (not (eq? (cdr (get-hash "object9137" table)) 5837)))
	     (begin
		(put-hash! (cons (string-append "object"
						(number->string i))
				 i)
			   table)
		(loop (-fx i 1)))))))

;*---------------------------------------------------------------------*/
;*    test3 ...                                                        */
;*---------------------------------------------------------------------*/
(define (test3)
   (let ((table (make-hash-table 256 obj->0..255 (lambda (x) x) eq?)))
      (put-hash! 123 table)
      (if (eq? (get-hash 123 table) 123)
	  (begin
	     (rem-obj-hash! 123 table)
	     (if (not (get-hash 123 table))
		 #t
		 #f))
	  #f)))
      
;*---------------------------------------------------------------------*/
;*    test-hash ...                                                    */
;*---------------------------------------------------------------------*/
(define (test-hash)
   (test-module "hash" "hash.scm" #t)
   (test "hash" (test1) #t)
   (test "hash" (test2) #t)
   (test "hash" (test3) #t))

