;*---------------------------------------------------------------------*/
;*    Copyright (c) 1996 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*---------------------------------------------------------------------*/
;*    serrano/prgm/project/bigloo/recette/flonum.scm                   */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Thu Nov 26 11:59:37 1992                          */
;*    Last change :  Thu Mar 23 16:58:59 1995 (serrano)                */
;*                                                                     */
;*    On test un peu les flotants (il le faut bien).                   */
;*---------------------------------------------------------------------*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module flonum
   (import  (main "main.scm"))
   (include "test.sch")
   (export  (test-flonum)))

;*---------------------------------------------------------------------*/
;*    fact ...                                                         */
;*---------------------------------------------------------------------*/
(define (fact x)
   (if (< x 2)
       1
       (* (fact (- x 1)) x)))

;*---------------------------------------------------------------------*/
;*    test-flonum ...                                                  */
;*---------------------------------------------------------------------*/
(define (test-flonum)
   (test-module "flonum" "flonum.scm" #f)
   (test "flonum"   3.141592 3.141592)
   (test "flonum"   (/ (inexact->exact (cos 0)) 2) 0.5)
   (test "flonum"   (/ 1 2) 0.5)
   (test "flonum"   23.56 (+fl 23.0 0.56))
   (test "cos"      (sin 0) 0.0)
   (test "cos"      (acos (cos 2.0)) 2.0)
   (test "round"    (round 4.3) 4.0)
   (test "exact"    (exact? 5) #t)
   (test "exact"    (exact? 5.0) #f)
   (test "inexact"  (inexact? 5) #f)
   (test "inexact"  (inexact? 5.0) #t)
   (test "exact"    (inexact->exact 4.3) 4)
   (test "fact"     (fact 5) 120)
   (test "fact"     (fact 5.0) 120.0)
   (test "floor"    (floor -4.3) -5.0)
   (test "ceiling"  (ceiling -4.3) -4.0)
   (test "truncate" (truncate -4.3) -4.0)
   (test "round"    (round -4.3) -4.0)
   (test "floor"    (floor 3.5) 3.0)
   (test "ceiling"  (ceiling 3.5) 4.0)
   (test "truncate" (truncate 3.5) 3.0)
   (test "round"    (round 3.5) 4.0)
   (test "atan"     (let ((r (atan 1.0 1.0))) (> r 0)) #t))

