;*---------------------------------------------------------------------*/
;*    Copyright (c) 1996 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    serrano/prgm/project/bigloo/work/new-runtime.scm                 */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Sat Jul  8 09:13:09 1995                          */
;*    Last change :  Fri Aug 11 08:43:03 1995 (serrano)                */
;*    -------------------------------------------------------------    */
;*    An example of foreign function interface.                        */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module tools_runtime
   
   (foreign (include "sys/time.h")
            (include "sys/resource.h")
            (macro int RUSAGE_SELF "RUSAGE_SELF")
            (type timeval  (struct (long tv-sec "tv_sec")
                                   (long tv-usec "tv_usec"))
                  "struct timeval")
            (type timezone (struct (int  tz-minuteswest "tz_minuteswest")
                                   (int  tz-dsttime "tz_dsttime"))
                  "struct timezone")
            (type rusage   (struct (timeval ru-utime "ru_utime")
                                   (timeval ru-stime "ru_stime")
                                   (int     ru-maxrss "ru_maxrss")
                                   (int     ru-ixrss "ru_ixrss")
                                   (int     ru-idrss "ru_idrss")
                                   (int     ru-isrss "ru_isrss")
                                   (int     ru_minflt "ru_minflt")
                                   (int     ru_majflt "ru_majflt")
                                   (int     ru_nswap "ru_nswap")
                                   (int     ru_inblock "ru_inblock")
                                   (int     ru_oublock "ru_oublock")
                                   (int     ru_msgsnd "ru_msgsnd")
                                   (int     ru_msgrcv "ru_msgrcv")
                                   (int     ru_nsignals "ru_nsignals")
                                   (int     ru_nvcsw "ru_nvcsw")
                                   (int     ru_nivcsw "ru_nivcsw"))
                  "struct rusage")
            (int getrusage (int rusage*) "getrusage"))

   (export  (runtime::pair ::procedure)))

;*---------------------------------------------------------------------*/
;*    runtime ...                                                      */
;*---------------------------------------------------------------------*/
(define (runtime thunk)
   (let ((rusage (make-rusage*)))
      (let* ((i     (getrusage RUSAGE_SELF rusage))
             (tu    (rusage*-ru-utime rusage))
             (ts    (rusage*-ru-stime rusage))
             (usec  (timeval*-tv-sec tu))
             (umsec (timeval*-tv-usec tu))
             (ssec  (timeval*-tv-sec ts))
             (smsec (timeval*-tv-usec ts)))
         (let ((val (thunk)))
            (let ((i  (getrusage RUSAGE_SELF rusage))
                  (tu (rusage*-ru-utime rusage))
                  (ts (rusage*-ru-stime rusage)))
               (cons val
		     (cons (+ (- (timeval*-tv-sec tu) usec)
			      (/ (- (timeval*-tv-usec tu) umsec)
				 1000000))
			   (+ (- (timeval*-tv-sec ts) ssec)
			      (/ (- (timeval*-tv-usec ts) smsec)
				 1000000)))))))))


(display "?* ")
(let loop ((exp (read)))
   (if (eof-object? exp)
       'done
       (let ((t (runtime (lambda () (eval exp)))))
	  (print (car t) "  [" (car (cdr t)) " user + " (cdr (cdr t)) " sys]")
	  (display "?* ")
	  (loop (read)))))
