;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.8/Type/type.sch            */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Tue Dec 27 16:51:04 1994                          */
;*    Last change :  Wed Jan 24 17:01:45 1996 (serrano)                */
;*    -------------------------------------------------------------    */
;*    Type structure                                                   */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    the type structure                                               */
;*---------------------------------------------------------------------*/
(define-struct type
   id            ;; symbol   : the type identifier
   name          ;; string   : the type name
   su-name       ;; string   : the type structure user name (for aliasing)
   class         ;; symbol   : the type class
   magic?        ;; boolean  : is this type a magic type (see coerce_convert) ?
   mutable?      ;; boolean  : is the type mutable ?
   exp           ;; s-exp    : the expression defining the type
   btype         ;; type     : an corresponding Bigloo type
   pointed-to-by ;; type     : a pointer to self type
   point-to      ;; type     : a pointed type
   coerce-to     ;; coercer* : a coercion list
   coerce-from   ;; coercer* : a coercion list
   parents       ;; type*    : the type's parents
   info          ;; s-exp
   cfa-info      ;; s-exp    : a slot to allow cfa optimizations.
   tinfo         ;; s-exp    : a slot for tvectors and tstructures
   $             ;; bool     : is the name contains a `$'
   alias)        ;; type     : a type that self aliases

;*---------------------------------------------------------------------*/
;*    coercing                                                         */
;*    -------------------------------------------------------------    */
;*    `check-op' and `coerce-op' began to be symbol, then, when        */
;*    the typing process start, they are mutated to fucntions.         */
;*---------------------------------------------------------------------*/
(define-struct coercer
   from          ;; type     : the from type
   to            ;; type     : the to type
   check-op      ;; symbol*  : the check operations on from type
   coerce-op)    ;; symbol*  : the conversion operations on from type
