;*---------------------------------------------------------------------*/
;*    Copyright (c) 1996 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.8/Tstruct/declare.scm      */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Tue Apr 18 15:21:32 1995                          */
;*    Last change :  Wed Oct  4 17:16:38 1995 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The declaration of `tstruct' types.                              */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module tstruct_declare
   (include "Type/type.sch"
	    "Tstruct/tstruct.sch")
   (import  type_env
	    type_cache
	    parse_type
	    cgen_ident
	    tools_error)
   (export  (declare-tstruct-type! <symbol> <slots> <exp>)
	    (get-tstruct-list)))

;*---------------------------------------------------------------------*/
;*    declare-tstruct-type! ...                                        */
;*---------------------------------------------------------------------*/
(define (declare-tstruct-type! tstruct-type-id slots exp)
   (let ((obj (find-type 'obj)))
      (if (not (type? obj))
	  (user-error "declare-tstruct-type!"
		      "Unable to find `obj' type"
		      exp)
	  (let ((t (declare-subtype! tstruct-type-id
				     (type-name obj)
				     (list 'obj)
				     'bigloo
				     exp))
		(i (make-tstruct-info)))
	     (tstruct-info-c-type-name-set!   i (scheme-id->c-id
						 (symbol->string
						  tstruct-type-id)))
	     (tstruct-info-slots-type-id-set! i (map car slots))
	     (tstruct-info-slots-name-set!    i (map cadr slots))
	     (type-tinfo-set! t i)
	     (add-tstruct! t)
	     ;; we have declared the type, we add the coercion
	     (parse-type (list
			  `(coerce ,tstruct-type-id tstruct () ())
			  `(coerce tstruct ,tstruct-type-id () ())))
	     t))))

;*---------------------------------------------------------------------*/
;*    *tstruct-list* ...                                               */
;*---------------------------------------------------------------------*/
(define *tstruct-list* '())

;*---------------------------------------------------------------------*/
;*    add-tstruct! ...                                                 */
;*---------------------------------------------------------------------*/
(define (add-tstruct! t)
   (set! *tstruct-list* (cons t *tstruct-list*)))

;*---------------------------------------------------------------------*/
;*    get-tstruct-list ...                                             */
;*---------------------------------------------------------------------*/
(define (get-tstruct-list)
   *tstruct-list*)
  
