;*---------------------------------------------------------------------*/
;*    Copyright (c) 1996 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.8/Tools/args.scm           */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Tue Dec 27 09:49:59 1994                          */
;*    Last change :  Fri Mar 22 11:35:37 1996 (serrano)                */
;*    -------------------------------------------------------------    */
;*    Tools function for managing parameters.                          */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module tools_args
   (export (arity exp)
	   (make-args-list args nil cons)
	   (args*->args-list exp)
	   (args-list->args* list arity)
	   (sound-arity? arity args)
	   (make-n-proto n)
	   (+-arity arity <integer>)
	   (map-on-args function args)
	   (map-on-args! function args)))

;*---------------------------------------------------------------------*/
;*    arity ...                                                        */
;*    exp --> int                                                      */
;*    -------------------------------------------------------------    */
;*    (lambda n ..)               --> -1                               */
;*    (lambda () ..)              -->  0                               */
;*    (lambda (a1 a2 .. an) ..)   -->  n                               */
;*    (lambda (a1 a2 .. . an) ..) --> -n                               */
;*---------------------------------------------------------------------*/
(define (arity exp)
   (cond
      ((null? exp)
       0)
      ((not (pair? (car exp)))
       -1)
      (else
       (let loop ((i    0)
                  (args exp))
          (cond
             ((null? args)
              i)
             ((pair? (car args))
              (loop (+fx i 1) (cdr args)))
             (else
              (negfx (+fx i 1))))))))

;*---------------------------------------------------------------------*/
;*    args*->args-list ...                                             */
;*    cons* --> list                                                   */
;*---------------------------------------------------------------------*/
(define (args*->args-list exp)
   (cond
      ((null? exp)
       '())
      ((not (pair? exp))
       (list exp))
      (else
       (cons (car exp)
             (args*->args-list (cdr exp))))))

;*---------------------------------------------------------------------*/
;*    args-list->args* ...                                             */
;*---------------------------------------------------------------------*/
(define (args-list->args* list arity)
   (cond
      ((>=fx arity 0)
       list)
      ((=fx arity -1)
       (car list))
      (else
       (let loop ((list  list)
		  (arity arity))
	  (if (=fx arity -1)
	      (car list)
	      (cons (car list) (loop (cdr list) (+fx arity 1))))))))
   
;*---------------------------------------------------------------------*/
;*    sound-arity? ...                                                 */
;*---------------------------------------------------------------------*/
(define (sound-arity? arity args)
   (let ((len (length args)))
      (if (>=fx arity 0)
	  (=fx arity len)
	  (<=fx (negfx arity) (+fx len 1)))))

;*---------------------------------------------------------------------*/
;*    make-args-list ...                                               */
;*---------------------------------------------------------------------*/
(define (make-args-list args nil cons)
   (let loop ((args args))
      (if (null? args)
	  nil
	  `(,cons ,(car args) ,(loop (cdr args))))))

;*---------------------------------------------------------------------*/
;*    make-n-proto ...                                                 */
;*    -------------------------------------------------------------    */
;*    On construit un prototype a partir de l'arite.                   */
;*---------------------------------------------------------------------*/
(define (make-n-proto n)
   (define (make-args-name n)
      (string->symbol (string-append "A" (integer->string n))))
   (define (make-va-proto n count)
      (if (=fx n -1)
	  (make-args-name count)
	  (cons (make-args-name count)
		(make-va-proto (+fx n 1) (+fx count 1)))))
   (define (make-fx-proto n count)
      (if (=fx n 0)
	  '()
	  (cons (make-args-name count)
		(make-fx-proto (-fx n 1) (+fx count 1)))))
   (if (<fx n 0)
       (make-va-proto n 0)
       (make-fx-proto n 0)))


;*---------------------------------------------------------------------*/
;*    +-arity ...                                                      */
;*---------------------------------------------------------------------*/
(define (+-arity arity add)
   (if (>fx arity 0)
       (+fx add arity)
       (-fx arity add)))

;*---------------------------------------------------------------------*/
;*    map-on-args ...                                                  */
;*---------------------------------------------------------------------*/
(define (map-on-args function args)
   (let loop ((args args))
      (cond
	 ((null? args)
	  '())
	 ((not (pair? args))
	  (function args))
	 (else
	  (cons (function (car args)) (loop (cdr args)))))))
	       
;*---------------------------------------------------------------------*/
;*    map-on-args! ...                                                 */
;*---------------------------------------------------------------------*/
(define (map-on-args! fun _proto)
   (cond
      ((null? _proto)
       '())
      ((not (pair? _proto))
       (fun _proto))
      (else
       (let loop ((proto _proto)
		  (hook  _proto))
	  (cond
	     ((null? proto)
	      _proto)
	     ((not (pair? proto))
	      (set-cdr! hook (fun proto))
	      _proto)
	     (else
	      (set-car! proto (fun (car proto)))
	      (loop (cdr proto)
		    proto)))))))
       
