;*---------------------------------------------------------------------*/
;*    Copyright (c) 1996 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.8/Read/src.scm             */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Mon Dec 26 10:44:03 1994                          */
;*    Last change :  Tue Feb  6 18:04:49 1996 (serrano)                */
;*    -------------------------------------------------------------    */
;*    We read the source file                                          */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module read_src
   (import  engine_param
	    engine_engine
	    main)
   (export  (read-src)))

;*---------------------------------------------------------------------*/
;*    read-src ...                                                     */
;*---------------------------------------------------------------------*/
(define (read-src)
   ;; The prelude of this pass is located in parse_src
   (let* ((port (if (string? *src*)
		    (if (file-exists? *src*)
			(let ((port (open-input-file *src*)))
			   (if (input-port? port)
			       port
			       (error "src-file->memory"
				      "Can't open such file"
				      *src*)))
			(error "src-file->memory"
			       "Can't find such file"
			       *src*))
		    (current-input-port)))
	  (handler (lambda (escape proc mes obj)
		      ;; before producing the error, we display the
		      ;; source file name
		      (hello-world)
		      ;; then we display the error.
		      (notify-error proc mes obj)
		      (close-input-port port)
		      (exit-bigloo -3))))
      (let (module body)
	 (try (begin
		 (set! module (read port #t))
		 (set! body   (read-file port)))
	      handler)
	 (cons module body))))

;*---------------------------------------------------------------------*/
;*    read-file ...                                                    */
;*---------------------------------------------------------------------*/
(define (read-file port)
   (let loop ((r   (read port #t))
	      (acc '()))
      (if (eof-object? r)
	  (begin
	     (set! acc (reverse! acc))
	     acc)
	  (loop (read port #t)
		(cons r acc)))))


   
