;*---------------------------------------------------------------------*/
;*    Copyright (c) 1996 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.8/Parse/statexp.scm        */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Tue Dec 27 09:40:21 1994                          */
;*    Last change :  Thu May 25 17:17:22 1995 (serrano)                */
;*    -------------------------------------------------------------    */
;*    We parse static and export clauses.                              */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module parse_static-export
   (include "Ast/ast.sch")
   (import  engine_param
	    parse_definition
	    tools_args
	    tools_error
	    ast_global
	    ast_global-definition
	    ast_env)
   (export  (parse-export <clauses>)
	    (parse-static <clauses>)
	    (parse-main   <clause>)))

;*---------------------------------------------------------------------*/
;*    parse-export ...                                                 */
;*---------------------------------------------------------------------*/
(define (parse-export exports)
   (let loop ((exports exports))
      (if (null? exports)
	  '()
	  (begin
	     (generic-parser (car exports) 'export)
	     (loop (cdr exports))))))
						    
;*---------------------------------------------------------------------*/
;*    parse-static ...                                                 */
;*---------------------------------------------------------------------*/
(define (parse-static statics)
    (let loop ((statics statics))
      (if (null? statics)
	  '()
	  (begin
	     (generic-parser (car statics) 'static)
	     (loop (cdr statics)))))))
  
;*---------------------------------------------------------------------*/
;*    generic-parser ...                                               */
;*---------------------------------------------------------------------*/
(define (generic-parser prototype import)
   (let ((proto (parse-definition prototype)))
      (case (car proto)
	 ((inline procedure)
	  (to-be-define! (declare-global-procedure! import
						    *module-name*
						    (car proto)
						    (cdr proto))))
	 ((variable)
	  (to-be-define! (declare-global-variable! import
						   *module-name*
						   (car proto)
						   (cdr proto))))
	 (else
	  (user-error "Parse error" "Illegal prototype" prototype)))))
	 
;*---------------------------------------------------------------------*/
;*    parse-main ...                                                   */
;*---------------------------------------------------------------------*/
(define (parse-main main)
   (if main
       (let ((global (find-global main *module-name*)))
	 (if (global? global)
	     (let ((proto (list (parse-formal-ident main)
				(parse-formal-ident '(:: argv pair)))))
		(set! *main* main)
		(if (not (check-procedure-definition? global 
						      'export
						      'procedure
						      proto))
		    (user-error "Parse error"
				"Illegal declaration of main function"
				main)))
	     (generic-parser `(,main (:: argv pair)) 'export)))))

