;*=====================================================================*/
;*    .../prgm/project/bigloo/comptime1.8/Integrate/integrate.sch      */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Tue Mar 14 11:15:09 1995                          */
;*    Last change :  Tue Apr 25 17:36:05 1995 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The structures used by the `integrate' pass.                     */
;*=====================================================================*/


;*---------------------------------------------------------------------*/
;*    integrate ...                                                    */
;*---------------------------------------------------------------------*/
(define-union integrate
   (define-struct ivar
      f-mark    ;; <sexp>      :: a stamp to compute free variables
      u-mark    ;; <sexp>      :: a stamp to compute union of variables
      kaptured? ;; <bool>      :: is a local kaptured ?
      )
   (define-struct ifun
      owner     ;; <variable>  :: the variable which bound the local function
      free      ;; <local>*    :: the free variables list
      bound     ;; <local>*    :: the bound variables list
      cfrom     ;; <variable>* :: the list of variables which calls the fun
      cto       ;; <variable>* :: the list of variables which are called.
      K         ;;             :: the K property
      K*        ;;             :: the K* property
      U         ;; <bool>      :: the U property
      Cn        ;;             :: the Cn property
      Ct        ;;             :: the Ct property
      kont      ;; <variable>* :: the variable from which self is the kont.
      G?        ;; <bool>      :: is this function globalized ?
      L         ;; <variable>  :: the integrator (if not G?)
      Led       ;; <local>*    :: the integrated functions (if G?).
      istamp    ;; <integer>   :: a stamp to integrate functions.
      global    ;; <global>    :: a pointer to the globalized function.
      kaptured  ;; <local>*    :: the list of the kaptured variables
      ))
 
