;*---------------------------------------------------------------------*/
;*    Copyright (c) 1996 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.8/Integrate/ast.scm        */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Wed Mar 15 17:31:52 1995                          */
;*    Last change :  Tue Apr  9 15:56:37 1996 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The globalization of the bodies. This module implements a        */
;*    function which is in charge to remove displaced local            */
;*    functions and which alpha-convert free-variables.                */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module integrate_ast
   (include "Tools/trace.sch"
	    "Ast/node.sch"
	    "Integrate/integrate.sch")
   (import  tools_shape
	    tools_speek
	    ast_dump
	    ast_sexp
	    ast_local
	    ast_global
	    type_cache
	    integrate_local->global
	    integrate_tools)
   (export  (globalize!        <ast> <local> <what/by>*)
	    (integrate-celled? <local>)))

;*---------------------------------------------------------------------*/
;*    globalize! ...                                                   */
;*    -------------------------------------------------------------    */
;*    This function makes many transformation on the Ast *and*         */
;*    returns a free variables list.                                   */
;*---------------------------------------------------------------------*/
(define (globalize! ast integrator what/by*)
   (trace integrate "globalize!: " (shape integrator) " " (shape what/by*)
	  #\Newline "  " (shape ast)
	  #\Newline)
   ;; for each celled variable, we declare a new local
   ;; variable
   (let* ((fun      (variable-value integrator))
	  (celled   (celled-bindings (function-args fun)))
	  (what/by* (append celled what/by*)))
      ;; we set alpha-fast slot 
      (for-each (lambda (w.b)
		   (variable-fast-alpha-set! (car w.b) (cdr w.b)))
		what/by*)
      (let ((res (cell-formals celled
			       (do-ast-globalize! ast integrator))))
	 ;; we remove alpha-fast slots
	 (for-each (lambda (w.b)
		      (variable-fast-alpha-set! (car w.b) #f))
		   what/by*)
	 res)))

;*---------------------------------------------------------------------*/
;*    celled-bindings ...                                              */
;*---------------------------------------------------------------------*/
(define (celled-bindings formals)
   (let loop ((celled   '())
	      (formals  formals))
      (cond
	 ((null? formals)
	  celled)
	 ((not (integrate-celled? (car formals)))
	  (loop celled (cdr formals)))
	 (else
	  (let* ((var (make-local-variable (local-name (car formals)) *obj*))
		 (o.n (cons (car formals) var)))
	     (local-access-set! var 'celled-integrate)
	     (local-info-set!   var (create-ivar))
	     (ivar-kaptured?-set! (local-info var) #t)
	     (loop (cons o.n celled)
		   (cdr formals)))))))

;*---------------------------------------------------------------------*/
;*    cell-formals ...                                                 */
;*---------------------------------------------------------------------*/
(define (cell-formals celled body)
   (if (null? celled)
       body
       (let ((loc (ast-location body)))
	  (ast-let-var #f
		       #f
		       #f
		       (map (lambda (o.n)
			       (cons (cdr o.n)
				     (a-make-cell (ast-var loc
							   #f
							   #f
							   (car o.n))
						  (car o.n))))
			    celled)
		       body
		       #t))))

;*---------------------------------------------------------------------*/
;*    mark-celled-formals! ...                                         */
;*---------------------------------------------------------------------*/
(define (mark-cell-formals! variable)
   (for-each (lambda (arg)
		(if (integrate-celled? arg)
		    (local-access-set! arg 'celled-integrate)))
	     (function-args (variable-value variable))))

;;*---------------------------------------------------------------------*/
;*    integrate-celled? ...                                            */
;*---------------------------------------------------------------------*/
(define (integrate-celled? var)
   (if (and (local? var)
	    (ivar-kaptured? (local-info var)))
       (cond
	  ((eq? (local-access var) 'celled-integrate)
	   #t)
	  ((eq? (local-access var) 'write)
	   (local-access-set! var 'celled-integrate))
	  (else
	   #f))
       #f))

;*---------------------------------------------------------------------*/
;*    a-make-cell ...                                                  */
;*---------------------------------------------------------------------*/
(define (a-make-cell ast var)
   (trace (loop integrate) "celled( " (shape var) ")" #\Newline)
   (let ((loc (ast-location ast)))
      (local-access-set! var 'celled-integrate)
      (local-type-set!   var *obj*)
      (ast-make-box loc #f #f ast)))

;*---------------------------------------------------------------------*/
;*    do-ast-globalize! ...                                            */
;*---------------------------------------------------------------------*/
(define (do-ast-globalize! ast integrator)
   (let loop ((ast ast))
      (trace (loop integrate) "do-ast-globalize!" (shape integrator) ": "
	     (ast->sexp ast) #\Newline)
      (ast-case ast
	 ((atom)
	  ast)
	 ((kwote)
	  ast)
	 ((var)
	  (let* ((var   (var-variable ast))
		 (alpha (variable-fast-alpha var)))
	     (if (local? alpha)
		 (begin
		    (var-variable-set! ast alpha)
		    (loop ast))
		 (cond
		    ((integrate-celled? var)
		     (ast-box-ref (ast-location ast)
				  #f
				  #f
				  ast))
		    (else
		     ast)))))
	 ((make-box)
	  (make-box-value-set! ast (loop (make-box-value ast)))
	  ast)
	 ((box-ref)
	  (box-ref-var-set! ast (loop (box-ref-var ast)))
	  ast)
	 ((box-set!)
	  (box-set!-var-set! ast (loop (box-set!-var ast)))
	  (box-set!-value-set! ast (loop (box-set!-value ast)))
	  ast)
	 ((fun)
	  (internal-error "a-graph"
			  "Illegal node (see Globalize)"
			  (ast->sexp ast)))
	 ((prag-ma)
	  (let liip ((sexp (prag-ma-values ast)))
	     (if (null? sexp)
		 ast
		 (begin
		    (set-car! sexp (loop (car sexp)))
		    (liip (cdr sexp))))))
	 ((fail)
	  (fail-proc-set! ast (loop (fail-proc ast)))
	  (fail-msg-set! ast (loop (fail-msg ast)))
	  (fail-obj-set! ast (loop (fail-obj ast)))
	  ast)
	 ((sequence)
	  (let liip ((sexp (sequence-exp ast)))
	     (if (null? sexp)
		 ast
		 (begin
		    (set-car! sexp (loop (car sexp)))
		    (liip (cdr sexp))))))
	 ((conditional)
	  (conditional-test-set! ast (loop (conditional-test ast)))
	  (conditional-then-set! ast (loop (conditional-then ast)))
	  (conditional-else-set! ast (loop (conditional-else ast)))
	  ast)
	 ((setq)
	  [assert check (ast) (not (make-box? (setq-val ast)))]
	  (setq-val-set! ast (loop (setq-val ast)))
	  (let ((var (var-variable (setq-var ast))))
	     (let loop ((var   var)
			(alpha (variable-fast-alpha var)))
		(if (local? alpha)
		    (begin
		       (var-variable-set! (setq-var ast) alpha)
		       (loop alpha (variable-fast-alpha alpha)))
		    (let ((var (var-variable (setq-var ast))))
		       (if (integrate-celled? var)
;* 			   (ast-box-set! (ast-location ast)            */
;* 					 #f                            */
;* 					 #f                            */
;* 					 (setq-var ast)                */
;* 					 (setq-val ast))               */
			   (let ((a-var (make-local-variable (gensym 'a-cell)
							     (local-type var)))
				 (loc   (ast-location ast)))
			      (ast-let-var (ast-location ast)
					   #f
					   #f
					   (list (cons a-var (setq-val ast)))
					   (ast-box-set! loc
							 #f
							 #f
							 (setq-var ast)
							 (ast-var loc
								  #f
								  #f
								  a-var))
					   #t))
			   ast))))))
	 ((let-var)
	  (for-each (lambda (binding)
		       (let ((var (car binding))
			     (val (cdr binding)))
			  (set-cdr! binding (loop val))
			  (if (integrate-celled? var)
			      (begin
				 (local-type-set! (car binding) *obj*)
				 (set-cdr! binding
					   (a-make-cell (cdr binding)
							(car binding)))))))
		    (let-var-bindings ast))
	  (let-var-body-set! ast (loop (let-var-body ast)))
	  ast)
	 ((let-fun)
	  (let-fun-body-set! ast (loop (let-fun-body ast)))
	  (for-each (lambda (local)
		       (globalize-local-fun! local integrator))
		    (let-fun-locals ast))
	  ast)
	 ((set-ex-it)
	  (set-ex-it-exit-set! ast (loop (set-ex-it-exit ast)))
	  (set-ex-it-body-set! ast (loop (set-ex-it-body ast)))
	  ast)
	 ((jump-ex-it)
	  (jump-ex-it-exit-set! ast (loop (jump-ex-it-exit ast)))
	  (jump-ex-it-value-set! ast (loop (jump-ex-it-value ast)))
	  ast)
	 ((funcall)
	  (funcall-fun-set! ast (loop (funcall-fun ast)))
	  (let liip ((asts (funcall-actuals ast)))
	     (if (null? asts)
		 ast
		 (begin
		    (set-car! asts (loop (car asts)))
		    (liip (cdr asts))))))
	 ((app-ly)
	  (app-ly-fun-set! ast (loop (app-ly-fun ast)))
	  (app-ly-value-set! ast (loop (app-ly-value ast)))
	  ast)
	 ((app)
	  (let* ((fun  (var-variable (app-fun ast)))
		 (info (variable-info fun))
		 (loc  (ast-location ast)))
	     ;; we change the called function if globalized
	     (if (and (local? fun)
		      (ifun-G? (local-info fun)))
		 (app-fun-set! ast (ast-var (ast-location (app-fun ast))
					    #f
					    #f
					    (the-global fun))))
	     ;; we globlize the actuals before adding new one
	     ;; otherwise, we could produce illegal `cell-ref'
	     (let liip ((asts (app-actuals ast)))
		(if (null? asts)
		    'done
		    (begin
		       (set-car! asts (loop (car asts)))
		       (liip (cdr asts)))))
	     (cond
		((or (global? fun)
		     (not (ifun-G? (local-info fun))))
		 'done)
		(else
		 ;; this is a call to globalized but non escaping
		 ;; function. We add its kaptured variables
		 (let loop ((new-actuals (app-actuals ast))
			    (kaptured    (ifun-kaptured info)))
		    (if (null? kaptured)
			(app-actuals-set! ast new-actuals)
			(let* ((kap   (car kaptured))
			       (alpha (local-fast-alpha kap))
			       (var (if (local? alpha) alpha kap)))
			   (loop (cons (ast-var loc #f #f var)
				       new-actuals)
				 (cdr kaptured)))))))
	     ast))
	 ((switch)
	  (switch-test-set! ast (loop (switch-test ast)))
	  (for-each (lambda (clause)
		       (set-cdr! clause (loop (cdr clause))))
		    (switch-clauses ast))
	  ast))))

;*---------------------------------------------------------------------*/
;*    globalize-local-fun! ...                                         */
;*---------------------------------------------------------------------*/
(define (globalize-local-fun! local integrator)
   (let* ((fun   (local-value local))
	  (obody (function-body fun)))
      (mark-cell-formals! local)
      (if (eq? local integrator)
	  (function-body-set! fun (do-ast-globalize! obody integrator))
	  (let ((celled (celled-bindings (function-args fun))))
	     (for-each (lambda (w.b)
			  (variable-fast-alpha-set! (car w.b) (cdr w.b)))
		       celled)
	     (let* ((nbody1 (do-ast-globalize! obody integrator))
		    (nbody2 (cell-formals celled nbody1)))
		(for-each (lambda (w.b)
			     (variable-fast-alpha-set! (car w.b) #f))
			  celled)
		(function-body-set! fun nbody2))))))

