;*---------------------------------------------------------------------*/
;*    Copyright (c) 1996 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.8/Inline/recursive.scm     */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Tue Jan 17 17:50:35 1995                          */
;*    Last change :  Fri Dec  8 12:59:35 1995 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The recursive inlining                                           */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module inline_recursive
   (include "Ast/node.sch"
            "Tools/trace.sch"
	    "Inline/inline.sch")
   (import  tools_error
	    tools_speek
            tools_shape
	    inline_inline
	    inline_variant
	    inline_loop
	    type_cache
	    ast_duplicate
            ast_dump
            ast_env
            ast_sexp
            ast_local
            ast_global
	    ast_loc)
   (export  (inline-app-recursive <ast> <integer> <variable>*)))

;*---------------------------------------------------------------------*/
;*    inline-app-recursive ...                                         */
;*    -------------------------------------------------------------    */
;*    This function supposes that actuals arguments are atom           */
;*    (otherwise the evaluation order will not be satisfy).            */
;*    -------------------------------------------------------------    */
;*    Arity tests have already done during `bivaluation' stage. There  */
;*    is no need for new tests here.                                   */
;*---------------------------------------------------------------------*/
(define (inline-app-recursive ast-call amount stack)
   (trace inline "inline-app-recursive: " (ast->sexp ast-call) #\Newline)
   (let* ((callee    (var-variable (app-fun ast-call)))
          (fun       (variable-value callee))
          (fun-body  (function-body fun))
          (formals   (function-args fun)))
      (variable-occurrence-set! callee (-fx (variable-occurrence callee) 1))
       ;; we print what we are doing
      (if (not (and (boolean? (function-inline? fun))
		    (function-inline? fun)))
	  (verbose 2 "        "
		   (shape callee) " --> " (current-function) " (recursive)"
		   #\Newline))
      ;; we set variant formals
      (set-variant! callee fun-body)
      ;; we allocate new-variable for variant arguments
      (let* ((nb-invariant (let loop ((formals formals)
				      (res     0))
			      (cond
				 ((null? formals)
				  res)
				 ((variant-variant? (local-info (car formals)))
				  (loop (cdr formals)
					res))
				 (else
				  (loop (cdr formals)
					(+fx res 1))))))
	     (new-formals (let loop ((formals formals)
				     (res     '()))
			     (if (null? formals)
				 (reverse! res)
				 (let ((f (car formals)))
				    (if (variant-variant? (local-info f))
					(begin
					   (trace inline
						  "  - " (local-shape f)
						  " variant" #\Newline)
					   (let ((n (make-local-variable
						     '_
						     *obj*)))
					      (let ((key (local-key n)))
						 (struct-update! n f)
						 (local-key-set! n key))
					      (loop (cdr formals)
						    (cons n res))))
					(begin
					   (trace inline
						  "  - " (local-shape f)
						  " invariant" #\Newline)
					   (loop (cdr formals)
						 res)))))))
	     (new-fun     (let ((new-fun (make-local-variable
					  (variable-name callee)
					  *obj*)))
			     (local-value-set! new-fun (make-function))
			     (struct-update! (local-value new-fun) fun)
			     (let ((arity (function-arity fun)))
				(if (<fx arity 0)
				    (function-arity-set! (local-value new-fun)
							 (+fx arity
							      nb-invariant))
				    (function-arity-set! (local-value new-fun)
							 (-fx arity
							      nb-invariant))))
			     new-fun))
	     (what/by-var (let loop ((formals formals)
				     (new     new-formals)
				     (res     '()))
			     (cond
				((null? formals)
				 res)
				((variant-variant? (local-info (car formals)))
				 (loop (cdr formals)
				       (cdr new)
				       (cons (cons (car formals) (car new))
					     res)))
				(else
				 (loop (cdr formals)
				       new
				       res)))))
	     (what/by-inv (let loop ((formals formals)
				     (actuals (app-actuals ast-call))
				     (res     '()))
			     (cond
				((null? formals)
				 res)
				((variant-variant? (local-info (car formals)))
				 (loop (cdr formals)
				       (cdr actuals)
				       res))
				(else
				 (loop (cdr formals)
				       (cdr actuals)
				       (cons (cons (car formals) (car actuals))
					     res))))))
	
	     (let-body      (set-recursive-call!
			     callee
			     new-fun
			     what/by-inv
			     (ast-app (ast-location ast-call)
				      #f
				      #f
				      (ast-var (ast-location ast-call)
					       #f
					       #f
					       callee)
				      (app-actuals ast-call)
				      #f
				      #f
				      #f
				      #f)))
	     (dummy (begin (trace inline "dummy1" #\Newline)
			   (trace inline "let-body: " (ast->sexp let-body)
				  #\Newline)))
	     (fun-body      (duplicate-ast what/by-inv fun-body))
	     (new-fun-body  (set-recursive-call! callee
						 new-fun
						 '()
						 fun-body))
	     (dummy (begin (trace inline "dummy2" #\Newline)
			   (trace inline "new-fun: " (ast->sexp new-fun-body)
				  #\Newline)))
	     (new2-fun-body (duplicate-ast what/by-var new-fun-body))
	     (dummy (begin (trace inline "dummy2" #\Newline)
			   (trace inline "new-fun2: " (ast->sexp new2-fun-body)
				  #\Newline)))
	     (new3-fun-body (inline-ast new2-fun-body
					amount
					(cons new-fun (cons callee stack)))))
	 (if (or (and (global? callee) (eq? (global-import callee) 'import))
		 (not (loc? (ast-location new3-fun-body))))
	     (ast-set-loc! (ast-location ast-call) new3-fun-body))
	 (variable-fast-alpha-set! callee #f)
	 (function-args-set! (local-value new-fun) new-formals)
	 (function-body-set! (local-value new-fun) new3-fun-body)
	 (ast-let-fun (ast-location ast-call)
		      #f
		      #f
		      (list new-fun)
		      let-body))))

;*---------------------------------------------------------------------*/
;*    set-recursive-call! ...                                          */
;*    -------------------------------------------------------------    */
;*    We scan the Ast in order to patch all recursive calls to callee  */
;*---------------------------------------------------------------------*/
(define (set-recursive-call! callee new-callee what/by ast)
   ;; we set alpha-fast slot
   (for-each (lambda (q.p)
		(variable-fast-alpha-set! (car q.p) (cdr q.p)))
	     what/by)
   (let ((res (do-set-recursive-call! callee new-callee ast)))
      ;; we remove alpha-fast slots
      (for-each (lambda (q.p)
		   (variable-fast-alpha-set! (car q.p) #f))
		what/by)
      res))

;*---------------------------------------------------------------------*/
;*    do-set-recursive-call! ...                                       */
;*---------------------------------------------------------------------*/
(define (do-set-recursive-call! callee new-callee ast)      
   (let loop ((ast ast))
      (ast-case ast
	 ((atom)
	  ast)
	 ((var)
	  (let* ((var   (var-variable ast))
		 (alpha (variable-fast-alpha var)))
	     (if alpha
		 (begin
		    ;; we decrement old-variable counter
		    (variable-occurrence-set! var
					      (-fx (variable-occurrence var)
						   1))
		    (cond
		       ((var? alpha)
			;; if the substitution concerns a variable
			;; we increment its counter
			(variable-occurrence-set! (var-variable alpha)
						  (+fx (variable-occurrence
							(var-variable alpha))
						       1)))
		       ((fun? alpha)
			(let ((var (var-variable (fun-value alpha))))
			   (variable-occurrence-set! var
						     (+fx (variable-occurrence
							   var)
							  1)))))
		    alpha)
		 ast)))
	 ((make-box)
	  (make-box-value-set! ast (loop (make-box-value ast)))
	  ast)
	 ((box-ref)
	  (box-ref-var-set! ast (loop (box-ref-var ast)))
	  ast)
	 ((box-set!)
	  (box-set!-var-set! ast (loop (box-set!-var ast)))
	  (box-set!-value-set! ast (loop (box-set!-value ast)))
	  ast)
	 ((fun)
	  (internal-error "do-set-recursive-call!"
			  "Illegal node (see `Bivaluation' pass)"
			  (ast->sexp ast)))
	 ((kwote)
	  ast)
	 ((sequence)
	  (let liip ((asts (sequence-exp ast)))
	     (if (null? asts)
		 ast
		 (begin
		    (set-car! asts (loop (car asts)))
		    (liip (cdr asts))))))
	 ((app)
	  (if (recursion? callee ast)
	      (begin
		 ;; we change the callee the we remove non-variant arguments
		 ;; (there is no need to recurse on actuals since all are
		 ;; variables).
		 (app-fun-set! ast (ast-var (ast-location ast)
					    #f
					    #f
					    new-callee))
		 (let liip ((old-actuals (app-actuals ast))
			    (formals (function-args (variable-value callee)))
			    (new-actuals '()))
		    (if (null? formals)
			(let liip ((old-actuals old-actuals)
				   (new-actuals new-actuals))
			   (if (null? old-actuals)
			       (begin
				  (app-actuals-set! ast (reverse! new-actuals))
				  ast)
			       (liip (cdr old-actuals)
				     (cons (loop (car old-actuals))
					   new-actuals))))
			(if (variant-variant? (local-info (car formals)))
			    (liip (cdr old-actuals)
				  (cdr formals)
				  (cons (loop (car old-actuals))
					new-actuals))
			    (liip (cdr old-actuals)
				  (cdr formals)
				  new-actuals)))))
	      (begin
		 (app-fun-set! ast (loop (app-fun ast)))
		 (for-each loop (app-actuals ast))
		 ast)))
	 ((funcall)
	  (let liip ((asts (funcall-actuals ast)))
	     (if (null? asts)
		 ast
		 (begin
		    (set-car! asts (loop (car asts)))
		    (liip (cdr asts)))))
	  (let ((new-fun (loop (funcall-fun ast))))
	     (trace inline "funcall: " (ast->sexp (funcall-fun ast)) #\Newline)
	     (trace inline "       : " (ast->sexp new-fun) #\Newline)
	     (if (and (fun? new-fun)
		      (function? (variable-value
				  (var-variable (fun-value new-fun)))))
		 ;; we apply here the following translation:
		 ;; (funcall (funtion F) a0 .. an) --> (F a0 .. an)
		 (ast-app (funcall-location ast)
			  #f
			  #f
			  (fun-value new-fun)
			  (funcall-actuals ast)
			  #f
			  #f
			  #f
			  #f)
		 (begin
		    (funcall-fun-set! ast new-fun)
		    ast))))
	 ((prag-ma)
	  (let liip ((asts (prag-ma-values ast)))
	     (if (null? asts)
		 ast
		 (begin
		    (set-car! asts (loop (car asts)))
		    (liip (cdr asts))))))
	 ((setq)
	  (setq-val-set! ast (loop (setq-val ast))))
	 ((conditional)
	  (conditional-test-set! ast (loop (conditional-test ast)))
	  (conditional-then-set! ast (loop (conditional-then ast)))
	  (conditional-else-set! ast (loop (conditional-else ast)))
	  ast)
	 ((fail)
	  (fail-proc-set! ast (loop (fail-proc ast)))
	  (fail-msg-set! ast (loop (fail-msg ast)))
	  (fail-obj-set! ast (loop (fail-obj ast)))
	  ast)
	 ((app-ly)
	  (app-ly-value-set! ast (loop (app-ly-value ast)))
	  ast)
	 ((switch)
	  (switch-test-set! ast (loop (switch-test ast)))
	  (for-each (lambda (clause)
		       (set-cdr! clause (loop (cdr clause))))
		    (switch-clauses ast))
	  ast)
	 ((let-fun)
	  (for-each (lambda (local)
		       (let ((fun (local-value local)))
			  (function-body-set! fun
					      (loop (function-body fun)))))
		    (let-fun-locals ast))
	  (let-fun-body-set! ast (loop (let-fun-body ast)))
	  ast)
	 ((set-ex-it)
	  (set-ex-it-body-set! ast (loop (set-ex-it-body ast)))
	  ast)
	 ((jump-ex-it)
	  (jump-ex-it-exit-set! ast (loop (jump-ex-it-exit ast)))
	  (jump-ex-it-value-set! ast (loop (jump-ex-it-value ast)))
	  ast)
	 ((let-var)
	  (for-each (lambda (binding)
		       (set-cdr! binding (loop (cdr binding))))
		    (let-var-bindings ast))
	  (let-var-body-set! ast (loop (let-var-body ast)))
	  ast))))
   

