;*---------------------------------------------------------------------*/
;*    Copyright (c) 1996 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.8/Inline/inline.scm        */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Tue Jan 10 09:04:27 1995                          */
;*    Last change :  Mon Jan 22 18:51:11 1996 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The ast inlining.                                                */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module inline_inline
   (include "Ast/node.sch"
	    "Tools/trace.sch")
   (import  inline_app
	    tools_shape
	    ast_substitute
	    ast_dump
	    engine_param
	    type_cache)
   (export  (inline-ast <ast> <integer> <variable>*)))

;*---------------------------------------------------------------------*/
;*    inline-ast ...                                                   */
;*---------------------------------------------------------------------*/
(define (inline-ast ast amount stack)
   (trace (inline loop) "> [" amount "]: " (ast->sexp ast) #\Newline)
   (ast-case ast
      ((atom)
       ast)
      ((var)
       ast)
      ((make-box)
       (make-box-value-set! ast
			    (inline-ast (make-box-value ast) amount stack))
       ast)
      ((box-ref)
       (box-ref-var-set! ast (inline-ast (box-ref-var ast) amount stack))
       ast)
      ((box-set!)
       (box-set!-var-set! ast (inline-ast (box-set!-var ast) amount stack))
       (box-set!-value-set! ast
			    (inline-ast (box-set!-value ast) amount stack))
       ast)
      ((kwote)
       ast)
      ((sequence)
       (let loop ((asts (sequence-exp ast)))
          (if (null? asts)
              ast
              (begin
                 (set-car! asts (inline-ast (car asts) amount stack))
                 (loop (cdr asts))))))
      ((setq)
       (setq-val-set! ast (inline-ast (setq-val ast) amount stack))
       ast)
      ((conditional)
       (conditional-test-set! ast (inline-ast (conditional-test ast)
                                              amount
                                              stack))
       (conditional-then-set! ast (inline-ast (conditional-then ast)
                                              amount
                                              stack))
       (conditional-else-set! ast (inline-ast (conditional-else ast)
                                              amount
                                              stack))
       ast)
      ((fail)
       (fail-proc-set! ast (inline-ast (fail-proc ast) amount stack))
       (fail-msg-set! ast (inline-ast (fail-msg ast) amount stack))
       (fail-obj-set! ast (inline-ast (fail-obj ast) amount stack))
       ast)
      ((let-fun)
       (let-fun-body-set! ast (inline-ast (let-fun-body ast) amount stack))
       (for-each (lambda (local)
                    (let ((fun (local-value local)))
                       (function-body-set! fun
                                           (inline-ast (function-body fun)
                                                       amount
                                                       (cons local stack)))))
                 (let-fun-locals ast))
       ;; we remove unused local definitions
       (let ((first (let loop ((locals (let-fun-locals ast)))
                       (if (null? locals)
                           '()
                           (let* ((local (car locals))
                                  (fun   (local-value local)))
                              (if (<=fx (local-occurrence local) 0)
                                  (loop (cdr locals))
                                  locals))))))
          (let-fun-locals-set! ast first)
          (if (null? first)
              (let-fun-body ast)
              (let loop ((locals (cdr first))
                         (prev   first))
                 (if (null? locals)
                     (begin
                        (set-cdr! prev '())
                        ast)
                     (let* ((local (car locals))
                            (fun   (local-value local)))
                        (if (<=fx (local-occurrence local) 0)
                            (loop (cdr locals)
                                  prev)
                            (begin
                               (set-cdr! prev locals)
                               (loop (cdr locals)
                                     locals)))))))))
      ((let-var)
       (let loop ((bindings  (let-var-bindings ast))
		  (nbindings '())
		  (what/by   '()))
	  (if (null? bindings)
	      (let* ((body     (let-var-body ast))
		     (new-body (if (pair? what/by)
				   (substitute! what/by body)
				   body)))
		 (let-var-body-set! ast
				    (inline-ast new-body amount	stack))
		 (let-var-bindings-set! ast (reverse! nbindings))
		 ast)
	      (let ((binding (car bindings)))
		 (set-cdr! binding (inline-ast (cdr binding) amount stack))
		 (if (and (>=fx *optim* 2)
			  (var? (cdr binding))
			  (eq? (variable-access (var-variable (cdr binding)))
			       'read)
			  (eq? (variable-access (car binding)) 'read)
			  (let ((t1 (variable-type (var-variable
						    (cdr binding))))
				(t2 (variable-type (car binding))))
			     (or (eq? t1 t2)
				 (and (or (eq? t1 *procedure*)
					  (eq? t1 *obj*)
					  (null? t1))
				      (or (eq? t2 *procedure*)
					  (eq? t2 *obj*)
					  (null? t2))))))
		     ;; this expansion is for the optimizing expressions
		     ;; like: (let ((f car)) (f 1)) and to allow the inlining
		     ;; of f in the expression `(f 1)'. Inlining is performed
		     ;; before `bivalue' stage and hence rather than
		     ;; considering function bindings we consider all
		     ;; binding which involved in their right side a non
		     ;; mutable variable.
		     ;; This expansion can be made safely only if the
		     ;; two variables are of the same type.
		     (begin
			(trace inline "beta reducing (inlining) : "
			       (shape binding) #\Newline)
			(loop (cdr bindings)
			      nbindings
			      (cons (cons (car binding)
					  (var-variable (cdr binding)))
				    what/by)))
		     (loop (cdr bindings)
			   (cons binding nbindings)
			   what/by))))))
      ((app-ly)
       (app-ly-fun-set! ast (inline-ast (app-ly-fun ast) amount stack))
       (app-ly-value-set! ast (inline-ast (app-ly-value ast) amount stack))
       ast) 
      ((funcall)
       (let loop ((actuals (funcall-actuals ast)))
	  (if (null? actuals)
	      ast
	      (begin
		 (set-car! actuals (inline-ast (car actuals) amount stack))
		 (loop (cdr actuals)))))
       (let ((new-fun (inline-ast (funcall-fun ast) amount stack)))
	  (if (and (fun? new-fun)
		   (function?
		    (variable-value (var-variable (fun-value new-fun)))))
	      ;; we apply here the following translation:
	      ;; (funcall (funtion F) a0 .. an) --> (F a0 .. an)
	      (ast-app (funcall-location ast)
		       #f
		       #f
		       (fun-value new-fun)
		       (funcall-actuals ast)
		       #f
		       #f
		       #f
		       #f)
	      (begin
		 (funcall-fun-set! ast new-fun)
		 ast))))
      ((fun)
       (internal-error "do-set-recursive-call!"
		       "Illegal node (see `Bivaluation' pass)"
		       (ast->sexp ast)))
      ((app)
       (inline-app ast amount stack))
      ((set-ex-it)
       (set-ex-it-body-set! ast (inline-ast (set-ex-it-body ast) amount stack))
       ast)
      ((jump-ex-it)
       (jump-ex-it-exit-set! ast (inline-ast (jump-ex-it-exit ast) amount stack))
       (jump-ex-it-value-set! ast (inline-ast (jump-ex-it-value ast)
					     amount
					     stack))
       ast)
      ((switch)
       (switch-test-set! ast (inline-ast (switch-test ast) amount stack))
       (for-each (lambda (clause)
                    (set-cdr! clause (inline-ast (cdr clause) amount stack)))
                 (switch-clauses ast))
       ast)
      ((prag-ma)
       (let loop ((values (prag-ma-values ast)))
	  (if (null? values)
	      ast
	      (begin
		 (set-car! values (inline-ast (car values) amount stack))
		 (loop (cdr values))))))))
