;*---------------------------------------------------------------------*/
;*    Copyright (c) 1996 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.8/Inline/app.scm           */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Tue Jan 10 18:43:56 1995                          */
;*    Last change :  Tue Aug 15 11:29:40 1995 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The inlining of application node                                 */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module inline_app
   (include "Ast/node.sch"
            "Tools/trace.sch"
            "Inline/inline.sch")
   (import  inline_inline
            ast_length
	    ast_sexp
	    ast_dump
	    ast_app
	    tools_shape
            inline_loop
            inline_simple
	    inline_recursive
            engine_param)
   (export  (inline-app ast amount stack)))

;*---------------------------------------------------------------------*/
;*    inline-app ...                                                   */
;*---------------------------------------------------------------------*/
(define (inline-app ast amount stack)
   ;; first we inline actuals arguments
   (let loop ((args (app-actuals ast)))
      (if (null? args)
          'done
          (begin
             (set-car! args (inline-ast (car args) amount stack))
             (loop (cdr args)))))
   (let ((callee (app-fun ast)))
      (ast-case callee
         ((var)
          (let* ((var (var-variable callee))
                 (fun (variable-value var))
		 (occ (variable-occurrence var)))
	     (trace inline "inline-app: " (shape var) " occ: " occ #\Newline)
             (cond
		((function? fun)
                 ;; it is a constant application
                 (let ((amount (if (integer? amount)
                                   amount
                                   (get-fun-amount fun))))
                    (if (inline-app? var amount stack)
			(if (correct-app? (function-arity fun) ast)
			    (let ((new-amount (if (=fx occ 1)
						  amount
						  (-fx
						   amount
						   (-fx (function-body-length
							 var)
							(absfx
							 (function-arity
							  (variable-value
							   var))))))))
			       (if (is-loop? var)
				   ;; loops are inlined only when
				   ;; they are with global variables
				   (if (global? var)
				       (inline-app-recursive ast
							     new-amount
							     stack)
				       ast)
				   (inline-app-simple ast new-amount stack)))
			    (app-error (current-function) ast))
			ast)))
		((ffunction? fun)
		 ast)
		(else
		 (app-fun-set! ast (inline-ast (app-fun ast) amount stack))
		 ast))))
         (else
	  (app-fun-set! ast (inline-ast (app-fun ast) amount stack))
	  ast))))

;*---------------------------------------------------------------------*/
;*    get-fun-amount ...                                               */
;*---------------------------------------------------------------------*/
(define (get-fun-amount fun)
   (*fx 2 (+fx (*fx 2 *optim*) (+fx 1 (absfx (function-arity fun))))))

;*---------------------------------------------------------------------*/
;*    inline-app? ...                                                  */
;*    -------------------------------------------------------------    */
;*    Shall we inline a app to `var' ?                                 */
;*---------------------------------------------------------------------*/
(define (inline-app? var amount stack)
   (trace inline "inline-app?: " (shape var) " [amount:" amount "] "
          (shape stack) " ... ")
   (let ((fun (variable-value var)))
      (cond
         ((memq var stack)
          ;; no we won't because we are already inlining a app to `fun'
          (trace inline " no (stack)" #\Newline)
          #f)
         ((and (global? var) (eq? (global-class var) 'inline))
          ;; yes, because the function has been declared inline
          (trace inline " yes (declared)" #\Newline)
          #t)
	 ((boolean? (function-inline? (variable-value var)))
	  ;; function can carry their own inline information...
	  (trace inline (function-inline? (variable-value var))
		 " (Iinfo? slot)" #\Newline)
	  (function-inline? (variable-value var)))
         ((and (global? var) (eq? (global-import var) 'import))
          ;; of course not.
          (trace inline " no (import)" #\Newline)
          #f)
         ((or (<fx *optim* 1) (not *inlining?*))
          ;; no, because the user said so
          (trace inline " no (user)" #\Newline)
          #f)
         ((and (=fx (variable-occurrence var) 1)
	       (<fx (-fx (function-body-length var)
			 (absfx (function-arity (variable-value var))))
		    (*fx 8 amount))
	       (or (local? var)
		   (eq? (global-import var) 'static)))
          ;; yes, because the size does not grew
          (trace inline " yes (1 site)" #\Newline)
          #t)
	 ((<fx (function-body-length var)
	       (absfx (function-arity (variable-value var))))
	  ;; yes because the function reduces the abstract syntax tree size
	  #t)
         ((<fx (function-body-length var) amount)
          ;; yes, because the function is small enough
          (trace inline
		 " yes (small:" (function-body-length var) ")"
		 #\Newline)
          #t)
         (else
          ;; no, because the function is too large
          (trace inline " no (size: " (function-body-length var)
                 " amount: " amount ")" #\newline)
          #f))))

;*---------------------------------------------------------------------*/
;*    function-body-length ...                                         */
;*    -------------------------------------------------------------    */
;*    This function return the length of the body of a function        */
;*    (computed in number of ast node).                                */
;*---------------------------------------------------------------------*/
(define (function-body-length variable)
   (if (Iinfo? (variable-info variable))
       (Iinfo-length (variable-info variable))
       (let ((length (ast-length (function-body (variable-value variable)))))
          (variable-info-set! variable (Iinfo length))
          length)))

