;*---------------------------------------------------------------------*/
;*    Copyright (c) 1996 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.8/Init/parse-args.scm      */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Sun Aug  7 11:47:46 1994                          */
;*    Last change :  Tue Apr  9 15:02:05 1996 (serrano)                */
;*    -------------------------------------------------------------    */
;*    On parse les arguments                                           */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module init_parse-args
   (include "Init/args.sch")
   (export  (parse-args args))
   (import  engine_param
	    main
	    write_version
	    tools_trace
	    tools_speek
	    read_access
	    init_extend))

;*---------------------------------------------------------------------*/
;*    *extended-donte?* ...                                            */
;*---------------------------------------------------------------------*/
(define *extended-done?* #f)

;*---------------------------------------------------------------------*/
;*    parse-args ...                                                   */
;*---------------------------------------------------------------------*/
(define (parse-args args)
   (set! *bigloo-cmd-name* (car args))
   (set! *bigloo-args*     args)
   (do-parse-args (cdr args))
   (if *extended-done?*
       #t
       (let ((cell (if (not (string? *src*))
		       #f
		       (assoc (suffix *src*) *auto-mode*))))
	  (if cell
	      (do-parse-args `("-extend" ,(cdr cell)))
	      #t))))

;*---------------------------------------------------------------------*/
;*    do-parse-args ...                                                */
;*---------------------------------------------------------------------*/
(define (do-parse-args args)
   (define (usage args-parse-usage)
      (version)
      (print "usage: bigloo [options] [src_name]")
      (newline)
      (args-parse-usage)
      (newline)
      (print " * : only available in developing mode")
      (print " + : not always available")
      (print " . : option enabled in -O3 mode (and higher optimization levels)")
      (newline)
      (newline)
      (print "Shell Variables:")
      (print "   - TMPDIR    : tmp directory (default \"/tmp\")")
      (print "   - BIGLOOLIB : libraries' directory")
      (print "   - BIGLOOHEAP: the initial heap size in megabytes (4 Mo by default)")
      (newline)
      (print "Runtime Command file:")
      (print "   - ~/.bigloorc")
      (exit-bigloo 0))
   (args-parse args
;*--- test preliminiaire ----------------------------------------------*/
      (("-")
       (error "parse-args" "incorrect option (use -help)" the-args))
;*--- L'aide ----------------------------------------------------------*/
      (("?")
       (usage args-parse-usage))
      (("-help")
       (usage args-parse-usage))
;*--- Le nom du resultat ----------------------------------------------*/
      (("-o" ?dst (synopsis "Name the output file <dst>"))
       (set! *dest* dst))
;*--- --to-stdout -----------------------------------------------------*/
      (("--to-stdout" (synopsis "Write C code on current output channel"))
       (set! *verbose* -1)
       (set! *dest* '--to-stdout))
;*--- les optimisations -----------------------------------------------*/
      (("-Obench" (synopsis "Benchmarking mode"))
       (set! the-remaining-args
	     (append '("-O4" "-fstack" "-unsafe" "-copt" "-O3")
		     the-remaining-args)))
      (("-O?opt" (synopsis "-O[2..6]" "Optimization modes"))
       (parse-optim-args opt))
;*--- Les options `-f...' ---------------------------------------------*/
      (("-farithmetic"
	(synopsis "Suppress genericity of arithmetic operators"))
       (set! *genericity* #f))
      (("-fsharing" (synopsis "Attempt to share constant data"))
       (set! *shared-cnst?* #t))
      (("-fstack" (synopsis "Transform heap to stack allocations"))
       (set! *heap->stack?* #t))
;*--- unsafe ----------------------------------------------------------*/
      (("-unsafe?opt"
	(synopsis "-unsafe[atrsv]"
		  "Don't check [type/arity/range/struct/version]"))
       (parse-unsafe-args opt))
;*--- la version ------------------------------------------------------*/
      (("-version" (synopsis "The current release"))
       (short-version)
       (exit-bigloo 0))
;*--- query -----------------------------------------------------------*/
      (("-query" (synopsis "Dump the current configuration"))
       (query))
;*--- -q --------------------------------------------------------------*/
      (("-q" (synopsis "Do not load any rc file"))
       'nothing-to-do)
;*--- -eval -----------------------------------------------------------*/
      (("-eval" ?string (synopsis "Evaluate <string>"))
       (let ((port (open-input-string string)))
	  (let laap ((exp (read port)))
	     (if (eof-object? exp)
		 'done
		 (begin
		    (eval exp)
		    (laap (read port)))))))
;*--- le `load-path' --------------------------------------------------*/
      (("-I" ?name (synopsis "Add <name> to the load path"))
       (set! *load-path* (cons name *load-path*)))
;*--- Les options de verbosite ----------------------------------------*/
      (("-s" (synopsis "Be silent"))
       (set! *verbose* -1))
      (("-v" (synopsis "-v[23]" "Be verbose"))
       (set! *verbose* 1))
      (("-v2")
       (set! *verbose* 2))
      (("-v3")
       (set! *verbose* 3))
      (("-w" (synposis "Inhibit all warning messages"))
       (set! *warning* #f))
      (("-Wall" (synopsis "warn about all possible type errors"))
       (set! *warning* 2))
;*--- L'interprete ----------------------------------------------------*/
      (("-i" (synopsis "Don't compile but interprete a src-file"))
       (set! *interpreter* #t))
;*--- Le nom du fichier d'access --------------------------------------*/
      (("-afile" ?file (synopsis "Set name of the access file"))
       (set! *access-file* file))
;*--- Un access -------------------------------------------------------*/
      (("-access" ?module ?file
		  (synopsis "Set access between module and file"))
       (add-access! (string->symbol (string-upcase module)) file))
;*--- Les suffix ------------------------------------------------------*/
      (("-suffix" ?suffix (synopsis "Recognize suffix as Scheme source"))
       (set! *suffix* (cons suffix *suffix*)))
;*--- Le nom du main --------------------------------------------------*/
      (("-main" ?fun (synopsis "Set the main function"))
       (set! *main* (string->symbol (string-upcase fun))))
;*--- L'extension du compilateur --------------------------------------*/
      (("-extend" ?name (synopsis "Extend the compiler"))
       (set! *extended-done?* #t)
       (load-extend name)
       (if (procedure? *extend-entry*)
	   (set! the-remaining-args (*extend-entry* the-remaining-args))))
;*--- nil -------------------------------------------------------------*/
      (("-nil" (synopsis "Evaluate '() as #f in `if' expression"))
       (set! *nil* #f))
;*--- l'option -cc ----------------------------------------------------*/
      (("-cc" ?compiler (synopsis "Specify the C compiler"))
       (set! *cc* compiler))
;*--- -kr-c -----------------------------------------------------------*/
      (("-stdc" (synopsis "Generate strict ISO C code"))
       (set! *stdc* #t))
;*--- les options de cc -----------------------------------------------*/
      (("-copt" ?string (synopsis "Invoke cc with <string>"))
       (set! *cc-options* (string-append string " " *cc-options*)))
;*--- les options de ld -----------------------------------------------*/
      (("-ldopt" ?string (synopsis "Invoke ld with <string>"))
       (set! *ld-options* (string-append string " " *ld-options*)))
;*--- La suppression des fichiers C -----------------------------------*/
      (("-rm" (synopsis "<-/+>rm" "Don't or force removing C file"))
       (set! *rm-c-files* #f))
      (("+rm")
       (set! *rm-c-files* #t))
;*--- call/cc ---------------------------------------------------------*/
      (("-call/cc" (synopsis "Enable call/cc function"))
       (set! *call/cc?* #t))
;*--- -llibrary -------------------------------------------------------*/
      (("-l?library" (synopsis "Link with object library"))
       (set! *bigloo-user-lib* (cons (string-append "-l" library)
				     *bigloo-user-lib*)))
;*--- debug -----------------------------------------------------------*/
      (("-g" (synopsis "-g[234]" "Produce Bigloo debug informations"))
       (set! *compiler-debug* 1))
      (("-g2")
       (set! *compiler-debug* 2))
      (("-g3")
       (set! *compiler-debug* 3))
      (("-g4")
       (set! *compiler-debug* 4))
      (("-cg" (synopsis "Compile C files with debug option"))
       (set! *rm-c-files* #f)
       (set! *c-debug* #t)
       (set! *strip* #f))
;*--- le profiling ----------------------------------------------------*/
      (("-pg" (synopsis "Compile files with profiling option (+)"))
       (set! *strip* #f)
       (change-bigloo-lib! "-lbigloo_p")
       (set! *cc-options* (string-append "-pg " *cc-options*)))
;*--- char ------------------------------------------------------------*/
      (("-char" ?bit
		(synopsis "-char <7/8>bit" "Chars' size (7 bit or 8 bit)")) 
       (cond
	  ((string=? bit "8bit")
	   (set! *rgc-last-char* 255))
	  ((string=? bit "7bit")
	   (set! *rgc-last-char* 127))
	  (else
	   (error "parse-args"
		  "illegal argument (see -help)"
		  bit))))
;*--- la compilation des modules de librairie -------------------------*/
      (("-mklib" (synopsis "Compile a library module"))
       (set! *lib-mode* #t)
       (set! *init-mode* 'lib))
;*--- la sauvegarde d'un environement de compilation ------------------*/
      (("-mkheap" (synopsis "Build an heap file"))
       (set! *pass* 'make-heap))
;*--- la compilation des modules pour la distribution -----------------*/
      (("-mkdistrib" (synopsis "Compile a main file for a distribution"))
       (set! *pass* 'distrib))
;*--- on change le nom du tas a charger (ou a sauver) -----------------*/
      (("-heap" ?name
		(synopsis "Specify an heap file (or #f to not load heap)"))
       (set! *heap-name* name))
;*--- le control de l'impression --------------------------------------*/
      (("-shape?opt" (synopsis "-shape[mkt]"
			       "Some debugging tools (private)"))
       (parse-shape-args opt))
;*--- les traces inclusives -------------------------------------------*/
      (("-t?opt"
	(synopsis
	 " <-/+>t<trace-flag>"
	 (let loop
	       ((l (reverse!
		    '(#"Generate a trace file (*)\n"
		      #"       i : init         e : env          E : env (long)\n"
		      #"       r : read         x : eps          l : inline\n"
		      #"       h : hoist        s : remove       t : type\n"
		      #"       g : globalize    S : stack        k : cnst\n"
		      #"       c : integrate    C : cgen         o : other\n"
		      #"       R : reduce       w : effet        f : cfa\n"
		      #"       a : assert       L : loop")))
		(res ""))
	    (if (null? l)
		res
		(loop (cdr l) (string-append (car l) res))))))
       (let ((len (string-length opt)))
	  (if (=fx len 0)
	      (start-trace 'all 'or)
	      (parse-trace-args 'or opt len)))) 
;*--- les traces exclusives -------------------------------------------*/
      (("+t?opt")
       (let ((len (string-length opt)))
	  (if (=fx len 2)
	      (start-trace 'all 'and)
	      (parse-trace-args 'and opt len))))
;*--- Les pass de compilation -----------------------------------------*/
      (("-expand" (synopsis "Stop after the preprocessing stage"))
       (set! *pass* 'expand))
      (("-ast" (synopsis "Stop after the ast construction stage"))
       (set! *pass* 'ast))
      (("-callcc" (synopsis "Stop after the callcc pass"))
       (set! *pass* 'callcc))
      (("-bivalue" (synopsis "Stop after the bivaluation stage"))
       (set! *pass* 'bivalue))
      (("-inline" (synopsis "Stop after the inlining stage"))
       (set! *pass* 'inline))
      (("-fail" (synopsis "Stop after the failure replacement stage"))
       (set! *pass* 'fail))
      (("-fuse" (synopsis "Stop after the fuse stage"))
       (set! *pass* 'fuse)) 
      (("-user" (synopsis "Stop after the user pass"))
       (set! *pass* 'user))
      (("-coerce" (synopsis "Stop after the type coercing stage"))
       (set! *pass* 'coerce))
      (("-effect" (synopsis "Stop after the effect stage"))
       (set! *pass* 'effect))
      (("-reduce" (synopsis "Stop after the reduction optimizations stage"))
       (set! *pass* 'reduce))
      (("-assert" (synopsis "Stop after the assertions stage"))
       (set! *pass* 'assert))
      (("-lifext" (synopsis "Stop after the Lifext stage (+)"))
       (set! *pass* 'lifext))
      (("-cfa" (synopsis "Stop after the cfa stage (+)"))
       (set! *pass* 'cfa))
      (("-globalize" (synopsis "Stop after the globalization stage"))
       (set! *pass* 'globalize))
      (("-cnst" (synopsis "Stop after the constant allocation"))
       (set! *pass* 'cnst))
      (("-integrate" (synopsis "Stop after the integration stage"))
       (set! *pass* 'integrate))
      (("-cgen" (synopsis "Do not C compile and produce a .c file"))
       (set! *pass* 'cgen))
      (("-indent" (synopsis "Produce an indented .c file"))
       (set! *pass* 'cindent))
      (("-c" (synopsis "Suppress linking and produce a .o file"))
       (set! *pass* 'cc))
;*--- no-inlining -----------------------------------------------------*/
      (("-no-inlining" (synopsis "Don't inline function"))
       (set! *inlining?* #f))
;*--- Initialization mode ---------------------------------------------*/
      (("-init-lib" (synopsis "-init-<lib/read/intern>"
			      "Constants initialization mode"))
       (set! *init-mode* 'lib))
      (("-init-read")
       (set! *init-mode* 'read))
      (("-init-intern")
       (set! *init-mode* 'intern))
;*--- the garbage collector selection ---------------------------------*/
      (("-boehm"
	(synopsis "Force the runtime to use the Boehm's collector (default)"))
       (set! *garbage-collector* 'boehm)
       (change-bigloo-lib! "-lbigloo"))
      (("-bumpy" (synopsis "private option DON'T USE"))
       (set! *garbage-collector* 'bumpy)
       (change-bigloo-lib! "-lbigloo_bumpy"))
;*--- les sources -----------------------------------------------------*/
      (("-?dummy")
       (if *interpreter* 
	   'ignore
	   (error "parse-args" "Incorrect argument" the-args)))
;*--- The source file -------------------------------------------------*/
      (else
       (let ((len (string-length else)))
	  (if (and (>fx len 2)
		   (eq? (string-ref else (-fx len 2)) #\.)
		   (eq? (string-ref else (-fx len 1)) #\o))
	      (set! *o-files*  (cons else *o-files*))
	      (if *src*
		  (if *interpreter*
		      'ignore
		      (begin
			 (set! *rest-args*
			       (cons the-arg *rest-args*))))
		  (set! *src* else)))))))

;*---------------------------------------------------------------------*/
;*    parse-shape-args ...                                             */
;*---------------------------------------------------------------------*/
(define (parse-shape-args string)
   (let ((len (string-length string)))
      (if (=fx len 0)
	  (begin
	     (set! *module-shape?* #t)
	     (set! *key-shape?*    #t)
	     (set! *type-shape?*   #t))
	  (let liip ((i 0))
	     (if (=fx i len)
		 'done
		 (begin
		    (case (string-ref string i)
		       ((#\m)
			(set! *module-shape?* #t))
		       ((#\k)
			(set! *key-shape?* #t))
		       ((#\t)
			(set! *type-shape?* #t))
		       (else
			(error "parse-arg" "Illegal -shape option" string)))
		    (liip (+fx i 1))))))))

;*---------------------------------------------------------------------*/
;*    parse-unsafe-args ...                                            */
;*---------------------------------------------------------------------*/
(define (parse-unsafe-args string)
   (let ((len (string-length string)))
      (if (=fx len 0)
	  (begin
	     (change-bigloo-lib! "-lbigloo_u")
	     (set! *strip*          #t)
	     (set! *unsafe-arity*   #t)
	     (set! *unsafe-type*    #t)
	     (set! *unsafe-struct*  #t)
	     (set! *unsafe-range*   #t)
	     (set! *unsafe-version* #t))
	  (let liip ((i 0))
	     (if (=fx i len)
		 'done
		 (begin
		    (case (string-ref string i)
		       ((#\r)
			(set! *unsafe-range* #t))
		       ((#\a)
			(set! *unsafe-arity* #t))
		       ((#\t)
			(set! *unsafe-type* #t))
		       ((#\s)
			(set! *unsafe-struct* #t))
		       ((#\v)
			(set! *unsafe-version* #t))
		       (else
			(error "parse-arg" "Illegal -unsafe option" string)))
		    (liip (+fx i 1))))))))

;*---------------------------------------------------------------------*/
;*    change-bigloo-lib! ...                                           */
;*---------------------------------------------------------------------*/
(define (change-bigloo-lib! for)
   (let loop ((lib *bigloo-lib*))
      (cond
	 ((null? lib)
	  'done)
	 ((string=? (car lib) "-lbigloo_p")
	  (error "parse-args"
		 "Library already set to `-lbigloo_p'"
		 for))
	 ((string=? (car lib) "-lbigloo")
	  (set-car! lib for)
	  'done)
	 ((string=? (car lib) "-lbigloo_u")
	  (set-car! lib (string-append for "_u"))
	  'done)
	 ((string=? (car lib) "-lbigloo_bumpy")
	  (error "parse-args"
		 "Library already set to `-lbigloo_bumpy'"
		 for))
	 (else
	  (loop (cdr lib))))))
	 
;*---------------------------------------------------------------------*/
;*    parse-optim-args ...                                             */
;*---------------------------------------------------------------------*/
(define (parse-optim-args string)
   (set! *optim* 1)
   (set! *rgc-compact* 25)
   (if (> (string-length string) 0)
       (case (string-ref string 0)
	  ((#\2)
	   (if (not *c-debug*)
	       (set! *cc-options* (string-append "-O2 " *cc-options*)))
	   (set! *rgc-compact* 0)
	   (set! *optim* 2))
	  ((#\3)
	   (if (not *c-debug*)
	       (set! *cc-options* (string-append "-O2 " *cc-options*)))
	   (set! *optim* 3))
	  ((#\4 #\5 #\6)
	   (if (not *c-debug*)
	       (set! *cc-options* (string-append "-O2 " *cc-options*)))
	   (set! *optim* (-fx (char->integer (string-ref string 0))
			      (char->integer #\0))))
	  (else
	   (error "parse-arg" "Illegal -O option" string)))
       (if (not *c-debug*)
	   (set! *cc-options* (string-append "-O " *cc-options*)))))

;*---------------------------------------------------------------------*/
;*    parse-trace-args ...                                             */
;*---------------------------------------------------------------------*/
(define (parse-trace-args mode string len)
   (start-trace 'nothing mode)
   (let liip ((i 0))
      (if (=fx i len)
	  'done
	  (begin
	     (case (string-ref string i)
		((#\r)
		 (add-trace-mask 'read))
		((#\e)
		 (set! *pp-env-mode* 'short)
		 (add-trace-mask 'env))
		((#\E)
		 (if (eq? *pp-env-mode* 'long)
		     (set! *pp-env-mode* 'extra-long)
		     (set! *pp-env-mode* 'long))
		 (add-trace-mask 'env))
		((#\i)
		 (add-trace-mask 'init))
		((#\x)
		 (add-trace-mask 'eps))
		((#\l)
		 (add-trace-mask 'inline))
		((#\L)
		 (add-trace-mask 'loop))
		((#\h)
		 (add-trace-mask 'hoist))
		((#\s)
		 (add-trace-mask 'remove))
		((#\t)
		 (add-trace-mask 'type))
		((#\g)
		 (add-trace-mask 'globalize))
		((#\k)
		 (add-trace-mask 'cnst))
		((#\c)
		 (add-trace-mask 'integrate))
		((#\C)
		 (add-trace-mask 'cgen))
		((#\o)
		 (add-trace-mask 'other))
		((#\R)
		 (add-trace-mask 'reduce))
		((#\w)
		 (add-trace-mask 'effect))
		((#\f)
		 (add-trace-mask 'cfa))
		((#\a)
		 (add-trace-mask 'assert))
		((#\S)
		 (add-trace-mask 'stack))
		(else
		 (error "parse-arg" (if (eq? mode 'or)
					"Illegal -t option"
					"Illegal +t option")
			string)))
	     (liip (+fx i 1))))))

;*---------------------------------------------------------------------*/
;*    query ...                                                        */
;*---------------------------------------------------------------------*/
(define (query)
   (version)
   (newline)
   (print "setups:")
   (newline)
   (print "*cc*                   : " *cc*)
   (print "*cc-options*           : " *cc-options*)
   (print "*ld-options*           : " *ld-options*)
   (print "*bigloo-lib*           : " *bigloo-lib*)
   (print "*bigloo-user-lib*      : " *bigloo-user-lib*)
   (print "*bigloo-user-includes* : " *bigloo-user-includes*)
   (print "*lib-dir*              : " *lib-dir*)
   (print "*include-foreign*      : " *include-foreign*)
   (print "*heap-name*            : " *heap-name*)
   (newline)
   (print "(Too see all options enter the interpreter)")
   (exit-bigloo 0))

	  
	      


