;*---------------------------------------------------------------------*/
;*    Copyright (c) 1996 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.8/Effect/fix.scm           */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Sat Jul 15 11:30:48 1995                          */
;*    Last change :  Mon Oct  2 17:50:07 1995 (serrano)                */
;*    -------------------------------------------------------------    */
;*    A fix point iteration until all side effects are noted           */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module effect_fix
   (include "Tools/trace.sch"
	    "Ast/ast.sch"
	    "Effect/effect.sch")
   (import  tools_shape
	    effect_cgraph)
   (export  (iterate-to-fixpoint W)))

;*---------------------------------------------------------------------*/
;*    iterate-to-fixpoint ...                                          */
;*---------------------------------------------------------------------*/
(define (iterate-to-fixpoint W)
   (trace effect "W: " (shape W) #\Newline)
   (let loop ((W W))
      (if (null? W)
	  (begin
	     ;; il ne reste plus qu'a marquer pour toutes les fonctions
	     ;; qu'elles sont celles qui font des effets de bords.
	     (mark-all-functions! (get-all-functions)))
	  (loop (mark-new-side-effect! W)))))

;*---------------------------------------------------------------------*/
;*    mark-all-functions! ...                                          */
;*---------------------------------------------------------------------*/
(define (mark-all-functions! funs)
   (for-each (lambda (f)
		(trace effect "*** sef?( " (shape f) " ) : ")
		(if (not (temp-seter? (variable-info f)))
		    (function-sef?-set! (variable-value f) #t)
		    (function-sef?-set! (variable-value f) #f))
		(trace effect (if (not (temp-seter? (variable-info f)))
				  (begin
				     (function-sef?-set! (variable-value f) #t)
				     #t)
				  (begin
				     (function-sef?-set! (variable-value f) #f)
				     #f))
		       #\Newline))
	     funs))
 
;*---------------------------------------------------------------------*/
;*    mark-new-side-effect! ...                                        */
;*---------------------------------------------------------------------*/
(define (mark-new-side-effect! W)
   ;; on dit que tous les appellants font des effets de bords et
   ;; on boucle sur les nouvelles fonctions.
   (let loop ((old-W W)
	      (new-W '()))
      (if (null? old-W)
	  new-W
	  (let ((w (car old-W)))
	     (let laap ((cfrom (temp-cfrom (get-info w)))
			(new-W new-W))
		(if (null? cfrom)
		    (loop (cdr old-W) new-W)
		    (if (temp-seter? (get-info (car cfrom)))
			(laap (cdr cfrom) new-W)
			(begin
			   (temp-seter?-set! (get-info (car cfrom)) #t)
			   (laap (cdr cfrom) (cons (car cfrom) new-W))))))))))
	      

   
