;*---------------------------------------------------------------------*/
;*    Copyright (c) 1996 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.8/Coerce/coerce.scm        */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Thu Jan 19 09:57:49 1995                          */
;*    Last change :  Fri Dec  8 11:19:08 1995 (serrano)                */
;*    -------------------------------------------------------------    */
;*    We coerce an Ast                                                 */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module coerce_coerce
   (include "Type/type.sch"
	    "Ast/node.sch"
	    "Tools/trace.sch")
   (import  tools_shape
	    type_cache
	    ast_dump
	    ast_typeof
	    coerce_pproto
	    coerce_convert
	    coerce_app
	    coerce_apply
	    coerce_funcall)
   (export  (coerce! <ast> <type>)))

;*---------------------------------------------------------------------*/
;*    fix-variable-type! ...                                           */
;*---------------------------------------------------------------------*/
(define (fix-variable-type! var)
   (let ((type (variable-type var)))
      (if (type? type)
	  'done
	  (variable-type-set! var *obj*))))
 
;*---------------------------------------------------------------------*/
;*    coerce! ...                                                      */
;*---------------------------------------------------------------------*/
(define (coerce! ast to)
   (assert check (ast to) (type? to))
   (trace type "coerce!: " (ast->sexp ast) " [" (shape to) #\] #\Newline)
   (ast-case ast
      ((atom)
       (convert! ast (typeof ast) to))
      ((var)
       (convert! ast (typeof ast) to))
      ((kwote)
       (convert! ast (typeof ast) to))
      ((sequence)
       (let loop ((hook (sequence-exp ast)))
	  (if (null? (cdr hook))
	      (begin
		 (set-car! hook (coerce! (car hook) to))
		 ast)
	      (begin
		 ;; yes, it is strange, we coerce to the type of
		 ;; the expression !
		 (set-car! hook (coerce! (car hook) (typeof (car hook))))
		 (loop (cdr hook))))))
      ((setq)
       (fix-variable-type! (var-variable (setq-var ast)))
       (setq-val-set! ast (coerce! (setq-val ast)
				   (variable-type
				    (var-variable (setq-var ast)))))
       (convert! ast *unspec* to))
      ((conditional)
       (conditional-test-set! ast (coerce! (conditional-test ast) *bool*))
       (conditional-then-set! ast (coerce! (conditional-then ast) to))
       (conditional-else-set! ast (coerce! (conditional-else ast) to))
       ast)
      ((fail)
       (fail-proc-set! ast (coerce! (fail-proc ast) *obj*))
       (fail-msg-set! ast (coerce! (fail-msg ast) *obj*))
       (fail-obj-set! ast (coerce! (fail-obj ast) *obj*))
       (convert! ast *magic* to))
      ((let-fun)
       (inc-ppmarge!)
       (for-each (lambda (local)
		    (let ((fun (local-value local)))
		       (fix-function-types! fun)
		       (pfunction-proto local)
		       (function-body-set! fun
					   (coerce! (function-body fun)
						    (function-type-res fun)))))
		 (let-fun-locals ast))
       (let-fun-body-set! ast (coerce! (let-fun-body ast) to))
       (dec-ppmarge!)
       ast)
      ((let-var)
       (inc-ppmarge!)
       (for-each (lambda (binding)
		    (fix-variable-type! (car binding))
		    (pvariable-proto (car binding))
		    (set-cdr! binding (coerce! (cdr binding)
					       (local-type (car binding)))))
		 (let-var-bindings ast))
       (let-var-body-set! ast (coerce! (let-var-body ast) to))
       (dec-ppmarge!)
       ast)
      ((app-ly)
       (coerce-apply! ast to))
      ((app)
       (coerce-app! ast to))
      ((fun)
       ;; we check (for an internal purpose) that the function
       ;; is of type obj x ... x obj -> obj
       (let ((fun (variable-value (var-variable (fun-value ast)))))
	  (if (or (not (eq? (function-type-res fun) *obj*))
		  (let loop ((args (function-args fun)))
		     (cond
			((null? args)
			 #f)
			((eq? (local-type (car args)) *obj*)
			 (loop (cdr args)))
			(else
			 #t))))
	      (internal-error
	       "coerce!"
	       "Only `obj x ... x obj -> obj' functions can be used as values"
	       (ast->sexp ast))))
       ;; we help the programer with this warning
       (if (not (or (eq? to *obj*)
		    (eq? to *procedure*)))
	   (user-warning/location (ast-location ast)
				  (current-function)
				  "suspicious cast"
				  (shape (fun-value ast))))
       ;; ok, we can convert now
       (convert! ast *procedure* to))
      ((funcall)
       (coerce-funcall! ast to))
      ((set-ex-it)
       (set-ex-it-exit-set! ast (coerce! (set-ex-it-exit ast) *exit*))
       (pvariable-proto (var-variable (set-ex-it-exit ast)))
       (set-ex-it-body-set! ast (coerce! (set-ex-it-body ast) to))
       ast)
      ((jump-ex-it)
       (jump-ex-it-exit-set! ast (coerce! (jump-ex-it-exit ast) *exit*))
       (jump-ex-it-value-set! ast (coerce! (jump-ex-it-value ast) to))
       ast)
      ((switch)
       (let* ((loc       (ast-location ast))
	      (clauses   (switch-clauses ast))
	      (test-type (get-switch-type ast)))
	  (switch-test-set! ast (coerce! (switch-test ast) test-type))
	  (for-each (lambda (clause)
		       (set-cdr! clause (coerce! (cdr clause) to)))
		    clauses)
	  ast))
      ((prag-ma)
       (let loop ((values (prag-ma-values ast)))
	  (if (null? values)
	      (convert! ast (ast-type ast) to)
	      (begin
		 (set-car! values (coerce! (car values) (typeof (car values))))
		 (loop (cdr values))))))
      ((make-box)
       (make-box-value-set! ast (coerce! (make-box-value ast) *obj*))
       ast)
      ((box-ref)
       (convert! ast *obj* to))
      ((box-set!)
       (fix-variable-type! (var-variable (box-set!-var ast)))
       (box-set!-value-set! ast (coerce! (box-set!-value ast) *obj*))
       (convert! ast *unspec* to))))


