;*---------------------------------------------------------------------*/
;*    Copyright (c) 1996 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.8/Cforeign/type.scm        */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Tue Dec 27 18:57:02 1994                          */
;*    Last change :  Mon Jan 29 09:37:06 1996 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The C type managment                                             */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module cforeign_type
   (include "Type/type.sch"
	    "Tools/trace.sch")
   (import  type_coercion
	    type_env
	    type_tools
	    tools_error
	    tools_args
	    tools_shape
	    parse_type
	    parse_cforeign
	    cforeign_install-c-struct
	    cforeign_install-c-pointer
	    cforeign_install-c-array
	    cforeign_install-c-function
	    cforeign_install-c-enum)
   (export  (declare-c-type type id t-exp name)))

;*---------------------------------------------------------------------*/
;*    declare-c-type ...                                               */
;*---------------------------------------------------------------------*/
(define (declare-c-type type id t-exp name)
   (cond
      ((symbol? t-exp)
       ;; it is just an alias
       (declare-c-alias type id t-exp name
			(get-aliased-type (find-type t-exp))))
      ((pair? t-exp)
       (case (car t-exp)
	  ((struct union)
	   (declare-c-union/struct! type id t-exp name))
	  ((array)
	   (declare-c-array! type id t-exp name))
	  ((pointer)
	   (declare-c-pointer! type id t-exp name))
	  ((function)
	   (declare-c-function! type id t-exp name))
	  ((enum)
	   (declare-c-enum type id t-exp name))
	  (else
	   (internal-error "declare-c-type"
			   "Illegal c type declaration"
			   (shape type)))))
      (else
       (internal-error "declare-c-type"
		       "Illegal c type declaration"
		       (shape type)))))
 
;*---------------------------------------------------------------------*/
;*    declare-c-accessors ...                                          */
;*---------------------------------------------------------------------*/
(define (declare-c-accessors type)
   (let ((id   (type-id type))
	 (name (type-name type)))
      (let loop ((alias type))
	 (trace type "declare-c-accessors: " (shape type) " : " (shape alias)
		#\Newline)
	 (let ((t-exp (type-exp alias)))
	    (cond
	       ((symbol? t-exp)
		;; it is just an alias
		(loop (type-alias alias)))
	       ((pair? t-exp)
		(case (car t-exp)
		   ((struct union)
		    ;; this accessors creation will just build a type
		    ;; checker ...
		    (declare-c-union/struct-accessors! alias type))
		   ((array)
		    (declare-c-array-accessors! alias type))
		   ((pointer)
		    (let ((ptype (type-point-to alias)))
		       (if (eq? (type-class ptype) 'c-struct)
			   ;; ... but this one will build the real accessors.
			   (declare-c-union/struct-accessors! alias type)
			   (declare-c-pointer-accessors! alias type))))
		   ((function)
		    (declare-c-function-accessors! alias type))
		   ((enum)
		    (declare-c-enum-accessors! alias type))
		   (else
		    (internal-error "declare-c-accessors"
				    "Illegal c type declaration"
				    (shape type)))))
	       (else
		'nothing-to-do))))))
 
;*---------------------------------------------------------------------*/
;*    declare-c-alias ...                                              */
;*---------------------------------------------------------------------*/
(define (declare-c-alias type-def id t-exp name old-type)
   [assert check (t-exp) (symbol? t-exp)]
   (trace type
	  "declare-c-alias: " id " <-> " (shape old-type) "  [" t-exp
	  "]  name:" name #\Newline)
   (if (eq? id (type-id old-type))
       old-type 
       (let ((new-type (declare-aliastype! id name 'alias t-exp old-type)))
	  (type-su-name-set! new-type name)
	  (if (eq? (type-class old-type) 'c-struct)
	      (declare-c-alias-union/struct! id t-exp name old-type new-type)
	      (begin
		 (declare-c-accessors new-type)
		 new-type)))))

;*---------------------------------------------------------------------*/
;*    declare-c-alias-union/struct! ...                                */
;*---------------------------------------------------------------------*/
(define (declare-c-alias-union/struct! id t-exp name old-type new-type)
   (let* ((id*      (symbol-append id '*))
	  (old-type (type-pointed-to-by old-type))
	  (name*    (if ($-in-name? name)
			(replace-$ name "(*)")
			(string-append name " *")))
	  (type-exp (type-id old-type))
	  (type-def `(type ,id* ,type-exp ,name))
	  (ptype    (declare-c-alias type-def
				     id*
				     type-exp
				     name*
				     old-type)))
      ;; we update the struct field name which has been set
      ;; by `declare-c-alias'.
      (type-su-name-set! ptype name)
      ;; we set the relation between t and t*
      (type-pointed-to-by-set! new-type ptype)
      (type-point-to-set!      ptype new-type)
      (declare-c-accessors new-type)
      new-type))

;*---------------------------------------------------------------------*/
;*    declare-c-union/struct! ...                                      */
;*---------------------------------------------------------------------*/
(define (declare-c-union/struct! type id t-exp name)
   (let ((cobj (find-type 'cobj)))
      (if (not (type? cobj))
	  (error "declare-c-union/struct!"
		 "Unable to find `cobj' type"
		 type)
	  (let* ((id*   (symbol-append id '*))
		 (bid   (symbol-append 'b id))
		 (name* (string-append name " *"))
		 (t  (declare-subtype! id  name   (list 'cobj)
				       'c-struct t-exp))
		 ;; we don't use a pointer declaration because we do not
		 ;; want to produce accessors for this type
		 (t* (declare-subtype! id* name*   (list 'cobj)
				       'c-pointer
				       `(pointer ,id)))
		 (bt (declare-subtype! bid "obj_t" (list 'obj) 'bigloo t-exp))
		 (bid? (symbol-append bid '?))
		 (id*->bid (symbol-append id* '-> bid))
		 (bid->id* (symbol-append bid '-> id*)))
	     (type-su-name-set!       t* name)
	     (declare-c-union/struct-accessors! t t)
	     ;; we set the relation between t and t*
	     (type-pointed-to-by-set! t t*)
	     (type-point-to-set!      t* t)
	     (parse-type (list
			  `(coerce ,id* cobj    ()      ())
			  `(coerce cobj ,id*    ()      ())
			  
			  `(coerce ,bid foreign ()      ())
			  `(coerce foreign ,bid (,bid?) ())
			  
			  `(coerce ,id* ,bid    () ((lambda (,(symbol-append
							       'x:: id*))
						       (,id*->bid ',bid x))))
			  `(coerce ,id* foreign () ((lambda (,(symbol-append
							       'x:: id*))
						       (,id*->bid ',bid x))))
			  
			  `(coerce ,bid     ,id* () (,bid->id*))
			  `(coerce foreign  ,id* (,bid?) (,bid->id*))))))))

;*---------------------------------------------------------------------*/
;*    declare-c-union/struct-accessors! ...                            */
;*---------------------------------------------------------------------*/
(define (declare-c-union/struct-accessors! alias type)
   (add-c-struct! (vector alias type)))

;*---------------------------------------------------------------------*/
;*    declare-c-pointer! ...                                           */
;*---------------------------------------------------------------------*/
(define (declare-c-pointer! type id t-exp name)
   (let* ((ped-to       (cadr t-exp))
	  (ped-to-type  (find-type ped-to))
	  (old-type     (type-pointed-to-by ped-to-type)))
      (if (type? old-type)
	  ;; is there is already a type to `t-exp' we just define
	  ;; an alias ...
	  (declare-c-alias type id ped-to name old-type)
	  ;; otherwise, we define a new type ...
	  (let* ((cobj    (find-type 'cobj))
		 (bid     (symbol-append 'b id))
		 (t       (declare-subtype! id name (list 'cobj)
					    'c-pointer t-exp))
		 (bt      (declare-subtype! bid "obj_t" (list 'obj)
					    'bigloo t-exp))
		 (bid?    (symbol-append bid '?))
		 (id->bid (symbol-append id '-> bid))
		 (bid->id (symbol-append bid '-> id)))
	     ;; and we mark the relation between the two types.
	     (type-pointed-to-by-set! ped-to-type t)
	     (type-point-to-set! t ped-to-type)
	     (declare-c-pointer-accessors! t t)
	     (parse-type (list
			  `(coerce ,id cobj    ()      ())
			  `(coerce cobj ,id    ()      ())
			  
			  `(coerce ,bid foreign ()      ())
			  `(coerce foreign ,bid (,bid?) ())
			  
			  `(coerce ,id ,bid
				   ()
				   ((lambda (,(symbol-append 'x:: id))
				       (,id->bid ',bid x)))) 
			  `(coerce ,id foreign
				   ()
				   ((lambda (,(symbol-append 'x:: id))
				       (,id->bid ',bid x))))
			  
			  `(coerce ,bid    ,id ()      (,bid->id))
			  `(coerce foreign ,id (,bid?) (,bid->id))))
	     t))))

;*---------------------------------------------------------------------*/
;*    declare-c-pointer-accessors! ...                                 */
;*---------------------------------------------------------------------*/
(define (declare-c-pointer-accessors! alias type)
   (add-c-pointer! (vector alias type)))

;*---------------------------------------------------------------------*/
;*    declare-c-array! ...                                             */
;*---------------------------------------------------------------------*/
(define (declare-c-array! type id t-exp name)
   (let* ((item-id    (cadr t-exp))
	  (item-type  (find-type item-id))
	  (pitem-type (if (type? (type-pointed-to-by item-type))
			  (type-pointed-to-by item-type)
			  (let ((pitem-id (symbol-append item-id '*))
				(t-exp    `(pointer ,item-id))
				(name     (make-typed-declaration item-type
								  "*")))
			     (declare-c-pointer!
			      `(type ,pitem-id ,t-exp ,name)
			      pitem-id
			      t-exp
			      name))))
	  (type       (declare-aliastype! id name 'c-array t-exp pitem-type)))
      (type-info-set!  type item-type)
      (declare-c-array-accessors! type type)
      type))

;*---------------------------------------------------------------------*/
;*    declare-c-array-accessors! ...                                   */
;*---------------------------------------------------------------------*/
(define (declare-c-array-accessors! alias type)
   [assert check (alias) (type? (type-info alias))]
   (add-c-array! (vector type (type-info alias))))
 
;*---------------------------------------------------------------------*/
;*    declare-c-function! ...                                          */
;*---------------------------------------------------------------------*/
(define (declare-c-function! type id t-exp name)
   (let ((cobj (find-type 'cobj)))
      (if (not (type? cobj))
	  (error "declare-c-function!"
		 "Unable to find `cobj' type"
		 type)
	  (let* ((bid            (symbol-append 'b id))
		 
		 (t              (declare-subtype! id
						   name
						   (list 'cobj)
						   'c-function
						   t-exp))
		 (bt             (declare-subtype! bid
						   "obj_t"
						   (list 'obj)
						   'bigloo
						   t-exp))
		 (bid?           (symbol-append bid '?))
		 (bid->id        (symbol-append 'bid-> id))
		 (id->bid        (symbol-append id '->bid)))
	     (type-info-set! t (vector bt t-exp bid? bid->id id->bid id))
	     (declare-c-function-accessors! t t)
	     (parse-type (list
			  `(coerce ,id cobj    ()      ())
			  `(coerce cobj ,id    ()      ())

			  `(coerce ,bid foreign ()      ())
			  `(coerce foreign ,bid (,bid?) ())

			  `(coerce ,id ,bid      () ((lambda (,(symbol-append
								'x:: id))
							(,id->bid ',bid x))))
			  `(coerce ,id foreign   () ((lambda (,(symbol-append
								'x:: id))
							(,id->bid ',bid x))))
			  
			  `(coerce ,bid    ,id ()      (,bid->id))
			  `(coerce foreign ,id (,bid?) (,bid->id))))
	     t))))

;*---------------------------------------------------------------------*/
;*    declare-c-function-accessors! ...                                */
;*---------------------------------------------------------------------*/
(define (declare-c-function-accessors! alias type)
   (let ((v (type-info alias)))
      (add-c-function! (vector type
			       (vector-ref v 0)
			       (vector-ref v 1)
			       (vector-ref v 2)
			       (vector-ref v 3)
			       (vector-ref v 4)
			       (type-id type)))))

;*---------------------------------------------------------------------*/
;*    declare-c-enum ...                                               */
;*---------------------------------------------------------------------*/
(define (declare-c-enum type-def id t-exp name)
   (let* ((cobj    (find-type 'cobj))
	  (t       (declare-subtype! id name (list 'cobj) 'c-enum t-exp))
	  (bid     (symbol-append 'b id))
	  (bid?    (symbol-append bid '?))
	  (id->bid (symbol-append id '-> bid))
	  (bid->id (symbol-append bid '-> id))
	  (bt      (declare-subtype! bid "obj_t" (list 'obj)
				     'bigloo t-exp)))
      (declare-c-enum-accessors! t t)
      (parse-type (list
		   `(coerce ,id cobj     ()      ())
		   `(coerce cobj ,id     ()      ())
		   `(coerce ,bid foreign ()      ())
		   `(coerce foreign ,bid (,bid?) ())
			  
		   `(coerce ,id ,bid
			    ()
			    ((lambda (,(symbol-append 'x:: id))
				(,id->bid ',bid x)))) 
		   `(coerce ,id foreign
			    ()
			    ((lambda (,(symbol-append 'x:: id))
				(,id->bid ',bid x))))
		   
		   `(coerce ,bid    ,id ()      (,bid->id))
		   `(coerce foreign ,id (,bid?) (,bid->id))))
      t))
		   
;*---------------------------------------------------------------------*/
;*    declare-c-enum-accessors! ...                                    */
;*---------------------------------------------------------------------*/
(define (declare-c-enum-accessors! alias type)
   (add-c-enum! (vector alias type)))

      
