;*---------------------------------------------------------------------*/
;*    Copyright (c) 1996 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    .../prgm/project/bigloo/comptime1.8/Cforeign/function.scm        */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Fri Jul  7 15:18:00 1995                          */
;*    Last change :  Tue Apr  9 14:19:35 1996 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The installation of c functions.                                 */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module cforeign_install-c-function
   (include "Type/type.sch"
	    "Ast/ast.sch")
   (import  tools_error
	    tools_shape
	    tools_args
	    parse_cforeign
	    parse_static-export
	    ast_env
	    engine_param
	    cforeign_type
	    type_env
	    type_coercion)
   (export  (install-c-function-accessors!)
	    (add-c-function! a)))

;*---------------------------------------------------------------------*/
;*    *max-foreign-arity* ...                                          */
;*---------------------------------------------------------------------*/
(define *max-foreign-arity* 16)

;*---------------------------------------------------------------------*/
;*    install-c-function-accessors! ...                                */
;*---------------------------------------------------------------------*/
(define (install-c-function-accessors!)
   (let loop ((l   (get-c-function-list))
	      (res '()))
      (if (null? l)
	  res
	  (loop (cdr l) (append (make-c-function-access (car l)) res)))))

;*---------------------------------------------------------------------*/
;*    make-c-function-access ...                                       */
;*---------------------------------------------------------------------*/
(define (make-c-function-access tinfo)
   (let ((type (vector-ref tinfo 0)))
      (if (type? (type-alias type))
	  (make-c-function-access-alias tinfo)
	  (make-c-function-access-unalias tinfo))))
	  
;*---------------------------------------------------------------------*/
;*    make-c-function-access-alias ...                                 */
;*---------------------------------------------------------------------*/
(define (make-c-function-access-alias tinfo)
   (let* ((t              (vector-ref tinfo 0))
	  (at             (get-aliased-type t))
	  (t-id           (type-id t))
	  (at-id          (type-id at))
	  (bt             (vector-ref tinfo 1))
	  (bt-id          (type-id bt))

	  (t-exp          (vector-ref tinfo 2))

	  (bt-id?         (symbol-append 'b t-id '?))
	  (call-id        (symbol-append t-id '-call))
	  (call-aid       (symbol-append at-id '-call)))

      ;; type checker
      (define (btid?)
	 `(define-inline (,(symbol-append bt-id? '::bool) o::obj)
	     (if (foreign? o)
		 (eq? (foreign-id o) ',bt-id)
		 #f)))
	     
      ;; equality
      (define (=id)
	 `(define-inline (,(symbol-append '= t-id '::bool)
			  ,(symbol-append 'o1:: at-id)
			  ,(symbol-append 'o2:: at-id))
	     (,(symbol-append 'c-= at-id) o1 o2)))

      ;; applier
      (define (call-tid)
	 (let* ((tres        (cadr t-exp))
		(targs       (caddr t-exp))
		(args        (map gensym targs)))
	    `(define-inline (,(symbol-append call-id ':: tres)
			     ,(symbol-append 'f:: at-id)
			     ,@(map (lambda (arg type)
				       (symbol-append arg ':: type))
				    args targs))
		(,(symbol-append 'c- call-aid) f ,@args))))
			  
      ;; in safe mode, the predicate bid? should not be removed
      ;; until type coercion. Then, we mark it as used with this
      ;; simili-hack
      (if (not *unsafe-type*)
	  (begin
	     (parse-static (list
			    `(inline ,(symbol-append bt-id? '::bool) o::obj)))
	     (let ((btid? (find-global bt-id?)))
		(global-import-set! btid? 'export)
		(global-occurrence-set! btid? 1000))))

      (list (btid?) (=id) (call-tid))))
   
;*---------------------------------------------------------------------*/
;*    make-c-function-access-unalias ...                               */
;*---------------------------------------------------------------------*/
(define (make-c-function-access-unalias tinfo)   
   (let* ((t              (vector-ref tinfo 0))
	  (t-id           (type-id t))
	  (bt             (vector-ref tinfo 1))
	  (bt-id          (type-id bt))

	  (t-exp          (vector-ref tinfo 2))

	  (nb-args        (let loop ((args (caddr t-exp))
				     (n    0))
			     (cond
				((null? args)
				 n)
				((not (pair? args))
				 (negfx (+fx n 1)))
				(else
				 (loop (cdr args)
				       (+fx n 1))))))
	  
	  (bid?           (vector-ref tinfo 3))
	  (bid->id        (vector-ref tinfo 4))
	  (id->bid        (vector-ref tinfo 5))
	  
	  (call-id        (symbol-append t-id '-call)))

      (define (btid?)
	 `(define-inline (,(symbol-append bid? '::bool) o::obj)
	     (if (foreign? o)
		 (eq? (foreign-id o) ',bt-id)
		 #f)))
	     
      ;; the internal equality macro
      (define (c-=id)
	 `(infix macro bool ,(symbol-append 'c-= t-id)
		 (,t-id ,t-id)
		 "=="))
	     
      ;; equality (using ==)
      (define (=id)
	 `(define-inline (,(symbol-append '= t-id '::bool)
			  ,(symbol-append 'o1:: t-id)
			  ,(symbol-append 'o2:: t-id))
	     (,(symbol-append 'c-= t-id) o1 o2)))

      ;; the two conversion allocation functions (they are not
      ;; simple coercion because the first one allocate and the
      ;; second one destructurate).
      (define (tid->btid)
	 `(macro ,bt-id ,id->bid (symbol ,t-id) "cobj_to_foreign"))

      (define (btid->tid)
	 `(macro ,t-id ,bid->id (,bt-id) "FOREIGN_TO_COBJ"))

      (define (c-call-tid)
	 (if (>=fx nb-args 0)
	     (fix-args-c-call-tid)
	     (va-args-c-call-tid)))
      
      (define (fix-args-c-call-tid)
	 (let* ((tres        (cadr t-exp))
		(targs       (caddr t-exp))
		(s-nb-args   (integer->string nb-args))
		(caller-name (string-append "C_FUNCTION_CALL_" s-nb-args)))
	    (if (>fx nb-args *max-foreign-arity*)
		(user-error
		 t-id
		 (string-append "Too large arity for a foreign function (max"
				(integer->string *max-foreign-arity*)
				")")
		 (string-append s-nb-args " args provided"))
		`(macro ,tres
		    ,(symbol-append 'c- call-id)
		    ,(cons t-id targs) ,caller-name))))

      (define (va-args-c-call-tid)
	 (user-error "bigloo"
		     "Can't manage pointers on C multiple arity functions"
		     t-id))

      (define (call-tid)
	 (if (>=fx nb-args 0)
	     (fix-args-call-tid)
	     (va-args-call-tid)))

      (define (fix-args-call-tid)
	 (let* ((tres        (cadr t-exp))
		(targs       (caddr t-exp))
		(args        (map gensym targs)))
	 `(define-inline (,(symbol-append call-id ':: tres)
			  ,(symbol-append 'f:: t-id)
			  ,@(map (lambda (arg type)
				    (symbol-append arg ':: type))
				 args targs))
	     (,(symbol-append 'c- call-id) f ,@args))))

      (define (va-args-call-tid)
	 (user-error "bigloo"
		     "Can't manage pointers on C multiple arity functions"
		     t-id))
			  
      ;; in safe mode, the predicate bid? should not be removed
      ;; until type coercion. Then, we mark it as used with this
      ;; simili-hack
      (if (not *unsafe-type*)
	  (begin
	     (parse-static (list
			    `(inline ,(symbol-append bid? '::bool) o::obj)))
	     (let ((btid? (find-global bid?)))
		(global-import-set! btid? 'export)
		(global-occurrence-set! btid? 1000))))

      (parse-c-foreign (list (tid->btid)
			     (btid->tid)
			     (c-=id)
			     (c-call-tid))
		       'import)

      (list (btid?) (=id) (call-tid))))
      

;*---------------------------------------------------------------------*/
;*    *c-function-list* ...                                            */
;*---------------------------------------------------------------------*/
(define *c-function-list* '())

;*---------------------------------------------------------------------*/
;*    add-c-function! ...                                              */
;*---------------------------------------------------------------------*/
(define (add-c-function! s)
   (set! *c-function-list* (cons s *c-function-list*)))

;*---------------------------------------------------------------------*/
;*    get-c-function-list ...                                          */
;*---------------------------------------------------------------------*/
(define (get-c-function-list)
   (reverse! *c-function-list*))









   
