;*---------------------------------------------------------------------*/
;*    Copyright (c) 1996 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.8/Cfa/location.scm         */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Mon Jul 10 11:43:12 1995                          */
;*    Last change :  Mon Jul 10 12:11:32 1995 (serrano)                */
;*    -------------------------------------------------------------    */
;*    Location is a very special function because it takes the         */
;*    address of variables. Hence, located variable have to be         */
;*    of obj type. We are oblige to make a special behaviour for       */
;*    location because we must said that variable located are          */
;*    of obj type.                                                     */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module cfa_location
   (include "Tools/trace.sch"
	    "Ast/node.sch"
	    "Type/type.sch"
	    "Cfa/approx.sch"
	    "Cfa/stack.sch")
   (import  cfa_ast
	    cfa_approx
	    cfa_cfa
	    cfa_collect
	    cfa_cache
	    cfa_top
	    cfa_stack
	    engine_param
	    type_cache
	    tools_shape
	    tools_set
	    ast_typeof
	    ast_dump)
   (export  (start-cfa-location!)
	    (stop-cfa-location!)))
   
;*---------------------------------------------------------------------*/
;*    start-cfa-location! ...                                          */
;*---------------------------------------------------------------------*/
(define (start-cfa-location!)
   (ffunction-cfa-info-set! (global-value *location*)
			    (ispecial location-approx
				      #f
				      #unspecified
				      #unspecified
				      location-app!))
   #t)

;*---------------------------------------------------------------------*/
;*    stop-cfa-location! ...                                           */
;*---------------------------------------------------------------------*/
(define (stop-cfa-location!)
   (ffunction-cfa-info-set! (global-value *location*) #unspecified)
   #t)

;*---------------------------------------------------------------------*/
;*    location-approx ...                                              */
;*---------------------------------------------------------------------*/
(define (location-approx ast)
   (create-approx (list *obj*) '()))

;*---------------------------------------------------------------------*/
;*    location-app! ...                                                */
;*---------------------------------------------------------------------*/
(define (location-app! call-ast fun actuals-approx)
   (let ((actual (car (app-actuals call-ast))))
      (if (not (var? actual))
	  (internal-error "location-app!"
			  "Illegal `location' call"
			  (shape call-ast))
	  (let ((var (var-variable actual)))
	     (add-obj! (get-approx var))
	     (add-top! (get-approx var))
	     (spread-top! (car actuals-approx))
	     (add-obj! (car actuals-approx))
	     (add-top! (car actuals-approx))
	     (get-approx call-ast)))))
