;*---------------------------------------------------------------------*/
;*    Copyright (c) 1996 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.8/Cfa/closure.scm          */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Thu Mar  9 15:42:17 1995                          */
;*    Last change :  Fri Feb  9 16:02:45 1996 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The closure optimization and funcall type error checks.          */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module cfa_closure
   (include "Tools/trace.sch"
	    "Ast/node.sch"
	    "Type/type.sch"
	    "Cfa/approx.sch")
   (import  cfa_approx
	    cfa_cache
	    cfa_collect
	    cfa_dead
	    cfa_special
	    cfa_procedure
	    engine_param
	    type_cache
	    ast_dump
	    tools_set
	    tools_shape
	    tools_speek)
   (export  (closure-optimization!)
	    (get-funcall-list)
	    (get-closure-list)
	    (add-closure-access! <ast>)
	    (add-closure!        <ast>)
	    (add-funcall!        <ast>)))

;*---------------------------------------------------------------------*/
;*    `info-closure' structure ...                                     */
;*---------------------------------------------------------------------*/
(define-struct info-closure
   X     ;; boolean : does the function satisfy the X predicate ?
   T     ;; boolean : does the function satisfy the T predicate ?
   size) ;; integer : the closure size (used for X closure)

;*---------------------------------------------------------------------*/
;*    *funcall-list* ...                                               */
;*---------------------------------------------------------------------*/
(define *funcall-list* '())

;*---------------------------------------------------------------------*/
;*    add-funcall! ...                                                 */
;*---------------------------------------------------------------------*/
(define (add-funcall! ast)
   [assert check (ast) (funcall? ast)]
   (set! *funcall-list* (cons ast *funcall-list*)))

;*---------------------------------------------------------------------*/
;*    get-funcall-list ...                                             */
;*---------------------------------------------------------------------*/
(define (get-funcall-list)
   *funcall-list*)

;*---------------------------------------------------------------------*/
;*    *closure-list* ...                                               */
;*---------------------------------------------------------------------*/
(define *closure-list* '())

;*---------------------------------------------------------------------*/
;*    add-closure! ...                                                 */
;*---------------------------------------------------------------------*/
(define (add-closure! ast)
   [assert check (ast) (is-closure-alloc? ast)]
   (set! *closure-list* (cons ast *closure-list*)))

;*---------------------------------------------------------------------*/
;*    get-closure-list ...                                             */
;*---------------------------------------------------------------------*/
(define (get-closure-list)
   *closure-list*)

;*---------------------------------------------------------------------*/
;*    *closure-access-list* ...                                        */
;*---------------------------------------------------------------------*/
(define *closure-access-list* '())

;*---------------------------------------------------------------------*/
;*    add-closure-access! ...                                          */
;*---------------------------------------------------------------------*/
(define (add-closure-access! ast)
   (set! *closure-access-list* (cons ast *closure-access-list*)))

;*---------------------------------------------------------------------*/
;*    closure-optimization! ...                                        */
;*---------------------------------------------------------------------*/
(define (closure-optimization!)
   (trace cfa
	  #\Newline "--------------------------------------"
	  #\Newline "closure-optimization! :" #\Newline)
   (for-each (lambda (c)
		(trace cfa
		       "  " (ast->sexp c) " : "
		       (approx-shape (get-approx c))
		       #\Newline))
	     *closure-list*)
   ;; first, we allocate info-closure structure for each closure.
   (for-each (lambda (clo)
		(let ((fun    (closure->function clo))
		      (approx (get-approx clo))
		      (sz     (caddr (app-actuals clo))))
		   (if (or (approx-top? approx)
			   (approx-exported? approx)
			   (dead-function? fun)
			   (<fx (function-arity (global-value fun)) 0)
			   (or (not (atom? sz))
			       (not (integer? (atom-value sz)))
			       ;; procedure with no free variable
			       ;; can be leight neither extra-light
			       ;; because they are already optimized
			       ;; by the constant compilation.
			       (<=fx (atom-value sz) 0))
			   (eq? (global-import fun) 'export)
			   (eq? (global-import fun) 'import))
		       (global-cfa-info-set! fun
					     (info-closure #f
							   #f
							   #unspecified))
		       (global-cfa-info-set! fun
					     (info-closure #t
							   #t
							   (atom-value sz))))))
	     *closure-list*)
   (X! *funcall-list*)
   (T-fix-point! *funcall-list*)
   ;; we print the result
   (show-X-T *closure-list*)
   ;; then, we have to scan, all funcall and function-ref and function-set
   ;; in order to change them according to procedure's classifications
   ;; and free variables types.
   (light-closure!)
   'done)

;*---------------------------------------------------------------------*/
;*    X! ...                                                           */
;*    -------------------------------------------------------------    */
;*    If type checks are omitted, a funcall which can apply            */
;*    procedure or other types, do not prevent optimization of         */
;*    the called functions.                                            */
;*---------------------------------------------------------------------*/
(define (X! funcall-list)
   (trace cfa "X! ... " #\Newline)
   (for-each (lambda (call)
		(trace cfa
		       "funcall: " (ast->sexp call) #\Newline
		       " approx: " (approx-shape
				    (get-approx (funcall-fun call)))
		       #\Newline)
		(let* ((fun        (funcall-fun call))
		       (approx     (get-approx fun))
		       (alloc-list (set->list (approx-alloc approx)))
		       (type-list  (set->list (approx-type approx))))
		   (cond
		      ((null? alloc-list)
		       (trace cfa #"    ok.\n")
		       'ok)
		      ((and (null? (cdr alloc-list))
			    (or *unsafe-type*
				(and (pair? type-list)
				     (null? (cdr type-list)))))
		       (trace cfa #"    ok.\n")
		       'ok)
		      (else
		       ;; several function can be applied, the
		       ;; closure does not satisfy X.
		       (for-each (lambda (clo)
				    (if (is-closure-alloc? clo)
					(begin
					   (trace cfa #"    nok: "
						  (shape clo) #\Newline)
					   (info-closure-X-set!
					    (global-cfa-info
					     (closure->function clo))
					    #f))))
				 alloc-list)))))
	     funcall-list))
   
;*---------------------------------------------------------------------*/
;*    T-fix-point! ...                                                 */
;*    -------------------------------------------------------------    */
;*    The computation of T require a fix point under all the funcall.  */
;*    -------------------------------------------------------------    */
;*    If type checks are omitted, a funcall which can apply            */
;*    procedure or other types, do not prevent optimization of         */
;*    the called functions.                                            */
;*---------------------------------------------------------------------*/
(define (T-fix-point! funcall)
   (trace cfa "T-fix-point! ... " #\Newline)
   (let loop ((continue? #t))
      (if (not continue?)
	  #unspecified
	  (let ((continue? #f))
	     (for-each
	      (lambda (call)
		 (trace cfa
			"funcall: " (ast->sexp call) #\Newline
			" approx: " (approx-shape
				     (get-approx (funcall-fun call)))
			#\Newline)
		 (let* ((fun    (funcall-fun call))
			(approx (get-approx fun))
			(clo    (set->list (approx-alloc approx)))
			(type   (set->list (approx-type approx))))
		    (trace cfa
			   "   approx: " (shape approx) #\Newline
			   "     type: " (shape type) #\Newline)
		    (let loop ((one-non-T? (or (approx-top? approx)
					       (not
						(or (and (pair? type)
							 (null? (cdr type)))
						    *unsafe-type*))))
			       (clos       clo))
		       (trace cfa
			      "      one-non-T?: " one-non-T?
			      #\newline
			      "            clos: " (map ast->sexp clos)
			      #\Newline)
		       (cond
			  ((null? clos)
			   'done)
			  (one-non-T?
			   (for-each
			    (lambda (c)
			       (if (is-closure-alloc? c)
				   (let* ((fun (closure->function c))
					  (ic  (global-cfa-info fun)))
				      (if (info-closure-T ic)
					  (begin
					     (info-closure-T-set! ic #f)
					     (set! continue? #t))))))
			    clo))
			  ((is-closure-alloc? (car clos))
			   (let* ((fun (closure->function (car clos)))
				  (ic  (global-cfa-info fun)))
			      (if (info-closure-T ic)
				  (loop one-non-T? (cdr clos))
				  (loop #t clos))))
			  (else
			   (if *unsafe-type*
			       (loop one-non-T? (cdr clos))
			       (loop #t clos)))))))
	      funcall)
	     (loop continue?)))))

;*---------------------------------------------------------------------*/
;*    light-closure! ...                                               */
;*---------------------------------------------------------------------*/
(define (light-closure!)
   (light-funcall!)
   (light-access!)
   (light-make-procedure!))

;*---------------------------------------------------------------------*/
;*    light-make-procedure! ...                                        */
;*    -------------------------------------------------------------    */
;*    Globalize pass (in file Globalize/free.scm) has set the class    */
;*    field for global procedure to 'sprocedure. In must remove this   */
;*    for optimized procedure otherwise the Cgen pass will crash in    */
;*     the sprocedure prototypes emmission.                            */
;*---------------------------------------------------------------------*/
(define (light-make-procedure!)
   (define (closure->extra-light-closure clo fun ifun)
      (cond
	 ((=fx (info-closure-size ifun) 1)
	  (if (and (global? fun)
		   (global? (function-the-closure (global-value fun))))
	      (global-class-set! (function-the-closure (global-value fun))
				 'procedure))
	  (var-variable-set! (app-fun clo) *make-el-procedure-1*))
	 ((eq? fun *make-s-fx-procedure*)
	  (var-variable-set! (app-fun clo) *make-s-el-procedure*))
	 (else
	  (var-variable-set! (app-fun clo) *make-el-procedure*)))
      (app-actuals-set!  clo (cddr (app-actuals clo))))
   (define (closure->light-closure clo fun)
      (if (and (global? fun)
	       (global? (function-the-closure (global-value fun))))
	  (global-class-set! (function-the-closure (global-value fun))
			     'procedure))
      (if (eq? fun *make-s-fx-procedure*)
	  (var-variable-set! (app-fun clo) *make-s-l-procedure*)
	  (var-variable-set! (app-fun clo) *make-l-procedure*))
      (set-cdr! (app-actuals clo) (cddr (app-actuals clo))))
   ;; we change the procedure allocation sites
   (for-each (lambda (clo)
		(let* ((fun  (closure->function clo))
		       (ifun (global-cfa-info fun)))
		   (cond
		      ((not (info-closure? ifun))
		       #unspecified)
		      ((info-closure-X ifun)
		       (closure->extra-light-closure clo fun ifun))
		      ((info-closure-T ifun)
		       (closure->light-closure clo fun))
		      (else
		       #unspecified))))
		*closure-list*))

;*---------------------------------------------------------------------*/
;*    light-funcall! ...                                               */
;*---------------------------------------------------------------------*/
(define (light-funcall!)
   ;; we annote funcall site
   (for-each (lambda (call)
		(trace cfa "light-funcall!: " (shape call) " ... ")
		(let* ((fun        (funcall-fun call))
		       (approx     (get-approx fun))
		       (alloc-list (set->list (approx-alloc approx))))
		   (trace cfa "[alloc-list: " (shape alloc-list) #\])
		   (cond
		      ((or (not (pair? alloc-list))
			   (not (is-closure-alloc? (car alloc-list))))
		       (trace cfa "heavy1" #\Newline)
		       'nothing-to-do)
		      ((info-closure-X (global-cfa-info
					(closure->function
					 (car alloc-list))))
		       (funcall-fun-set! call (ast-var #f
						       #f
						       #f
						       (closure->function
							(car alloc-list))))
		       (trace cfa "extra-light" #\Newline)
		       (funcall-strength-set! call 'extra-light))
		      ((info-closure-T (global-cfa-info
					(closure->function
					 (car alloc-list))))
		       (trace cfa "light" #\Newline)
		       (funcall-strength-set! call 'light))
		      (else
		       (trace cfa "heavy2" #\Newline)
		       'nothing-to-do))))
	     *funcall-list*))

;*---------------------------------------------------------------------*/
;*    light-access! ...                                                */
;*---------------------------------------------------------------------*/
(define (light-access!)
   ;; we change procedure accesses
   (for-each
    (lambda (access)
       (let* ((approx     (get-approx (car (app-actuals access))))
	      (alloc-list (set->list (approx-alloc approx))))
	  (cond
	     ((or (not (pair? alloc-list))
		  (not (is-closure-alloc? (car alloc-list))))
	      'nothing-to-do)
	     ((info-closure-X (global-cfa-info
			       (closure->function
				(car alloc-list))))
	      (if (=fx (info-closure-size
			(global-cfa-info
			 (closure->function (car alloc-list))))
		       1)
		  (if (eq? (var-variable (app-fun access)) *procedure-ref*)
		      (var-variable-set! (app-fun access)
					 *procedure-1-el-ref*)
		      (var-variable-set! (app-fun access)
					 *procedure-1-el-set!*))
		  (if (eq? (var-variable (app-fun access)) *procedure-ref*)
		      (var-variable-set! (app-fun access)
					 *procedure-el-ref*)
		      (var-variable-set! (app-fun access)
					 *procedure-el-set!*)))
	      'done)
	     ((info-closure-T (global-cfa-info
			       (closure->function
				(car alloc-list))))
	      (if (eq? (var-variable (app-fun access)) *procedure-ref*)
		  (var-variable-set! (app-fun access) *procedure-l-ref*)
		  (var-variable-set! (app-fun access) *procedure-l-set!*))
	      'done)
	     (else
	      'nothing-to-do))))
    *closure-access-list*))

;*---------------------------------------------------------------------*/
;*    show-X-T ...                                                     */
;*---------------------------------------------------------------------*/
(define (show-X-T clo)
   (define (show prop l)
      (if (null? l)
	  #unspecified
	  (begin
	     (verbose 2 "           " prop ": " (shape (car l)) #\Newline)
	     (for-each (lambda (x)
			  (verbose 2 "              " (shape x) #\newline))
		       (cdr l)))))
   (let loop ((X  '())
	      (T  '())
	      (clo clo))
      (if (null? clo)
	  (begin
	     (show 'X X)
	     (show 'T T)
	     #unspecified)
	  (let* ((glo (closure->function (car clo)))
		 (ic  (global-cfa-info glo)))
	     (cond
		((info-closure-X ic)
		 (loop (cons glo X) T (cdr clo)))
		((info-closure-T ic)
		 (loop X (cons glo T) (cdr clo)))
		(else
		 (loop X T (cdr clo))))))))
		       
